import requests
from django.conf import settings
from .constants import HRENPACK_THEME_STYLE_CONFIG_URL

BASE_DIR = settings.BASE_DIR
NODE_MODULES_DIR = getattr(settings, 'NODE_MODULES_DIR', BASE_DIR / 'node_modules')
ALLOWED_NODE_MODULES = getattr(settings, 'ALLOWED_NODE_MODULES', '__all__')

CACHE_HRENPACK_THEME_STYLE_CONFIG = getattr(settings, 'CACHE_HRENPACK_THEME_STYLE_CONFIG', True)

# Кеширование конфига при импорте модуля
if CACHE_HRENPACK_THEME_STYLE_CONFIG:
    CACHED_HRENPACK_THEME_STYLE_CONFIG = requests.get(HRENPACK_THEME_STYLE_CONFIG_URL).json()
else:
    CACHED_HRENPACK_THEME_STYLE_CONFIG = None

__all__ = [
    'BASE_DIR', 'NODE_MODULES_DIR', 'ALLOWED_NODE_MODULES',
    'CACHE_HRENPACK_THEME_STYLE_CONFIG', 'CACHED_HRENPACK_THEME_STYLE_CONFIG'
]
