import os
from typing import Optional
from django.urls import reverse
from .base import change_dir, NODE_MODULES_DIR


def get_hrenpack_base_context(package_name: str, is_local: bool, version: Optional[str] = None):
    """Общая функция для получения базового контекста hrenpack пакетов"""
    if is_local:
        base_url = reverse('local_node_file', kwargs={'path': package_name}).replace('\\', '/').rstrip('/')
    else:
        base_url = f"https://cdn.jsdelivr.net/npm/{package_name}{('@' + version) if version else ''}"
    return base_url


def get_local_check(package_name: str, version: Optional[str] = None) -> bool:
    """Проверка локального наличия пакета"""
    with change_dir(NODE_MODULES_DIR):
        return os.path.isdir(NODE_MODULES_DIR / package_name) and version is None
