import requests
from typing import Optional
from django.urls import reverse
from .base import get_package_latest_version


def get_hrenpack_js_jsdelivr_base_url(version: Optional[str] = None) -> str:
    return f"https://cdn.jsdelivr.net/npm/hrenpack_js{('@' + version) if version else ''}"


def get_local_hrenpack_js_base_url() -> str:
    return reverse('local_node_file', kwargs=dict(path='hrenpack_js')).replace('\\', '/').rstrip('/')


def get_hrenpack_js_files(version: Optional[str] = None, without_extension: bool = False, files_extension: str = '.js'):
    if version is None:
        version = get_package_latest_version('hrenpack_js')
    data = requests.get(f'https://data.jsdelivr.com/v1/package/npm/hrenpack_js@{version}/flat').json()
    output = list()
    for file in data['files']:
        name = file['name']
        if name.startswith('index'):
            continue
        if name.endswith(files_extension):
            name = name[1:]
            if without_extension:
                name = name[:-4]
            output.append(name)
    return output
