import requests, os
from typing import Optional
from django.urls import reverse
from .. import CACHE_HRENPACK_THEME_STYLE_CONFIG, CACHED_HRENPACK_THEME_STYLE_CONFIG, HRENPACK_THEME_STYLE_CONFIG_URL, \
    NODE_MODULES_DIR


def get_hrenpack_theme_style_jsdelivr_base_url(version: Optional[str] = None) -> str:
    return f"https://cdn.jsdelivr.net/npm/hrenpack-theme-style{('@' + version) if version else ''}"


def hrenpack_theme_style_config() -> dict:
    if CACHE_HRENPACK_THEME_STYLE_CONFIG:
        return CACHED_HRENPACK_THEME_STYLE_CONFIG
    return requests.get(HRENPACK_THEME_STYLE_CONFIG_URL).json()


def get_local_hrenpack_theme_style_base_url():
    return reverse('local_node_file', kwargs=dict(path='hrenpack-theme-style')).replace('\\', '/').rstrip('/')


def get_hrenpack_theme_style_files(config: str, file_type: str):
    """Получение файлов из конфига hrenpack-theme-style"""
    config_data = hrenpack_theme_style_config()
    if config not in config_data:
        raise AttributeError(f"Config {config} not found in hrenpack-theme-style")
    return config_data[config][file_type]


def get_hrenpack_theme_style_dependencies(config: str) -> list:
    return get_hrenpack_theme_style_files(config, 'dependencies')


def get_bootstrap_url():
    if 'bootstrap' in os.listdir(NODE_MODULES_DIR):
        return reverse('local_node_file', kwargs=dict(path='bootstrap/dist/css/bootstrap.min.css'))
    return 'https://cdn.jsdelivr.net/npm/bootstrap/dist/css/bootstrap.min.css'
