import requests
from django.core.exceptions import SuspiciousOperation
from django.http import Http404, HttpResponse
from static_engine.views import view_constructor
from . import NODE_MODULES_DIR, ALLOWED_NODE_MODULES

local_node_view = view_constructor(NODE_MODULES_DIR)


def local_node_file(request, path):
    if ALLOWED_NODE_MODULES != '__all__':
        for module in ALLOWED_NODE_MODULES:
            if path[1:].startswith(module):
                break
        else:
            raise Http404('Package exists, but not included in the ALLOWED_NODE_MODULES')
    return local_node_view(request, path)


def npm_node_file(request):
    url = request.GET.get('url')
    if not url:
        raise SuspiciousOperation
    response = requests.get(url)
    return HttpResponse(response.content,
                        content_type=response.headers['Content-Type'],
                        status=response.status_code)
