# Generated by Django 2.2 on 2019-04-26 08:08

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ScriptUrl',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pattern', models.CharField(help_text="Case-sensitive. A missing trailing slash does also match to files which start with the name of the pattern, e.g., '/admin' matches /admin.html too. Some major search engines allow an asterisk (*) as a wildcard and a dollar sign ($) to match the end of the URL, e.g., '/*.jpg$'.", max_length=450, verbose_name='Pattern')),
            ],
            options={
                'verbose_name': 'Script url',
                'verbose_name_plural': 'Script urls',
            },
        ),
        migrations.CreateModel(
            name='ScriptBlock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=450, verbose_name='Name')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is active')),
                ('tag', models.CharField(choices=[('head', 'Head'), ('body', 'Body')], default='head', max_length=50, verbose_name='Tag')),
                ('position', models.CharField(choices=[('top', 'Top'), ('bottom', 'Bottom')], default='top', max_length=50, verbose_name='Position')),
                ('script', models.TextField(verbose_name='Script')),
                ('order', models.PositiveIntegerField(default=0)),
                ('allowed', models.ManyToManyField(blank=True, help_text='The URLs which are allowed to include script block(s).', related_name='allowed', to='script_pattern.ScriptUrl', verbose_name='Allowed')),
                ('disallowed', models.ManyToManyField(blank=True, help_text='The URLs which are not allowed to include script block(s).', related_name='disallowed', to='script_pattern.ScriptUrl', verbose_name='Disallowed')),
            ],
            options={
                'verbose_name': 'Script block',
                'verbose_name_plural': 'Script blocks',
                'ordering': ('order',),
            },
        ),
    ]
