import os
from setuptools import setup, find_packages

base_dir = os.path.dirname(__file__)

with open(os.path.join(base_dir, "README.rst")) as f:
    long_description = f.read()

setup(
    name='django-script-pattern',
    version='0.2',
    description='Django script pattern app',
    long_description=long_description,
    long_description_content_type="text/x-rst",
    author='Maxim Shaitanov',
    author_email='maximshaitanov@gmail.com',
    url='https://gitlab.com/kastielspb/django-script-pattern',
    packages=find_packages(exclude=['tests']),
    include_package_data=True,
    license='MIT',
    install_requires=[
        'django',
        'django-jinja',
        'django-admin-sortable2'
    ],
    classifiers=[
        'Environment :: Web Environment',
        "Operating System :: OS Independent",
        "Framework :: Django",
        'Intended Audience :: Developers',
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
    ]
)
