# dockpy-cli

Docker CLI tool with async operations built on the dockpy-sdk.

## Installation

```bash
pip install dockpy-cli
```

Or with pipx (recommended for CLI usage):

```bash
pipx install dockpy-cli
```

## Quick Start

```bash
# Verify installation
dp --help

# Container operations
dp container list
dp container create nginx:latest --name my-web -d

# Image operations
dp image list
dp image pull python:3.10
```

## Commands

### Containers
```bash
dp container list              # List all containers
dp container create IMAGE      # Create a new container
dp container start CONTAINER   # Start a container
dp container stop CONTAINER    # Stop a container
dp container logs CONTAINER    # View container logs
dp container remove CONTAINER  # Remove a container
```

### Images
```bash
dp image list                  # List all images
dp image pull IMAGE            # Pull an image
dp image push IMAGE            # Push an image
dp image remove IMAGE          # Remove an image
```

## Output Formats

Supports multiple output formats:
- **Table** (default) - Formatted ASCII tables
- **JSON** - Machine-readable JSON output
- **YAML** - YAML formatted output

Example:
```bash
dp container list --format json
dp image list --format yaml
```

## Documentation

See the [main repository](https://gerrit.bbdevs.com/dockpy) for full documentation.

## License

Apache License 2.0 - See LICENSE file for details.

