# Copyright 2025 BBDevs
# Licensed under the Apache License, Version 2.0

"""System command Click entry points.

Author: A M (am@bbdevs.com)

Created At: 21 Nov 2025
"""

from __future__ import annotations

import click

from dockpycli.commands.system.command import SystemCommand
from dockpycli.config import CLIConfig


__all__ = [
    "system_df",
    "system_info",
    "system_ping",
    "system_version",
]


@click.command()
@click.pass_context
def system_info(ctx: click.Context) -> None:
    """Show Docker system information."""
    config: CLIConfig = ctx.obj.config
    cmd = SystemCommand(config)
    cmd.run(cmd._info_impl())


@click.command()
@click.pass_context
def system_df(ctx: click.Context) -> None:
    """Show Docker disk usage."""
    config: CLIConfig = ctx.obj.config
    cmd = SystemCommand(config)
    cmd.run(cmd._df_impl())


@click.command()
@click.pass_context
def system_version(ctx: click.Context) -> None:
    """Show Docker version information."""
    config: CLIConfig = ctx.obj.config
    cmd = SystemCommand(config)
    cmd.run(cmd._version_impl())


@click.command()
@click.pass_context
def system_ping(ctx: click.Context) -> None:
    """Test Docker daemon connection."""
    config: CLIConfig = ctx.obj.config
    cmd = SystemCommand(config)
    cmd.run(cmd._ping_impl())



