# Copyright 2025 BBDevs
# Licensed under the Apache License, Version 2.0

"""Shared Rich console instance.

Author: A M (am@bbdevs.com)

Created At: 08 Nov 2025
"""

from __future__ import annotations

from typing import TYPE_CHECKING

from rich.console import Console


if TYPE_CHECKING:
    from dockpycli.config import CLIConfig

__all__ = ["Console", "get_console"]

_console: Console | None = None


def get_console(config: CLIConfig | None = None) -> Console:
    """Get shared Rich console instance.

    Args:
        config: CLI configuration (for color settings)

    Returns:
        Rich Console instance
    """
    global _console  # noqa: PLW0603

    if _console is None:
        no_color = config.no_color if config else False
        _console = Console(no_color=no_color, force_terminal=True)

    return _console
