# Copyright 2025 BBDevs
# Licensed under the Apache License, Version 2.0

"""Color schemes and styles for output.

Author: A M (am@bbdevs.com)

Created At: 08 Nov 2025
"""

from __future__ import annotations

from rich.style import Style


__all__ = [
    "ERROR_STYLE",
    "INFO_STYLE",
    "STATUS_STYLES",
    "SUCCESS_STYLE",
    "WARNING_STYLE",
    "get_status_style",
]

# Status styles matching Docker CLI
STATUS_STYLES: dict[str, Style] = {
    "running": Style(color="green", bold=True),
    "exited": Style(color="yellow"),
    "created": Style(color="blue"),
    "restarting": Style(color="yellow", bold=True),
    "removing": Style(color="red"),
    "paused": Style(color="cyan"),
    "dead": Style(color="red", bold=True),
    "stopped": Style(color="yellow"),
}

# General styles
SUCCESS_STYLE = Style(color="green", bold=True)
ERROR_STYLE = Style(color="red", bold=True)
WARNING_STYLE = Style(color="yellow", bold=True)
INFO_STYLE = Style(color="blue")


def get_status_style(status: str) -> Style:
    """Get style for container/image status.

    Args:
        status: Status string (e.g., "running", "exited")

    Returns:
        Rich Style for the status
    """
    return STATUS_STYLES.get(status.lower(), Style())
