from http import HTTPStatus
from typing import Any, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.ocr_provider_dto import OcrProviderDto
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    key: Union[None, Unset, str] = UNSET,
    selection_key: Union[None, Unset, str] = UNSET,
) -> dict[str, Any]:
    params: dict[str, Any] = {}

    json_key: Union[None, Unset, str]
    if isinstance(key, Unset):
        json_key = UNSET
    else:
        json_key = key
    params["key"] = json_key

    json_selection_key: Union[None, Unset, str]
    if isinstance(selection_key, Unset):
        json_selection_key = UNSET
    else:
        json_selection_key = selection_key
    params["selectionKey"] = json_selection_key

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": "/internal/ocr/resolve",
        "params": params,
    }

    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[OcrProviderDto]:
    if response.status_code == 200:
        response_200 = OcrProviderDto.from_dict(response.json())

        return response_200

    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[OcrProviderDto]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    key: Union[None, Unset, str] = UNSET,
    selection_key: Union[None, Unset, str] = UNSET,
) -> Response[OcrProviderDto]:
    """
    Args:
        key (Union[None, Unset, str]):
        selection_key (Union[None, Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[OcrProviderDto]
    """

    kwargs = _get_kwargs(
        key=key,
        selection_key=selection_key,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: Union[AuthenticatedClient, Client],
    key: Union[None, Unset, str] = UNSET,
    selection_key: Union[None, Unset, str] = UNSET,
) -> Optional[OcrProviderDto]:
    """
    Args:
        key (Union[None, Unset, str]):
        selection_key (Union[None, Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        OcrProviderDto
    """

    return sync_detailed(
        client=client,
        key=key,
        selection_key=selection_key,
    ).parsed


async def asyncio_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    key: Union[None, Unset, str] = UNSET,
    selection_key: Union[None, Unset, str] = UNSET,
) -> Response[OcrProviderDto]:
    """
    Args:
        key (Union[None, Unset, str]):
        selection_key (Union[None, Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[OcrProviderDto]
    """

    kwargs = _get_kwargs(
        key=key,
        selection_key=selection_key,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: Union[AuthenticatedClient, Client],
    key: Union[None, Unset, str] = UNSET,
    selection_key: Union[None, Unset, str] = UNSET,
) -> Optional[OcrProviderDto]:
    """
    Args:
        key (Union[None, Unset, str]):
        selection_key (Union[None, Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        OcrProviderDto
    """

    return (
        await asyncio_detailed(
            client=client,
            key=key,
            selection_key=selection_key,
        )
    ).parsed
