from docx.abstract import api_requestor

from docx.types import (
    DocxClient,
    AttributeExtractionResponse,
    DocxRequest
)


class AttributeExtraction:

    def __init__(self, client: DocxClient):
        self._client = client

    def create(self, file_path) -> AttributeExtractionResponse:
        """
        Create an attribute extraction.
        """

        requestor = api_requestor.APIRequestor(
            client=self._client,
        )

        # parameter_payload = AttributeExtractionRequest(
        #     file_path = file_path
        # ).model_dump(exclude_none =True)

        response = requestor.request(
            options=DocxRequest(
                method="POST",
                url="/v1/document/upload/attribute-extraction-sync",
                files=file_path,
            )
        )

        # return AttributeExtractionResponse(**response)
        return response
