
from docx.types.error import DocxErrorResponse
import json


class DocxException(Exception):
    """
    Base class for all Docx exceptions.
    """
    def __init__(
            self,
            message: (DocxErrorResponse)):
        super().__init__(message)

    def __repr__(self) -> str:
        repr_message = json.dump(
            {
                "response": self.response,
            }
        )
        repr_message


class AuthenticationError(DocxException):

    """
    Raised when authentication fails.
    """
    def __init__(self, message: DocxErrorResponse):
        super().__init__(message)


class APIError(DocxException):
    """
    Raised when an API error occurs.
    """
    def __init__(self, message: DocxErrorResponse):
        super().__init__(message)
