from __future__ import annotations

from dataclasses import dataclass


import pydantic
from pydantic import ConfigDict
from typing_extensions import ClassVar

from docx.constants import BASE_URL

PYDANTIC_V2 = pydantic.VERSION.startswith("2.")


@dataclass
class DocxClient:

    api_key: str | None = None
    base_url: str | None = BASE_URL
    # encoding: str = 'utf-8'
    # max_file_size: int = 10 * 1024 * 1024  # 10 MB
    # supported_extensions: List[str] = field(
    # default_factory=lambda: ['.docx'])
    # custom_styles: Dict[str, str] = field(default_factory=dict)

    # def __post_init__(self):
    #     if not self.file_path.endswith(tuple(self.supported_extensions)):
    #         raise ValueError(f"Unsupported file extension.
    # Supported extensions are: {', '.join(self.supported_extensions)}")


class BaseModel(pydantic.BaseModel):
    model_config: ClassVar[ConfigDict] = ConfigDict(extra="allow")
