#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  style_picker.py
#
#  Copyright 2019 Dominic Davis-Foster <dominic@davis-foster.co.uk>
#
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
#
#
# generated by wxGlade 0.9.3 on Tue Apr  9 18:07:58 2019
#

import sys
import wx
#import wx.html2
#import wx.richtext

from matplotlib.figure import Figure
from matplotlib.backends.backend_wxagg import FigureCanvasWxAgg as FigureCanvas

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode
# end wxGlade


class style_picker(wx.Dialog):
	def __init__(self, parent, title="Choose Styles", label="Choose Styles: ",
				 selection_choices=None,
				 *args, **kwds
				):
		if selection_choices is None:
			selection_choices = ["o", "v", "^", "<", ">", "s", "h", "X", "D", "d"]
		self.title = title
		self.label = label
		self.selection_choices = selection_choices
		
		args = (parent,) + args
		# begin wxGlade: style_picker.__init__
		kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)
		self.main_panel = wx.Panel(self, wx.ID_ANY)
		self.move_panel = wx.Panel(self.main_panel, wx.ID_ANY)
		self.picker_list_box = wx.ListBox(self.main_panel, wx.ID_ANY, choices=[])
		
		self.picker_figure = Figure()
		
		self.picker_canvas = FigureCanvas(self.main_panel, wx.ID_ANY, self.picker_figure)
		self.add_btn = wx.Button(self.main_panel, wx.ID_ANY, u"Add 🡲")
		self.remove_btn = wx.Button(self.main_panel, wx.ID_ANY, u"🡰 Remove")
		self.selection_list_box = wx.ListBox(self.main_panel, wx.ID_ANY, choices=[])
		self.up_btn = wx.Button(self.main_panel, wx.ID_ANY, u"🡱 Up")
		self.down_btn = wx.Button(self.main_panel, wx.ID_ANY, u"🡳 Down")
		
		self.selection_figure = Figure()
		
		self.selection_canvas = FigureCanvas(self.main_panel, wx.ID_ANY, self.selection_figure)
		self.panel_1 = wx.Panel(self.main_panel, wx.ID_ANY)
		self.cancel_btn = wx.Button(self.panel_1, wx.ID_ANY, "Cancel")
		self.apply_btn = wx.Button(self.panel_1, wx.ID_ANY, "Apply")

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_LISTBOX, self.update_picker_preview, self.picker_list_box)
		self.Bind(wx.EVT_LISTBOX_DCLICK, self.add, self.picker_list_box)
		self.Bind(wx.EVT_BUTTON, self.add, self.add_btn)
		self.Bind(wx.EVT_BUTTON, self.remove, self.remove_btn)
		self.Bind(wx.EVT_LISTBOX, self.update_selection_preview, self.selection_list_box)
		self.Bind(wx.EVT_BUTTON, self.move_up, self.up_btn)
		self.Bind(wx.EVT_BUTTON, self.move_down, self.down_btn)
		self.Bind(wx.EVT_BUTTON, self.cancel, self.cancel_btn)
		self.Bind(wx.EVT_BUTTON, self.apply, self.apply_btn)
		# end wxGlade
		
		self.Bind(wx.EVT_LISTBOX_DCLICK, self.remove, self.selection_list_box)
		
		self.markers = {"point":".",
						"pixel":",",
						"circle":"o",
						"triangle_down":"v",
						"triangle_up":"^",
						"triangle_left":"<",
						"triangle_right":">",
						"tri_down":"1",
						"tri_up":"2",
						"tri_left":"3",
						"tri_right":"4",
						"octagon":"8",
						"square":"s",
						"pentagon":"p",
						"plus (filled)":"P",
						"star":"*",
						"hexagon1":"h",
						"hexagon2":"H",
						"plus":"+",
						"x":"x",
						"x (filled)":"X",
						"diamond":"D",
						"thin_diamond":"d",
						"caretleft":4,# (CARETLEFT),
						"caretright":5,# (CARETRIGHT),
						"caretup":6,# (CARETUP),
						"caretdown":7,# (CARETDOWN),
					    }
		
		for marker in self.selection_choices:
			for key in self.markers.keys():
				if marker == self.markers[key]:
					#print(key)
					self.selection_list_box.Append(key)
		if not self.selection_list_box.IsEmpty():
			self.selection_list_box.SetSelection(0)
		

		for marker in list(filter(lambda x: x not in self.selection_choices, [self.markers[y] for y in self.markers])):
			for key in self.markers.keys():
				if marker == self.markers[key]:
					#print(key)
					self.picker_list_box.Append(key)
		self.picker_list_box.SetSelection(0)



		
		self.picker_axes = self.picker_figure.add_subplot(111)
		self.selection_axes = self.selection_figure.add_subplot(111)
		self.update_picker_preview()
		self.update_selection_preview()
		



	def __set_properties(self):
		# begin wxGlade: style_picker.__set_properties
		self.SetTitle("Choose Styles")
		self.move_panel.SetMinSize((170, -1))
		self.picker_list_box.SetMinSize((170, 256))
		self.picker_canvas.SetMinSize((64, 64))
		self.selection_list_box.SetMinSize((170, 256))
		self.up_btn.SetMinSize((80, -1))
		self.down_btn.SetMinSize((80, -1))
		self.selection_canvas.SetMinSize((64, 64))
		self.main_panel.SetMinSize((450, -1))
		# end wxGlade
		self.SetTitle(self.title)
		
	def __do_layout(self):
		# begin wxGlade: style_picker.__do_layout
		parent_sizer = wx.BoxSizer(wx.HORIZONTAL)
		main_sizer = wx.BoxSizer(wx.VERTICAL)
		button_grid = wx.GridSizer(1, 2, 0, 5)
		list_grid_sizer = wx.BoxSizer(wx.HORIZONTAL)
		sizer_4 = wx.BoxSizer(wx.VERTICAL)
		selection_preview_sizer = wx.BoxSizer(wx.HORIZONTAL)
		move_grid = wx.GridSizer(1, 2, 0, 5)
		sizer_3 = wx.BoxSizer(wx.VERTICAL)
		sizer_2 = wx.BoxSizer(wx.VERTICAL)
		picker_preview_sizer = wx.BoxSizer(wx.HORIZONTAL)
		grid_sizer_copy = wx.GridSizer(1, 3, 10, 10)
		borders_label = wx.StaticText(self.main_panel, wx.ID_ANY, "Choose Styles: ")
		borders_label.SetMinSize((128, 20))
		borders_label.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
		grid_sizer_copy.Add(borders_label, 0, wx.BOTTOM, 7)
		grid_sizer_copy.Add((0, 0), 0, 0, 0)
		grid_sizer_copy.Add(self.move_panel, 1, wx.ALIGN_CENTER | wx.EXPAND, 0)
		main_sizer.Add(grid_sizer_copy, 0, 0, 0)
		sizer_2.Add(self.picker_list_box, 5, wx.EXPAND, 0)
		sizer_2.Add((0, 0), 0, 0, 0)
		preview_label = wx.StaticText(self.main_panel, wx.ID_ANY, "Preview: ")
		picker_preview_sizer.Add(preview_label, 0, 0, 0)
		picker_preview_sizer.Add(self.picker_canvas, 1, wx.EXPAND, 0)
		sizer_2.Add(picker_preview_sizer, 0, wx.EXPAND | wx.TOP, 5)
		list_grid_sizer.Add(sizer_2, 1, wx.EXPAND, 0)
		sizer_3.Add(self.add_btn, 0, wx.ALIGN_CENTER | wx.BOTTOM, 10)
		sizer_3.Add(self.remove_btn, 0, wx.ALIGN_CENTER, 0)
		list_grid_sizer.Add(sizer_3, 5, wx.ALIGN_CENTER | wx.BOTTOM, 64)
		sizer_4.Add(self.selection_list_box, 5, wx.EXPAND, 0)
		move_grid.Add(self.up_btn, 0, wx.ALIGN_CENTER, 0)
		move_grid.Add(self.down_btn, 0, wx.ALIGN_CENTER, 0)
		sizer_4.Add(move_grid, 0, wx.EXPAND, 0)
		preview_label_1 = wx.StaticText(self.main_panel, wx.ID_ANY, "Preview: ")
		selection_preview_sizer.Add(preview_label_1, 0, 0, 0)
		selection_preview_sizer.Add(self.selection_canvas, 1, wx.EXPAND, 0)
		sizer_4.Add(selection_preview_sizer, 0, wx.EXPAND | wx.TOP, 5)
		list_grid_sizer.Add(sizer_4, 1, wx.EXPAND, 0)
		main_sizer.Add(list_grid_sizer, 0, 0, 0)
		static_line_11 = wx.StaticLine(self.main_panel, wx.ID_ANY)
		main_sizer.Add(static_line_11, 0, wx.BOTTOM | wx.EXPAND | wx.TOP, 5)
		button_grid.Add(self.cancel_btn, 0, wx.ALIGN_CENTER, 0)
		button_grid.Add(self.apply_btn, 0, wx.ALIGN_CENTER, 0)
		self.panel_1.SetSizer(button_grid)
		main_sizer.Add(self.panel_1, 1, wx.ALIGN_BOTTOM | wx.ALIGN_RIGHT | wx.ALL, 5)
		self.main_panel.SetSizer(main_sizer)
		parent_sizer.Add(self.main_panel, 0, wx.ALL, 10)
		self.SetSizer(parent_sizer)
		parent_sizer.Fit(self)
		self.Layout()
		# end wxGlade
		borders_label.SetLabel(self.label)

	def move_up(self, event):  # wxGlade: style_picker.<event_handler>
		self.move(-1)
		event.Skip()

	def move_down(self, event):  # wxGlade: style_picker.<event_handler>
		self.move(1)
		event.Skip()

	def move(self, dir=1):
		selection = self.selection_list_box.GetSelection()
		selection_string = self.selection_list_box.GetString(selection)
		if self.selection_list_box.GetCount() == selection+dir or selection+dir < 0:
			return
			
		self.selection_list_box.Delete(selection)
		self.selection_list_box.InsertItems([selection_string], selection+dir)
		self.selection_list_box.SetSelection(selection+dir)

	def add(self, event):  # wxGlade: style_picker.<event_handler>
		selection = self.picker_list_box.GetSelection()
		if selection == -1:
			return
		
		selection_string = self.picker_list_box.GetString(selection)
		if selection_string == '':
			return
		
		self.selection_list_box.Append(selection_string)
		self.picker_list_box.Delete(selection)
		
		self.update_picker_preview()
		event.Skip()

	def remove(self, event):  # wxGlade: style_picker.<event_handler>
		selection = self.selection_list_box.GetSelection()
		if selection == -1:
			return
		
		selection_string = self.selection_list_box.GetString(selection)
		if selection_string == '':
			return
		
		self.picker_list_box.Append(selection_string)
		self.selection_list_box.Delete(self.selection_list_box.GetSelection())
		
		self.update_selection_preview()
		event.Skip()

	def cancel(self, event):  # wxGlade: style_picker.<event_handler>
		self.Destroy()

	def apply(self, event):  # wxGlade: style_picker.<event_handler>
		self.style_list = [self.markers[self.selection_list_box.GetString(item)] for item in range(self.selection_list_box.GetCount())]
		event.Skip()
		self.EndModal(wx.ID_OK)
		
	def update_picker_preview(self, *args):  # wxGlade: style_picker.<event_handler>
		self.update_preview(self.picker_list_box, self.picker_axes)
		self.picker_canvas.draw_idle()
	
	def update_selection_preview(self, *args):  # wxGlade: style_picker.<event_handler>
		self.update_preview(self.selection_list_box, self.selection_axes)
		self.selection_canvas.draw_idle()
	
	def update_preview(self, list_obj, axes):
		axes.clear()
		axes.axis('off')
		selection_string = list_obj.GetStringSelection()
		if selection_string == '':
			return
		
		axes.scatter(1, 1, s=200, color="red", marker=self.markers[selection_string])
	
	do_layout = __do_layout
	set_properties = __set_properties

# end of class style_picker
class colour_picker(style_picker):
	def __init__(self, parent, title="Choose Colours", label="Choose Colours: ",
				  picker_choices=None,
				 selection_choices=None,
				 *args, **kwds
				 ):
		if picker_choices is None:
			picker_choices = ['#000000',
							  '#ff0000',
							  '#ffa500',
							  '#00ff00',
							  '#0000ff',
							  '#551a8b',
							  '#008080']
		if selection_choices is None:
			selection_choices = ['#1f77b4',
								'#ff7f0e',
								'#2ca02c',
								'#d62728',
								'#9467bd',
								'#8c564b',
								'#e377c2',
								'#7f7f7f',
								'#bcbd22',
								'#17becf']
		self.title = title
		self.label = label
		self.picker_choices = picker_choices
		self.selection_choices = selection_choices
		
		args = (parent,) + args

		kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)
		# Code is the same for parent
		self.main_panel = wx.Panel(self, wx.ID_ANY)
		self.move_panel = wx.Panel(self.main_panel, wx.ID_ANY)
		self.picker_list_box = wx.ListBox(self.main_panel, wx.ID_ANY, choices=[])
		
		self.picker_figure = Figure()
		
		self.picker_canvas = FigureCanvas(self.main_panel, wx.ID_ANY, self.picker_figure)
		self.add_btn = wx.Button(self.main_panel, wx.ID_ANY, u"Add 🡲")
		self.remove_btn = wx.Button(self.main_panel, wx.ID_ANY, u"🡰 Remove")
		self.selection_list_box = wx.ListBox(self.main_panel, wx.ID_ANY, choices=[])
		self.up_btn = wx.Button(self.main_panel, wx.ID_ANY, u"🡱 Up")
		self.down_btn = wx.Button(self.main_panel, wx.ID_ANY, u"🡳 Down")
		
		self.selection_figure = Figure()
		
		self.selection_canvas = FigureCanvas(self.main_panel, wx.ID_ANY, self.selection_figure)
		self.panel_1 = wx.Panel(self.main_panel, wx.ID_ANY)
		self.cancel_btn = wx.Button(self.panel_1, wx.ID_ANY, "Cancel")
		self.apply_btn = wx.Button(self.panel_1, wx.ID_ANY, "Apply")
		
		self.set_properties()
		self.do_layout()
		
		self.Bind(wx.EVT_LISTBOX, self.update_picker_preview, self.picker_list_box)
		self.Bind(wx.EVT_LISTBOX_DCLICK, self.add, self.picker_list_box)
		self.Bind(wx.EVT_BUTTON, self.add, self.add_btn)
		self.Bind(wx.EVT_BUTTON, self.remove, self.remove_btn)
		self.Bind(wx.EVT_LISTBOX, self.update_selection_preview, self.selection_list_box)
		self.Bind(wx.EVT_BUTTON, self.move_up, self.up_btn)
		self.Bind(wx.EVT_BUTTON, self.move_down, self.down_btn)
		self.Bind(wx.EVT_BUTTON, self.cancel, self.cancel_btn)
		self.Bind(wx.EVT_BUTTON, self.apply, self.apply_btn)
		# end
		
		self.Bind(wx.EVT_LISTBOX_DCLICK, self.pick, self.selection_list_box)
		self.remove_btn.SetLabel("Remove")
		
		self.selection_list_box.AppendItems(self.selection_choices)
		if not self.selection_list_box.IsEmpty():
			self.selection_list_box.SetSelection(0)
		
		self.picker_list_box.AppendItems(self.picker_choices)
		if not self.picker_list_box.IsEmpty():
			self.picker_list_box.SetSelection(0)
		
		self.picker_axes = self.picker_figure.add_subplot(111)
		self.selection_axes = self.selection_figure.add_subplot(111)
		self.update_picker_preview()
		self.update_selection_preview()
	
	def add(self, event):
		selection = self.picker_list_box.GetSelection()
		if selection == -1:
			return
		
		selection_string = self.picker_list_box.GetString(selection)
		if selection_string == '':
			return
		
		self.selection_list_box.Append(selection_string)
		
		self.update_picker_preview()
		
		self.selection_list_box.SetSelection(self.selection_list_box.GetCount()-1)
		self.update_selection_preview()
		event.Skip()
	
	def remove(self, event):
		selection = self.selection_list_box.GetSelection()
		if selection == -1:
			return
		
		selection_string = self.selection_list_box.GetString(selection)
		if selection_string == '':
			return
		
		self.selection_list_box.Delete(self.selection_list_box.GetSelection())
		
		self.update_selection_preview()
		event.Skip()
	
	
	def apply(self, event):
		self.colour_list = [self.selection_list_box.GetString(item) for item in range(self.selection_list_box.GetCount())]
		event.Skip()
		self.EndModal(wx.ID_OK)
	
	def update_preview(self, list_obj, axes):
		axes.clear()
		axes.axis('off')
		selection_string = list_obj.GetStringSelection()
		if selection_string == '':
			return
		
		axes.scatter(1, 1, s=400, color=selection_string, marker="s")
	
	def pick(self, *args):
		selection = self.selection_list_box.GetSelection()
		if selection == -1:
			return
		
		selection_string = self.selection_list_box.GetString(selection)
		if selection_string == '':
			return
		
		colour = wx.ColourData()
		colour.SetColour(selection_string)
		
		dlg = wx.ColourDialog(self, data=colour)
		
		res = dlg.ShowModal()
		if res == wx.ID_OK:
			self.selection_list_box.Delete(selection)
			self.selection_list_box.InsertItems([dlg.GetColourData().GetColour().GetAsString(wx.C2S_HTML_SYNTAX)], selection)
			self.selection_list_box.SetSelection(selection)
			self.update_selection_preview()
			dlg.Destroy()
	
# end class colour_picker


if __name__ == "__main__":
	app = wx.App(False)
	frame = wx.Frame(None, wx.ID_ANY, "")
	dlg = colour_picker(frame)
	res = dlg.ShowModal()
	if res == wx.ID_OK:
		print(dlg.style_list)
		dlg.Destroy()
	
	print("Goodbye :)")
	sys.exit(0)
