# Dominus SDK for Python
Dominus is an entity intelligence engine.

[![Slack Status](https://img.shields.io/badge/slack-join_chat-white.svg?logo=slack&style=social)](http://openaristos.slack.com/)
[![Stack Overflow](https://img.shields.io/badge/stackoverflow-dominus-lightgrey.svg)](https://stackoverflow.com/questions/tagged/dominus)

It’s used as a tool for entity resolution, mastering, traversal, and exploration.

Dominus helps unite all of your entities and express powerful queries that you always imagined.

## Installation
Installing the Dominus python client takes just a few seconds:
```bash
pip install dominus-python-sdk
```

## Proto
This package uses grpclib for streaming using asyncio, this requires proto to be generated by:
```bash
python -m grpc_tools.protoc -I./protos --python_out=. --grpc_python_out=. --grpclib_python_out=. ./protos/dominus/DominusService.proto
```

## Examples
Explore the examples in order to gain an understanding for how to perform entity resolution. 

```bash
├── examples
│   └── basic.py
```

Copyright (C) 2020 Aristos Data, LLC