"""
Dominus Orchestrator Endpoints

Single backend URL for all services. The SDK now targets dominus-orchestrator
which consolidates all service functionality.

Usage:
    from dominus.config.endpoints import BASE_URL
"""

# Cloud Run configuration
PROJECT_NUMBER = "775398158805"
REGION = "us-east4"

# Single orchestrator URL - all services consolidated here
BASE_URL = f"https://dominus-orchestrator-production-{PROJECT_NUMBER}.{REGION}.run.app"

# Legacy aliases (all point to orchestrator now) - DEPRECATED
SOVEREIGN_URL = BASE_URL
ARCHITECT_URL = BASE_URL
ORCHESTRATOR_URL = BASE_URL
WARDEN_URL = BASE_URL


def get_base_url() -> str:
    """Get the dominus-orchestrator base URL."""
    return BASE_URL


# DEPRECATED - use get_base_url()
def get_sovereign_url(environment: str = None) -> str:
    """Deprecated: Use get_base_url() instead."""
    return BASE_URL


def get_architect_url(environment: str = None) -> str:
    """Deprecated: Use get_base_url() instead."""
    return BASE_URL


def get_service_url(service: str, environment: str = None) -> str:
    """Deprecated: Use get_base_url() instead. All services are now consolidated."""
    return BASE_URL
