/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.combinatorics;

import cc.redberry.combinatorics.IntCombinatorialPort;
import java.util.Arrays;

public final class IntTuples
implements IntCombinatorialPort {
    private static final long serialVersionUID = 4430122598334056882L;
    private final int[] upperBounds;
    private int[] current;
    private int lastUpdateDepth = -1;

    public IntTuples(int ... upperBounds) {
        IntTuples.checkWithException(upperBounds);
        this.upperBounds = upperBounds;
        this.current = new int[upperBounds.length];
        this.current[upperBounds.length - 1] = -1;
    }

    private static void checkWithException(int[] upperBounds) {
        for (int i : upperBounds) {
            if (i >= 0) continue;
            throw new IllegalArgumentException("Upper bound cannot be negative.");
        }
    }

    @Override
    public int[] take() {
        int pointer = this.upperBounds.length - 1;
        boolean next = false;
        int n = pointer;
        this.current[n] = this.current[n] + 1;
        if (this.current[pointer] == this.upperBounds[pointer]) {
            this.current[pointer] = 0;
            next = true;
        }
        while (next && --pointer >= 0) {
            next = false;
            int n2 = pointer;
            this.current[n2] = this.current[n2] + 1;
            if (this.current[pointer] != this.upperBounds[pointer]) continue;
            this.current[pointer] = 0;
            next = true;
        }
        this.lastUpdateDepth = this.lastUpdateDepth != -1 ? pointer : 0;
        if (next) {
            return null;
        }
        return this.current;
    }

    public int getLastUpdateDepth() {
        return this.lastUpdateDepth;
    }

    @Override
    public void reset() {
        Arrays.fill(this.current, 0);
        this.current[this.upperBounds.length - 1] = -1;
    }

    @Override
    public int[] getReference() {
        return this.current;
    }
}

