/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.rings.Ring;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.bigint.BigIntegerUtil;

public abstract class ARing<E>
implements Ring<E> {
    private static final long serialVersionUID = 1L;
    private final BigInteger[] perfectPowerDecomposition = new BigInteger[2];
    private volatile boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkPerfectPower() {
        if (this.initialized) return;
        BigInteger[] bigIntegerArray = this.perfectPowerDecomposition;
        synchronized (this.perfectPowerDecomposition) {
            if (this.initialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.initialized = true;
            if (this.cardinality() == null) {
                this.perfectPowerDecomposition[0] = null;
                this.perfectPowerDecomposition[1] = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            BigInteger[] ipp = BigIntegerUtil.perfectPowerDecomposition(this.cardinality());
            if (ipp == null) {
                this.perfectPowerDecomposition[0] = this.cardinality();
                this.perfectPowerDecomposition[1] = BigInteger.ONE;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.perfectPowerDecomposition[0] = ipp[0];
            this.perfectPowerDecomposition[1] = ipp[1];
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isPerfectPower() {
        this.checkPerfectPower();
        return this.perfectPowerDecomposition[1] != null && !this.perfectPowerDecomposition[1].isOne();
    }

    @Override
    public BigInteger perfectPowerBase() {
        this.checkPerfectPower();
        return this.perfectPowerDecomposition[0];
    }

    @Override
    public BigInteger perfectPowerExponent() {
        this.checkPerfectPower();
        return this.perfectPowerDecomposition[1];
    }
}

