/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.rings.Ring;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.io.Stringifiable;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.util.ArraysUtil;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FactorDecomposition<E>
implements Iterable<E>,
Stringifiable<E>,
Serializable {
    public final Ring<E> ring;
    public E unit;
    public final List<E> factors;
    public final TIntArrayList exponents;

    protected FactorDecomposition(Ring<E> ring, E unit, List<E> factors, TIntArrayList exponents) {
        this.ring = ring;
        this.unit = unit;
        this.factors = factors;
        this.exponents = exponents;
        if (!this.isUnit(unit)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.factors.iterator();
    }

    public Iterable<E> iterableWithUnit() {
        ArrayList<E> it = new ArrayList<E>();
        if (!this.ring.isOne(this.unit)) {
            it.add(this.unit);
        }
        it.addAll(this.factors);
        return it;
    }

    public boolean isUnit(E element) {
        return this.ring.isUnit(element);
    }

    public E get(int i) {
        return this.factors.get(i);
    }

    public int getExponent(int i) {
        return this.exponents.get(i);
    }

    public int size() {
        return this.factors.size();
    }

    public boolean isTrivial() {
        return this.size() == 1;
    }

    public int sumExponents() {
        return this.exponents.sum();
    }

    public void raiseExponents(long val) {
        for (int i = this.exponents.size() - 1; i >= 0; --i) {
            this.exponents.set(i, MachineArithmetic.safeToInt((long)this.exponents.get(i) * val));
        }
    }

    public FactorDecomposition<E> setUnit(E unit) {
        if (!this.isUnit(unit)) {
            throw new IllegalArgumentException("not a unit: " + unit);
        }
        this.unit = unit;
        return this;
    }

    public FactorDecomposition<E> addUnit(E unit) {
        this.unit = this.ring.multiply(this.unit, unit);
        return this;
    }

    public FactorDecomposition<E> addUnit(E unit, int exponent) {
        if (this.ring.isOne(unit)) {
            return this;
        }
        this.unit = this.ring.multiply(this.unit, this.ring.pow(unit, exponent));
        return this;
    }

    public FactorDecomposition<E> addFactor(E factor, int exponent) {
        if (this.isUnit(factor)) {
            return this.addUnit(factor, exponent);
        }
        this.factors.add(factor);
        this.exponents.add(exponent);
        return this;
    }

    public FactorDecomposition<E> addAll(FactorDecomposition<E> other) {
        this.addUnit(other.unit);
        this.factors.addAll(other.factors);
        this.exponents.addAll(other.exponents);
        return this;
    }

    FactorDecomposition<E> addNonUnitFactor(E factor, int exponent) {
        this.factors.add(factor);
        this.exponents.add(exponent);
        return this;
    }

    public FactorDecomposition<E> applyExponents() {
        ArrayList<E> newFactors = new ArrayList<E>();
        for (int i = 0; i < this.size(); ++i) {
            newFactors.add(this.ring.pow(this.factors.get(i), this.exponents.get(i)));
        }
        return new FactorDecomposition<E>(this.ring, this.unit, newFactors, new TIntArrayList(ArraysUtil.arrayOf(1, this.size())));
    }

    public FactorDecomposition<E> applyConstantFactor() {
        List newFactors = this.factors.stream().map(this.ring::copy).collect(Collectors.toList());
        if (newFactors.isEmpty()) {
            newFactors.add(this.ring.copy(this.unit));
        } else {
            newFactors.set(0, this.ring.multiplyMutable(newFactors.get(0), this.ring.copy(this.unit)));
        }
        return new FactorDecomposition<E>(this.ring, this.ring.getOne(), newFactors, new TIntArrayList(this.exponents));
    }

    public FactorDecomposition<E> dropExponents() {
        return new FactorDecomposition<E>(this.ring, this.unit, this.factors, new TIntArrayList(ArraysUtil.arrayOf(1, this.size())));
    }

    public FactorDecomposition<E> dropUnit() {
        this.unit = this.ring.getOne();
        return this;
    }

    public FactorDecomposition<E> dropFactor(int i) {
        this.exponents.removeAt(i);
        this.factors.remove(i);
        return this;
    }

    public Stream<E> stream() {
        return Stream.concat(Stream.of(this.unit), this.factors.stream());
    }

    public Stream<E> streamWithoutUnit() {
        return this.factors.stream();
    }

    public E[] toArrayWithoutUnit() {
        return this.factors.toArray(this.ring.createArray(this.size()));
    }

    public E[] toArrayWithUnit() {
        int[] array = this.factors.toArray(this.ring.createArray(1 + this.size()));
        System.arraycopy(array, 0, array, 1, this.size());
        array[0] = (int)this.unit;
        return array;
    }

    public E multiply() {
        return this.multiply0(false);
    }

    public E multiplyIgnoreExponents() {
        return this.multiply0(true);
    }

    public E squareFreePart() {
        return this.multiplyIgnoreExponents();
    }

    private E multiply0(boolean ignoreExponents) {
        E r = this.ring.copy(this.unit);
        for (int i = 0; i < this.factors.size(); ++i) {
            E tmp = ignoreExponents ? this.factors.get(i) : this.ring.pow(this.factors.get(i), this.exponents.get(i));
            r = this.ring.multiplyMutable(r, tmp);
        }
        return r;
    }

    public FactorDecomposition<E> canonical() {
        Comparable[] wr = (wrapper[])this.factors.stream().map(e -> new wrapper<Object>(this.ring, e)).toArray(wrapper[]::new);
        int[] ex = this.exponents.toArray();
        ArraysUtil.quickSort((Comparable[])wr, (int[])ex);
        this.factors.clear();
        this.exponents.clear();
        this.factors.addAll(Arrays.stream(wr).map(w -> w.el).collect(Collectors.toList()));
        this.exponents.addAll(ex);
        return this;
    }

    public <R> FactorDecomposition<R> mapTo(Ring<R> othRing, Function<E, R> mapper) {
        return FactorDecomposition.of(othRing, mapper.apply(this.unit), this.factors.stream().map(mapper).collect(Collectors.toList()), this.exponents);
    }

    public FactorDecomposition<E> apply(Function<E, E> mapper) {
        return FactorDecomposition.of(this.ring, mapper.apply(this.unit), this.factors.stream().map(mapper).collect(Collectors.toList()), this.exponents);
    }

    @Override
    public String toString(IStringifier<E> stringifier) {
        if (this.factors.isEmpty()) {
            return "(" + stringifier.stringify(this.unit) + ")";
        }
        StringBuilder sb = new StringBuilder();
        if (!this.ring.isOne(this.unit)) {
            sb.append("(").append(stringifier.stringify(this.unit)).append(")");
        }
        for (int i = 0; i < this.factors.size(); ++i) {
            if (sb.length() > 0) {
                sb.append("*");
            }
            sb.append("(").append(stringifier.stringify(this.factors.get(i))).append(")");
            if (this.exponents.get(i) == 1) continue;
            sb.append("^").append(this.exponents.get(i));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(IStringifier.dummy());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactorDecomposition factors1 = (FactorDecomposition)o;
        if (!this.unit.equals(factors1.unit)) {
            return false;
        }
        if (!this.factors.equals(factors1.factors)) {
            return false;
        }
        return this.exponents.equals(factors1.exponents);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.unit.hashCode();
        result = 31 * result + this.factors.hashCode();
        result = 31 * result + this.exponents.hashCode();
        return result;
    }

    public FactorDecomposition<E> clone() {
        return new FactorDecomposition<E>(this.ring, this.ring.copy(this.unit), this.factors.stream().map(this.ring::copy).collect(Collectors.toList()), new TIntArrayList(this.exponents));
    }

    public static <E> FactorDecomposition<E> unit(Ring<E> ring, E unit) {
        if (!ring.isUnitOrZero(unit)) {
            throw new IllegalArgumentException("not a unit");
        }
        return new FactorDecomposition<E>(ring, unit, new ArrayList(), new TIntArrayList());
    }

    public static <E> FactorDecomposition<E> empty(Ring<E> ring) {
        return FactorDecomposition.unit(ring, ring.getOne());
    }

    public static <E> FactorDecomposition<E> of(Ring<E> ring, E unit, List<E> factors, TIntArrayList exponents) {
        if (factors.size() != exponents.size()) {
            throw new IllegalArgumentException();
        }
        FactorDecomposition<E> r = FactorDecomposition.empty(ring).addUnit(unit);
        for (int i = 0; i < factors.size(); ++i) {
            r.addFactor(factors.get(i), exponents.get(i));
        }
        return r;
    }

    public static <E> FactorDecomposition<E> of(Ring<E> ring, E ... factors) {
        return FactorDecomposition.of(ring, Arrays.asList(factors));
    }

    public static <E> FactorDecomposition<E> of(Ring<E> ring, Collection<E> factors) {
        Object e2;
        TObjectIntHashMap<Object> map = new TObjectIntHashMap<Object>();
        for (Object e2 : factors) {
            map.adjustOrPutValue(e2, 1, 1);
        }
        ArrayList l = new ArrayList();
        e2 = new TIntArrayList();
        map.forEachEntry((a, b) -> {
            l.add(a);
            e2.add(b);
            return true;
        });
        return FactorDecomposition.of(ring, ring.getOne(), l, e2);
    }

    private static final class wrapper<E>
    implements Comparable<wrapper<E>> {
        final Ring<E> ring;
        final E el;

        wrapper(Ring<E> ring, E el) {
            this.ring = ring;
            this.el = el;
        }

        @Override
        public int compareTo(wrapper<E> o) {
            return this.ring.compare(this.el, o.el);
        }
    }
}

