/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.rings.FactorDecomposition;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.Coder;
import cc.redberry.rings.io.IParser;
import cc.redberry.rings.io.Stringifiable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import org.apache.commons.math3.random.RandomGenerator;

public interface Ring<E>
extends Comparator<E>,
Iterable<E>,
IParser<E>,
Stringifiable<E>,
Serializable {
    public boolean isField();

    public boolean isEuclideanRing();

    default public boolean isFinite() {
        return this.cardinality() != null;
    }

    default public boolean isFiniteField() {
        return this.isField() && this.isFinite();
    }

    public BigInteger cardinality();

    public BigInteger characteristic();

    public boolean isPerfectPower();

    public BigInteger perfectPowerBase();

    public BigInteger perfectPowerExponent();

    public E add(E var1, E var2);

    default public E add(E ... elements) {
        E r = elements[0];
        for (int i = 1; i < elements.length; ++i) {
            r = this.add(r, elements[i]);
        }
        return r;
    }

    default public E increment(E element) {
        return this.add(element, this.getOne());
    }

    default public E decrement(E element) {
        return this.subtract(element, this.getOne());
    }

    public E subtract(E var1, E var2);

    public E multiply(E var1, E var2);

    default public E multiply(E a, long b) {
        return this.multiply(a, (E)this.valueOf((E)b));
    }

    default public E multiply(E ... elements) {
        E r = elements[0];
        for (int i = 1; i < elements.length; ++i) {
            r = this.multiply(r, elements[i]);
        }
        return r;
    }

    default public E multiply(Iterable<E> elements) {
        E r = this.getOne();
        for (E e : elements) {
            r = this.multiplyMutable(r, e);
        }
        return r;
    }

    public E negate(E var1);

    default public E addMutable(E a, E b) {
        return this.add(a, b);
    }

    default public E subtractMutable(E a, E b) {
        return this.subtract(a, b);
    }

    default public E multiplyMutable(E a, E b) {
        return this.multiply(a, b);
    }

    default public E negateMutable(E element) {
        return this.negate(element);
    }

    public E copy(E var1);

    default public int signum(E element) {
        return Integer.compare(this.compare(element, this.getZero()), 0);
    }

    default public E abs(E el) {
        return this.signum(el) < 0 ? this.negate(el) : el;
    }

    default public E max(E a, E b) {
        return this.compare(a, b) < 0 ? b : a;
    }

    default public E min(E a, E b) {
        return this.compare(a, b) > 0 ? b : a;
    }

    public E[] divideAndRemainder(E var1, E var2);

    default public E quotient(E dividend, E divider) {
        return this.divideAndRemainder(dividend, divider)[0];
    }

    default public E remainder(E dividend, E divider) {
        return this.divideAndRemainder(dividend, divider)[1];
    }

    default public E divideOrNull(E dividend, E divider) {
        if (this.isOne(divider)) {
            return dividend;
        }
        E[] qd = this.divideAndRemainder(dividend, divider);
        if (qd == null) {
            return null;
        }
        if (!this.isZero(qd[1])) {
            return null;
        }
        return qd[0];
    }

    default public E divideExact(E dividend, E divider) {
        E result = this.divideOrNull(dividend, divider);
        if (result == null) {
            throw new ArithmeticException("not divisible: " + dividend + " / " + divider);
        }
        return result;
    }

    default public E divideExactMutable(E dividend, E divider) {
        return this.divideExact(dividend, divider);
    }

    public E reciprocal(E var1);

    default public E gcd(E a, E b) {
        if (this.isZero(a)) {
            return b;
        }
        if (this.isZero(b)) {
            return a;
        }
        if (this.isUnit(a)) {
            return a;
        }
        if (this.isUnit(b)) {
            return b;
        }
        if (this.isField()) {
            return a;
        }
        if (!this.isEuclideanRing()) {
            throw new UnsupportedOperationException("GCD is not supported in this ring");
        }
        E x = a;
        E y = b;
        while (true) {
            E r;
            if ((r = this.remainder(x, y)) == null) {
                throw new ArithmeticException("Not divisible with remainder: (" + x + ") / (" + y + ")");
            }
            if (this.isZero(r)) break;
            x = y;
            y = r;
        }
        return y;
    }

    default public E[] extendedGCD(E a, E b) {
        if (!this.isEuclideanRing()) {
            throw new UnsupportedOperationException("Extended GCD is not supported in this ring");
        }
        if (this.isZero(a)) {
            return this.createArray(b, this.getOne(), this.getOne());
        }
        if (this.isZero(b)) {
            return this.createArray(a, this.getOne(), this.getOne());
        }
        if (this.isField()) {
            int[] r = this.createArray((E)3);
            r[0] = (int)this.getOne();
            r[1] = (int)this.divideExact(this.reciprocal(a), this.valueOf((E)2L));
            r[2] = (int)this.divideExact(this.reciprocal(b), this.valueOf((E)2L));
            return r;
        }
        E s = this.getZero();
        E old_s = this.getOne();
        E t = this.getOne();
        E old_t = this.getZero();
        E r = b;
        E old_r = a;
        while (!this.isZero(r)) {
            E q = this.quotient(old_r, r);
            if (q == null) {
                throw new ArithmeticException("Not divisible with remainder: (" + old_r + ") / (" + r + ")");
            }
            E tmp = old_r;
            old_r = r;
            r = this.subtract(tmp, this.multiply(q, r));
            tmp = old_s;
            old_s = s;
            s = this.subtract(tmp, this.multiply(q, s));
            tmp = old_t;
            old_t = t;
            t = this.subtract(tmp, this.multiply(q, t));
        }
        int[] result = this.createArray((E)3);
        result[0] = (int)old_r;
        result[1] = (int)old_s;
        result[2] = (int)old_t;
        return result;
    }

    default public E[] firstBezoutCoefficient(E a, E b) {
        E s = this.getZero();
        E old_s = this.getOne();
        E r = b;
        E old_r = a;
        while (!this.isZero(r)) {
            E q = this.quotient(old_r, r);
            if (q == null) {
                throw new ArithmeticException("Not divisible with remainder: (" + old_r + ") / (" + r + ")");
            }
            E tmp = old_r;
            old_r = r;
            r = this.subtract(tmp, this.multiply(q, r));
            tmp = old_s;
            old_s = s;
            s = this.subtract(tmp, this.multiply(q, s));
        }
        int[] result = this.createArray((E)2);
        result[0] = (int)old_r;
        result[1] = (int)old_s;
        return result;
    }

    default public E lcm(E a, E b) {
        if (this.isZero(a) || this.isZero(b)) {
            return this.getZero();
        }
        return this.multiply(this.divideExact(a, this.gcd(a, b)), b);
    }

    default public E lcm(E ... elements) {
        if (elements.length == 1) {
            return elements[0];
        }
        E lcm = this.lcm(elements[0], elements[1]);
        for (int i = 2; i < elements.length; ++i) {
            lcm = this.lcm(lcm, elements[i]);
        }
        return lcm;
    }

    default public E lcm(Iterable<E> elements) {
        return (E)this.lcm(StreamSupport.stream(elements.spliterator(), false).toArray(this::createArray));
    }

    default public E gcd(E ... elements) {
        return this.gcd(Arrays.asList(elements));
    }

    default public E gcd(Iterable<E> elements) {
        Object gcd = null;
        for (E e : elements) {
            if (gcd == null) {
                gcd = e;
                continue;
            }
            gcd = this.gcd((E)gcd, e);
        }
        return gcd;
    }

    default public FactorDecomposition<E> factorSquareFree(E element) {
        throw new UnsupportedOperationException();
    }

    default public FactorDecomposition<E> factor(E element) {
        throw new UnsupportedOperationException();
    }

    public E getZero();

    public E getOne();

    default public E getNegativeOne() {
        return this.negate(this.getOne());
    }

    public boolean isZero(E var1);

    public boolean isOne(E var1);

    public boolean isUnit(E var1);

    default public boolean isUnitOrZero(E element) {
        return this.isUnit(element) || this.isZero(element);
    }

    default public boolean isMinusOne(E e) {
        return this.getNegativeOne().equals(e);
    }

    public E valueOf(long var1);

    public E valueOfBigInteger(BigInteger var1);

    default public E[] valueOf(long[] elements) {
        int[] array = this.createArray((E)elements.length);
        for (int i = 0; i < elements.length; ++i) {
            array[i] = (int)this.valueOf((E)elements[i]);
        }
        return array;
    }

    public E valueOf(E var1);

    default public void setToValueOf(E[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.valueOf(elements[i]);
        }
    }

    default public E[] createArray(int length) {
        return (Object[])Array.newInstance(this.getOne().getClass(), length);
    }

    default public E[][] createArray2d(int length) {
        return (Object[][])Array.newInstance(this.createArray(false).getClass(), length);
    }

    default public E[][] createArray2d(int m, int n) {
        return (Object[][])Array.newInstance(this.getOne().getClass(), m, n);
    }

    default public E[] createZeroesArray(int length) {
        int[] array = this.createArray((E)length);
        this.fillZeros(array);
        return array;
    }

    default public void fillZeros(E[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getZero();
        }
    }

    default public E[][] createZeroesArray2d(int m, int n) {
        E[][] arr;
        for (E[] a : arr = this.createArray2d(m, n)) {
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.getZero();
            }
        }
        return arr;
    }

    default public E[] createArray(E a, E b) {
        int[] array = this.createArray((E)2);
        array[0] = (int)a;
        array[1] = (int)b;
        return array;
    }

    default public E[] createArray(E a, E b, E c) {
        int[] array = this.createArray((E)3);
        array[0] = (int)a;
        array[1] = (int)b;
        array[2] = (int)c;
        return array;
    }

    default public E[] createArray(E element) {
        boolean[] array = this.createArray(true);
        array[0] = element;
        return array;
    }

    default public E pow(E base, int exponent) {
        return this.pow(base, BigInteger.valueOf(exponent));
    }

    default public E pow(E base, long exponent) {
        return this.pow(base, BigInteger.valueOf(exponent));
    }

    default public E pow(E base, BigInteger exponent) {
        if (exponent.signum() < 0) {
            return this.pow(this.reciprocal(base), exponent.negate());
        }
        if (exponent.isOne()) {
            return base;
        }
        E result = this.getOne();
        E k2p = this.copy(base);
        while (true) {
            if (exponent.testBit(0)) {
                result = this.multiplyMutable(result, k2p);
            }
            if ((exponent = exponent.shiftRight(1)).isZero()) {
                return result;
            }
            k2p = this.multiplyMutable(k2p, k2p);
        }
    }

    default public E factorial(long num) {
        Object result = this.getOne();
        int i = 2;
        while ((long)i <= num) {
            result = this.multiplyMutable(result, this.valueOf((E)i));
            ++i;
        }
        return result;
    }

    @Override
    public Iterator<E> iterator();

    default public E randomElement() {
        return this.randomElement(Rings.privateRandom);
    }

    default public E randomElement(RandomGenerator rnd) {
        return this.valueOf((E)rnd.nextLong());
    }

    default public E randomElementTree(RandomGenerator rnd) {
        return this.randomElement(rnd);
    }

    default public E randomElementTree() {
        return this.randomElementTree(Rings.privateRandom);
    }

    default public E randomNonZeroElement(RandomGenerator rnd) {
        E el;
        while (this.isZero(el = this.randomElement(rnd))) {
        }
        return el;
    }

    @Override
    default public E parse(String string) {
        return Coder.mkCoder(this).parse(string);
    }
}

