/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.io;

import cc.redberry.rings.Ring;
import cc.redberry.rings.io.Stringifiable;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public interface IStringifier<Element> {
    public static final IStringifier DUMMY = new IStringifier(){

        public IStringifier substringifier(Ring ring) {
            return this;
        }

        public Map getBindings() {
            return Collections.EMPTY_MAP;
        }
    };

    default public String stringify(Element el) {
        if (el instanceof Stringifiable) {
            return ((Stringifiable)el).toString(this);
        }
        return el.toString();
    }

    default public String stringify(Collection<Element> c) {
        return c.stream().map(this::stringify).collect(Collectors.joining(","));
    }

    public <UnderlyingElement> IStringifier<UnderlyingElement> substringifier(Ring<UnderlyingElement> var1);

    default public String getBinding(Element el) {
        return this.getBinding(el, null);
    }

    default public String getBinding(Element el, String defaultStr) {
        return this.getBindings().getOrDefault(el, defaultStr);
    }

    public Map<Element, String> getBindings();

    public static <E> IStringifier<E> dummy() {
        return DUMMY;
    }

    public static <E> IStringifier<E> mkStringifier(Map<E, String> bindings) {
        SimpleStringifier r = new SimpleStringifier();
        r.bindings.putAll(bindings);
        return r;
    }

    public static <Poly extends IPolynomial<Poly>> IStringifier<Poly> mkPolyStringifier(IPolynomialRing<Poly> ring, String ... variables) {
        HashMap<Poly, String> bindings = new HashMap<Poly, String>();
        for (int i = 0; i < ring.nVariables(); ++i) {
            bindings.put(ring.variable(i), variables[i]);
        }
        return IStringifier.mkStringifier(bindings);
    }

    public static <Poly extends IPolynomial<Poly>> IStringifier<Poly> mkPolyStringifier(Poly factory, String ... variables) {
        HashMap bindings = new HashMap();
        if (factory instanceof IUnivariatePolynomial) {
            bindings.put(((IUnivariatePolynomial)factory).createMonomial(1), variables[0]);
        } else {
            AMultivariatePolynomial mf = (AMultivariatePolynomial)factory;
            for (int i = 0; i < mf.nVariables; ++i) {
                bindings.put(mf.createMonomial(i, 1), variables[i]);
            }
        }
        return IStringifier.mkStringifier(bindings);
    }

    public static String encloseMathParenthesisInSumIfNeeded(String cf) {
        if (IStringifier.needParenthesisInSum(cf)) {
            return "(" + cf + ")";
        }
        return cf;
    }

    public static boolean needParenthesisInSum(String cf) {
        if (cf.startsWith("-") && !IStringifier.hasPlusMinus(1, cf)) {
            return false;
        }
        return IStringifier.hasPlusMinus(0, cf);
    }

    public static boolean hasPlusMinus(int start, String cf) {
        int level = 0;
        for (int i = start; i < cf.length(); ++i) {
            char c = cf.charAt(i);
            if (c == '(') {
                ++level;
                continue;
            }
            if (c == ')') {
                --level;
                continue;
            }
            if (c != '+' && c != '-' || level != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMulDivPlusMinus(int start, String cf) {
        int level = 0;
        for (int i = start; i < cf.length(); ++i) {
            char c = cf.charAt(i);
            if (c == '(') {
                ++level;
                continue;
            }
            if (c == ')') {
                --level;
                continue;
            }
            if (level != 0 || c != '+' && c != '-' && c != '*' && c != '/') continue;
            return true;
        }
        return false;
    }

    public static String[] defaultVars(int nVars) {
        if (nVars == 1) {
            return new String[]{"x"};
        }
        if (nVars == 2) {
            return new String[]{"x", "y"};
        }
        if (nVars == 3) {
            return new String[]{"x", "y", "z"};
        }
        String[] vars = new String[nVars];
        for (int i = 1; i <= nVars; ++i) {
            vars[i - 1] = "x" + i;
        }
        return vars;
    }

    public static String defaultVar(int i, int nVars) {
        if (nVars == 1) {
            return "x";
        }
        if (nVars == 2) {
            return i == 0 ? "x" : "y";
        }
        if (nVars == 3) {
            return i == 0 ? "x" : (i == 1 ? "y" : "z");
        }
        return "x" + (i + 1);
    }

    public static String defaultVar() {
        return IStringifier.defaultVar(0, 1);
    }

    public static final class SimpleStringifier<E>
    implements IStringifier<E> {
        public final Map<E, String> bindings = new HashMap<E, String>();
        public final Map<Ring, IStringifier> substringifiers = new HashMap<Ring, IStringifier>();

        @Override
        public <U> IStringifier<U> substringifier(Ring<U> ring) {
            return this.substringifiers.getOrDefault(ring, IStringifier.dummy());
        }

        @Override
        public Map<E, String> getBindings() {
            return this.bindings;
        }
    }
}

