/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.linear;

import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Ring;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.util.ArraysUtil;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;

public final class LinearSolver {
    private LinearSolver() {
    }

    public static void transposeSquare(Object[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < i; ++j) {
                Object tmp = matrix[i][j];
                matrix[i][j] = matrix[j][i];
                matrix[j][i] = tmp;
            }
        }
    }

    public static void transposeSquare(long[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < i; ++j) {
                long tmp = matrix[i][j];
                matrix[i][j] = matrix[j][i];
                matrix[j][i] = tmp;
            }
        }
    }

    public static <E> int rowEchelonForm(Ring<E> ring, E[][] matrix) {
        return LinearSolver.rowEchelonForm(ring, matrix, null, false, false);
    }

    public static <E> int rowEchelonForm(Ring<E> ring, E[][] matrix, boolean reduce) {
        return LinearSolver.rowEchelonForm(ring, matrix, null, reduce, false);
    }

    public static <E> int rowEchelonForm(Ring<E> ring, E[][] lhs, E[] rhs) {
        return LinearSolver.rowEchelonForm(ring, lhs, rhs, false, false);
    }

    public static <E> int rowEchelonForm(Ring<E> ring, E[][] lhs, E[] rhs, boolean reduce, boolean breakOnUnderDetermined) {
        if (rhs != null && lhs.length != rhs.length) {
            throw new IllegalArgumentException("lhs.length != rhs.length");
        }
        if (lhs.length == 0) {
            return 0;
        }
        int nRows = lhs.length;
        int nColumns = lhs[0].length;
        int nZeroColumns = 0;
        int to = Math.min(nRows, nColumns);
        for (int iColumn = 0; iColumn < to; ++iColumn) {
            int iRow;
            int row;
            int max = row = iColumn - nZeroColumns;
            if (ring.isZero(lhs[row][iColumn])) {
                for (iRow = row + 1; iRow < nRows; ++iRow) {
                    if (ring.isZero(lhs[iRow][iColumn])) continue;
                    max = iRow;
                    break;
                }
                ArraysUtil.swap(lhs, row, max);
                if (rhs != null) {
                    ArraysUtil.swap(rhs, row, max);
                }
            }
            if (ring.isZero(lhs[row][iColumn])) {
                if (breakOnUnderDetermined) {
                    return 1;
                }
                to = Math.min(nRows + ++nZeroColumns, nColumns);
                continue;
            }
            for (iRow = row + 1; iRow < nRows; ++iRow) {
                E alpha = ring.divideExact(lhs[iRow][iColumn], lhs[row][iColumn]);
                if (rhs != null) {
                    rhs[iRow] = ring.subtract(rhs[iRow], ring.multiply(alpha, rhs[row]));
                }
                if (ring.isZero(alpha)) continue;
                for (int iCol = iColumn; iCol < nColumns; ++iCol) {
                    lhs[iRow][iCol] = ring.subtract(lhs[iRow][iCol], ring.multiply(alpha, lhs[row][iCol]));
                }
            }
        }
        if (reduce) {
            LinearSolver.reducedRowEchelonForm(ring, lhs, rhs);
        }
        return nZeroColumns;
    }

    public static <E> void reducedRowEchelonForm(Ring<E> ring, E[][] lhs, E[] rhs) {
        int nRows = lhs.length;
        int nColumns = lhs[0].length;
        int nZeroColumns = 0;
        int to = Math.min(nRows, nColumns);
        for (int iColumn = 0; iColumn < to; ++iColumn) {
            int i;
            int iRow = iColumn - nZeroColumns;
            if (ring.isZero(lhs[iRow][iColumn])) {
                to = Math.min(nRows + ++nZeroColumns, nColumns);
                continue;
            }
            E[] row = lhs[iRow];
            E val = row[iColumn];
            E valInv = ring.reciprocal(val);
            for (i = iColumn; i < nColumns; ++i) {
                row[i] = ring.multiply(valInv, row[i]);
            }
            if (rhs != null) {
                rhs[iRow] = ring.multiply(valInv, rhs[iRow]);
            }
            for (i = 0; i < iRow; ++i) {
                E[] pRow = lhs[i];
                E v = pRow[iColumn];
                if (ring.isZero(v)) continue;
                for (int j = iColumn; j < nColumns; ++j) {
                    pRow[j] = ring.subtract(pRow[j], ring.multiply(v, row[j]));
                }
                if (rhs == null) continue;
                rhs[i] = ring.subtract(rhs[i], ring.multiply(v, rhs[iColumn]));
            }
        }
    }

    public static <E> E[] solve(Ring<E> ring, E[][] lhs, E[] rhs) {
        int nUnknowns = lhs[0].length;
        if (nUnknowns == 0) {
            return ring.createArray(false);
        }
        int[] result = ring.createArray(nUnknowns != 0);
        SystemInfo info = LinearSolver.solve(ring, lhs, rhs, result);
        if (info != SystemInfo.Consistent) {
            throw new ArithmeticException("singular or under-determined matrix");
        }
        return result;
    }

    public static <E> SystemInfo solve(Ring<E> ring, E[][] lhs, E[] rhs, E[] result) {
        return LinearSolver.solve(ring, lhs, rhs, result, false);
    }

    public static <E> SystemInfo solve(Ring<E> ring, E[][] lhs, E[] rhs, E[] result, boolean solveIfUnderDetermined) {
        int i;
        if (lhs.length != rhs.length) {
            throw new IllegalArgumentException("lhs.length != rhs.length");
        }
        if (rhs.length == 0) {
            return SystemInfo.Consistent;
        }
        if (rhs.length == 1) {
            if (lhs[0].length == 1) {
                result[0] = ring.divideExact(rhs[0], lhs[0][0]);
                return SystemInfo.Consistent;
            }
            if (solveIfUnderDetermined) {
                ring.fillZeros(result);
                if (ring.isZero(rhs[0])) {
                    return SystemInfo.Consistent;
                }
                for (int i2 = 0; i2 < result.length; ++i2) {
                    if (ring.isZero(lhs[0][i2])) continue;
                    result[i2] = ring.divideExact(rhs[0], lhs[0][i2]);
                    return SystemInfo.Consistent;
                }
                return SystemInfo.Inconsistent;
            }
            if (lhs[0].length > 1) {
                return SystemInfo.UnderDetermined;
            }
            return SystemInfo.Inconsistent;
        }
        int nUnderDetermined = LinearSolver.rowEchelonForm(ring, lhs, rhs, false, !solveIfUnderDetermined);
        if (!solveIfUnderDetermined && nUnderDetermined > 0) {
            return SystemInfo.UnderDetermined;
        }
        int nRows = rhs.length;
        int nColumns = lhs[0].length;
        if (!solveIfUnderDetermined && nColumns > nRows) {
            return SystemInfo.UnderDetermined;
        }
        if (nRows > nColumns) {
            for (i = nColumns; i < nRows; ++i) {
                if (ring.isZero(rhs[i])) continue;
                return SystemInfo.Inconsistent;
            }
        }
        if (nRows > nColumns) {
            for (i = nColumns + 1; i < nRows; ++i) {
                if (ring.isZero(rhs[i])) continue;
                return SystemInfo.Inconsistent;
            }
        }
        ring.fillZeros(result);
        if (nUnderDetermined == 0 && nColumns <= nRows) {
            for (i = nColumns - 1; i >= 0; --i) {
                E sum = ring.getZero();
                for (int j = i + 1; j < nColumns; ++j) {
                    sum = ring.add(sum, ring.multiply(lhs[i][j], result[j]));
                }
                result[i] = ring.divideExact(ring.subtract(rhs[i], sum), lhs[i][i]);
            }
            return SystemInfo.Consistent;
        }
        TIntArrayList nzColumns = new TIntArrayList();
        TIntArrayList nzRows = new TIntArrayList();
        int nZeroColumns = 0;
        int iRow = 0;
        int to = Math.min(nRows, nColumns);
        for (int iColumn = 0; iColumn < to; ++iColumn) {
            int i3;
            iRow = iColumn - nZeroColumns;
            if (ring.isZero(lhs[iRow][iColumn])) {
                if (iColumn == nColumns - 1 && !ring.isZero(rhs[iRow])) {
                    return SystemInfo.Inconsistent;
                }
                to = Math.min(nRows + ++nZeroColumns, nColumns);
                continue;
            }
            E[] row = lhs[iRow];
            E val = row[iColumn];
            E valInv = ring.reciprocal(val);
            for (i3 = iColumn; i3 < nColumns; ++i3) {
                row[i3] = ring.multiply(valInv, row[i3]);
            }
            rhs[iRow] = ring.multiply(valInv, rhs[iRow]);
            for (i3 = 0; i3 < iRow; ++i3) {
                E[] pRow = lhs[i3];
                E v = pRow[iColumn];
                if (ring.isZero(v)) continue;
                for (int j = iColumn; j < nColumns; ++j) {
                    pRow[j] = ring.subtract(pRow[j], ring.multiply(v, row[j]));
                }
                rhs[i3] = ring.subtract(rhs[i3], ring.multiply(v, rhs[iRow]));
            }
            if (!ring.isZero(rhs[iRow]) && ring.isZero(lhs[iRow][iColumn])) {
                return SystemInfo.Inconsistent;
            }
            nzColumns.add(iColumn);
            nzRows.add(iRow);
        }
        if (++iRow < nRows) {
            while (iRow < nRows) {
                if (!ring.isZero(rhs[iRow])) {
                    return SystemInfo.Inconsistent;
                }
                ++iRow;
            }
        }
        for (int i4 = 0; i4 < nzColumns.size(); ++i4) {
            result[nzColumns.get((int)i4)] = rhs[nzRows.get(i4)];
        }
        return SystemInfo.Consistent;
    }

    public static <E> SystemInfo solve(Ring<E> ring, ArrayList<E[]> lhs, ArrayList<E> rhs, E[] result) {
        return LinearSolver.solve(ring, (Object[][])lhs.toArray((T[])ring.createArray2d(lhs.size())), rhs.toArray(ring.createArray(rhs.size())), result);
    }

    public static <E> E[] solveVandermonde(Ring<E> ring, E[] row, E[] rhs) {
        int[] result = ring.createArray(rhs.length);
        SystemInfo info = LinearSolver.solveVandermonde(ring, row, rhs, result);
        if (info != SystemInfo.Consistent) {
            throw new ArithmeticException("singular or under-determined matrix");
        }
        return result;
    }

    public static <E> E[] solveVandermondeT(Ring<E> ring, E[] row, E[] rhs) {
        int[] result = ring.createArray(rhs.length);
        SystemInfo info = LinearSolver.solveVandermondeT(ring, row, rhs, result);
        if (info != SystemInfo.Consistent) {
            throw new ArithmeticException("singular or under-determined matrix");
        }
        return result;
    }

    public static <E> SystemInfo solveVandermonde(Ring<E> ring, E[] row, E[] rhs, E[] result) {
        int i;
        if (row.length != rhs.length) {
            throw new IllegalArgumentException("not a square Vandermonde matrix");
        }
        if (rhs.length == 0) {
            return SystemInfo.Consistent;
        }
        if (rhs.length == 1) {
            result[0] = rhs[0];
            return SystemInfo.Consistent;
        }
        UnivariatePolynomial[] lins = new UnivariatePolynomial[row.length];
        UnivariatePolynomial<E> master = UnivariatePolynomial.one(ring);
        for (i = 0; i < row.length; ++i) {
            lins[i] = master.createLinear(ring.negate(row[i]), ring.getOne());
            master = master.multiply(lins[i]);
        }
        for (i = 0; i < result.length; ++i) {
            result[i] = ring.getZero();
        }
        for (i = 0; i < row.length; ++i) {
            UnivariatePolynomial<E> quot = UnivariateDivision.divideAndRemainder(master, lins[i], true)[0];
            E cf = quot.evaluate(row[i]);
            if (ring.isZero(cf)) {
                return SystemInfo.UnderDetermined;
            }
            if ((quot = quot.divideOrNull(cf)) == null) {
                throw new IllegalArgumentException();
            }
            for (int j = 0; j < row.length; ++j) {
                result[j] = ring.add(result[j], ring.multiply(rhs[i], quot.get(j)));
            }
        }
        return SystemInfo.Consistent;
    }

    public static <E> SystemInfo solveVandermondeT(Ring<E> ring, E[] row, E[] rhs, E[] result) {
        int i;
        if (row.length != rhs.length) {
            throw new IllegalArgumentException("not a square Vandermonde matrix");
        }
        if (rhs.length == 0) {
            return SystemInfo.Consistent;
        }
        if (rhs.length == 1) {
            result[0] = rhs[0];
            return SystemInfo.Consistent;
        }
        UnivariatePolynomial[] lins = new UnivariatePolynomial[row.length];
        UnivariatePolynomial<E> master = UnivariatePolynomial.one(ring);
        for (i = 0; i < row.length; ++i) {
            lins[i] = master.createLinear(ring.negate(row[i]), ring.getOne());
            master = master.multiply(lins[i]);
        }
        for (i = 0; i < row.length; ++i) {
            UnivariatePolynomial<E> quot = UnivariateDivision.divideAndRemainder(master, lins[i], true)[0];
            E cf = quot.evaluate(row[i]);
            if (ring.isZero(cf)) {
                return SystemInfo.UnderDetermined;
            }
            if ((quot = quot.divideOrNull(cf)) == null) {
                throw new IllegalArgumentException();
            }
            result[i] = ring.getZero();
            for (int j = 0; j < row.length; ++j) {
                result[i] = ring.add(result[i], ring.multiply(rhs[j], quot.get(j)));
            }
        }
        return SystemInfo.Consistent;
    }

    public static int rowEchelonForm(IntegersZp64 ring, long[][] matrix) {
        return LinearSolver.rowEchelonForm(ring, matrix, false);
    }

    public static int rowEchelonForm(IntegersZp64 ring, long[][] matrix, boolean reduce) {
        return LinearSolver.rowEchelonForm(ring, matrix, null, reduce, false);
    }

    public static int rowEchelonForm(IntegersZp64 ring, long[][] lhs, long[] rhs) {
        return LinearSolver.rowEchelonForm(ring, lhs, rhs, false, false);
    }

    public static int rowEchelonForm(IntegersZp64 ring, long[][] lhs, long[] rhs, boolean reduce, boolean breakOnUnderDetermined) {
        if (rhs != null && lhs.length != rhs.length) {
            throw new IllegalArgumentException("lhs.length != rhs.length");
        }
        if (lhs.length == 0) {
            return 0;
        }
        int nRows = lhs.length;
        int nColumns = lhs[0].length;
        int nZeroColumns = 0;
        int to = Math.min(nRows, nColumns);
        for (int iColumn = 0; iColumn < to; ++iColumn) {
            int iRow;
            int row;
            int nonZero = row = iColumn - nZeroColumns;
            if (lhs[row][iColumn] == 0L) {
                for (iRow = row + 1; iRow < nRows; ++iRow) {
                    if (lhs[iRow][iColumn] == 0L) continue;
                    nonZero = iRow;
                    break;
                }
                ArraysUtil.swap((Object[])lhs, row, nonZero);
                if (rhs != null) {
                    ArraysUtil.swap(rhs, row, nonZero);
                }
            }
            if (lhs[row][iColumn] == 0L) {
                if (breakOnUnderDetermined) {
                    return 1;
                }
                to = Math.min(nRows + ++nZeroColumns, nColumns);
                continue;
            }
            for (iRow = row + 1; iRow < nRows; ++iRow) {
                long alpha = ring.divide(lhs[iRow][iColumn], lhs[row][iColumn]);
                if (rhs != null) {
                    rhs[iRow] = ring.subtract(rhs[iRow], ring.multiply(alpha, rhs[row]));
                }
                if (alpha == 0L) continue;
                for (int iCol = iColumn; iCol < nColumns; ++iCol) {
                    lhs[iRow][iCol] = ring.subtract(lhs[iRow][iCol], ring.multiply(alpha, lhs[row][iCol]));
                }
            }
        }
        if (reduce) {
            LinearSolver.reducedRowEchelonForm(ring, lhs, rhs);
        }
        return nZeroColumns;
    }

    public static void reducedRowEchelonForm(IntegersZp64 ring, long[][] lhs, long[] rhs) {
        int nRows = lhs.length;
        int nColumns = lhs[0].length;
        int nZeroColumns = 0;
        int to = Math.min(nRows, nColumns);
        for (int iColumn = 0; iColumn < to; ++iColumn) {
            int i;
            int iRow = iColumn - nZeroColumns;
            if (lhs[iRow][iColumn] == 0L) {
                to = Math.min(nRows + ++nZeroColumns, nColumns);
                continue;
            }
            long[] row = lhs[iRow];
            long val = row[iColumn];
            long valInv = ring.reciprocal(val);
            for (i = iColumn; i < nColumns; ++i) {
                row[i] = ring.multiply(valInv, row[i]);
            }
            if (rhs != null) {
                rhs[iRow] = ring.multiply(valInv, rhs[iRow]);
            }
            for (i = 0; i < iRow; ++i) {
                long[] pRow = lhs[i];
                long v = pRow[iColumn];
                if (v == 0L) continue;
                for (int j = iColumn; j < nColumns; ++j) {
                    pRow[j] = ring.subtract(pRow[j], ring.multiply(v, row[j]));
                }
                if (rhs == null) continue;
                rhs[i] = ring.subtract(rhs[i], ring.multiply(v, rhs[iRow]));
            }
        }
    }

    public static long[] solve(IntegersZp64 ring, long[][] lhs, long[] rhs) {
        int nUnknowns = lhs[0].length;
        if (nUnknowns == 0) {
            return new long[0];
        }
        long[] result = new long[nUnknowns];
        SystemInfo info = LinearSolver.solve(ring, lhs, rhs, result);
        if (info != SystemInfo.Consistent) {
            throw new ArithmeticException("singular or under-determined matrix");
        }
        return result;
    }

    public static SystemInfo solve(IntegersZp64 ring, long[][] lhs, long[] rhs, long[] result) {
        return LinearSolver.solve(ring, lhs, rhs, result, false);
    }

    public static SystemInfo solve(IntegersZp64 ring, long[][] lhs, long[] rhs, long[] result, boolean solveIfUnderDetermined) {
        int i;
        if (lhs.length != rhs.length) {
            throw new IllegalArgumentException("lhs.length != rhs.length");
        }
        if (rhs.length == 0) {
            return SystemInfo.Consistent;
        }
        if (rhs.length == 1) {
            if (lhs[0].length == 1) {
                result[0] = ring.divide(rhs[0], lhs[0][0]);
                return SystemInfo.Consistent;
            }
            if (solveIfUnderDetermined) {
                if (rhs[0] == 0L) {
                    return SystemInfo.Consistent;
                }
                for (int i2 = 0; i2 < result.length; ++i2) {
                    if (lhs[0][i2] == 0L) continue;
                    result[i2] = ring.divide(rhs[0], lhs[0][i2]);
                    return SystemInfo.Consistent;
                }
                return SystemInfo.Inconsistent;
            }
            if (lhs[0].length > 1) {
                return SystemInfo.UnderDetermined;
            }
            return SystemInfo.Inconsistent;
        }
        int nUnderDetermined = LinearSolver.rowEchelonForm(ring, lhs, rhs, false, !solveIfUnderDetermined);
        if (!solveIfUnderDetermined && nUnderDetermined > 0) {
            return SystemInfo.UnderDetermined;
        }
        int nRows = rhs.length;
        int nColumns = lhs[0].length;
        if (!solveIfUnderDetermined && nColumns > nRows) {
            return SystemInfo.UnderDetermined;
        }
        if (nRows > nColumns) {
            for (i = nColumns; i < nRows; ++i) {
                if (rhs[i] == 0L) continue;
                return SystemInfo.Inconsistent;
            }
        }
        if (nRows > nColumns) {
            for (i = nColumns + 1; i < nRows; ++i) {
                if (rhs[i] == 0L) continue;
                return SystemInfo.Inconsistent;
            }
        }
        if (nUnderDetermined == 0 && nColumns <= nRows) {
            for (i = nColumns - 1; i >= 0; --i) {
                long sum = 0L;
                for (int j = i + 1; j < nColumns; ++j) {
                    sum = ring.add(sum, ring.multiply(lhs[i][j], result[j]));
                }
                result[i] = ring.divide(ring.subtract(rhs[i], sum), lhs[i][i]);
            }
            return SystemInfo.Consistent;
        }
        TIntArrayList nzColumns = new TIntArrayList();
        TIntArrayList nzRows = new TIntArrayList();
        int nZeroColumns = 0;
        int iRow = 0;
        int to = Math.min(nRows, nColumns);
        for (int iColumn = 0; iColumn < to; ++iColumn) {
            int i3;
            iRow = iColumn - nZeroColumns;
            if (lhs[iRow][iColumn] == 0L) {
                if (iColumn == nColumns - 1 && rhs[iRow] != 0L) {
                    return SystemInfo.Inconsistent;
                }
                to = Math.min(nRows + ++nZeroColumns, nColumns);
                continue;
            }
            long[] row = lhs[iRow];
            long val = row[iColumn];
            long valInv = ring.reciprocal(val);
            for (i3 = iColumn; i3 < nColumns; ++i3) {
                row[i3] = ring.multiply(valInv, row[i3]);
            }
            rhs[iRow] = ring.multiply(valInv, rhs[iRow]);
            for (i3 = 0; i3 < iRow; ++i3) {
                long[] pRow = lhs[i3];
                long v = pRow[iColumn];
                if (v == 0L) continue;
                for (int j = iColumn; j < nColumns; ++j) {
                    pRow[j] = ring.subtract(pRow[j], ring.multiply(v, row[j]));
                }
                rhs[i3] = ring.subtract(rhs[i3], ring.multiply(v, rhs[iRow]));
            }
            if (rhs[iRow] != 0L && lhs[iRow][iColumn] == 0L) {
                return SystemInfo.Inconsistent;
            }
            nzColumns.add(iColumn);
            nzRows.add(iRow);
        }
        if (++iRow < nRows) {
            while (iRow < nRows) {
                if (rhs[iRow] != 0L) {
                    return SystemInfo.Inconsistent;
                }
                ++iRow;
            }
        }
        for (int i4 = 0; i4 < nzColumns.size(); ++i4) {
            result[nzColumns.get((int)i4)] = rhs[nzRows.get(i4)];
        }
        return SystemInfo.Consistent;
    }

    public static SystemInfo solve(IntegersZp64 ring, ArrayList<long[]> lhs, TLongArrayList rhs, long[] result) {
        return LinearSolver.solve(ring, (long[][])lhs.toArray((T[])new long[lhs.size()][]), rhs.toArray(), result);
    }

    public static long[] solveVandermonde(IntegersZp64 ring, long[] row, long[] rhs) {
        long[] result = new long[rhs.length];
        SystemInfo info = LinearSolver.solveVandermonde(ring, row, rhs, result);
        if (info != SystemInfo.Consistent) {
            throw new ArithmeticException("singular or under-determined matrix");
        }
        return result;
    }

    public static long[] solveVandermondeT(IntegersZp64 ring, long[] row, long[] rhs) {
        long[] result = new long[rhs.length];
        SystemInfo info = LinearSolver.solveVandermondeT(ring, row, rhs, result);
        if (info != SystemInfo.Consistent) {
            throw new ArithmeticException("singular or under-determined matrix");
        }
        return result;
    }

    public static SystemInfo solveVandermonde(IntegersZp64 ring, long[] row, long[] rhs, long[] result) {
        int i;
        if (row.length != rhs.length) {
            throw new IllegalArgumentException("not a square Vandermonde matrix");
        }
        if (rhs.length == 0) {
            return SystemInfo.Consistent;
        }
        if (rhs.length == 1) {
            result[0] = rhs[0];
            return SystemInfo.Consistent;
        }
        UnivariatePolynomialZp64[] lins = new UnivariatePolynomialZp64[row.length];
        UnivariatePolynomialZp64 master = UnivariatePolynomialZp64.one(ring);
        for (i = 0; i < row.length; ++i) {
            lins[i] = (UnivariatePolynomialZp64)master.createLinear(ring.negate(row[i]), 1L);
            master = master.multiply(lins[i]);
        }
        for (i = 0; i < result.length; ++i) {
            result[i] = 0L;
        }
        for (i = 0; i < row.length; ++i) {
            UnivariatePolynomialZp64 quot = UnivariateDivision.divideAndRemainder(master, lins[i], true)[0];
            long cf = quot.evaluate(row[i]);
            if (cf == 0L) {
                return SystemInfo.UnderDetermined;
            }
            quot = quot.divide(cf);
            for (int j = 0; j < row.length; ++j) {
                result[j] = ring.add(result[j], ring.multiply(rhs[i], quot.get(j)));
            }
        }
        return SystemInfo.Consistent;
    }

    public static SystemInfo solveVandermondeT(IntegersZp64 ring, long[] row, long[] rhs, long[] result) {
        int i;
        if (row.length != rhs.length) {
            throw new IllegalArgumentException("not a square Vandermonde matrix");
        }
        if (rhs.length == 0) {
            return SystemInfo.Consistent;
        }
        if (rhs.length == 1) {
            result[0] = rhs[0];
            return SystemInfo.Consistent;
        }
        UnivariatePolynomialZp64[] lins = new UnivariatePolynomialZp64[row.length];
        UnivariatePolynomialZp64 master = UnivariatePolynomialZp64.one(ring);
        for (i = 0; i < row.length; ++i) {
            lins[i] = (UnivariatePolynomialZp64)master.createLinear(ring.negate(row[i]), 1L);
            master = master.multiply(lins[i]);
        }
        for (i = 0; i < row.length; ++i) {
            UnivariatePolynomialZp64 quot = UnivariateDivision.divideAndRemainder(master, lins[i], true)[0];
            long cf = quot.evaluate(row[i]);
            if (cf == 0L) {
                return SystemInfo.UnderDetermined;
            }
            if ((quot = quot.divide(cf)) == null) {
                throw new IllegalArgumentException();
            }
            result[i] = 0L;
            for (int j = 0; j < row.length; ++j) {
                result[i] = ring.add(result[i], ring.multiply(rhs[j], quot.get(j)));
            }
        }
        return SystemInfo.Consistent;
    }

    public static enum SystemInfo {
        UnderDetermined,
        Inconsistent,
        Consistent;

    }
}

