/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Ring;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZ64;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import java.util.Arrays;
import java.util.Iterator;

public final class FiniteField<E extends IUnivariatePolynomial<E>>
extends SimpleFieldExtension<E> {
    private static final long serialVersionUID = 1L;
    public static final FiniteField<UnivariatePolynomialZp64> GF27 = new FiniteField<UnivariatePolynomialZp64>(UnivariatePolynomialZ64.create(-1L, -1L, 0L, 1L).modulus(3L));
    public static final FiniteField<UnivariatePolynomialZp64> GF17p5 = new FiniteField<UnivariatePolynomialZp64>(UnivariatePolynomialZ64.create(11L, 11L, 0L, 3L, 9L, 9L).modulus(17L).monic());

    public FiniteField(E minimalPoly) {
        super(minimalPoly);
        if (!minimalPoly.isOverFiniteField()) {
            throw new IllegalArgumentException("Irreducible poly must be over finite field.");
        }
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public boolean isUnit(E element) {
        return !element.isZero();
    }

    @Override
    public E gcd(E a, E b) {
        return a;
    }

    @Override
    public E[] divideAndRemainder(E a, E b) {
        return (IUnivariatePolynomial[])a.createArray(this.multiply(a, this.reciprocal(b)), (IPolynomial)this.getZero());
    }

    @Override
    public E remainder(E dividend, E divider) {
        return (E)this.getZero();
    }

    @Override
    public Iterator<E> iterator() {
        if (!this.isFinite()) {
            throw new RuntimeException("Ring of infinite cardinality.");
        }
        if (this.minimalPoly instanceof UnivariatePolynomial) {
            return new It(((UnivariatePolynomial)this.minimalPoly).ring, this.minimalPoly.degree());
        }
        if (this.minimalPoly instanceof UnivariatePolynomialZp64) {
            return new lIt(((UnivariatePolynomialZp64)this.minimalPoly).ring, this.minimalPoly.degree());
        }
        throw new RuntimeException();
    }

    private static final class It<E>
    implements Iterator<UnivariatePolynomial<E>> {
        final Ring<E> ring;
        final E[] data;
        final Iterator<E>[] iterators;
        private boolean first = true;

        It(Ring<E> ring, int degree) {
            int i;
            this.ring = ring;
            this.data = ring.createArray(degree);
            this.iterators = new Iterator[degree];
            for (i = 0; i < this.iterators.length; ++i) {
                this.iterators[i] = ring.iterator();
            }
            for (i = 0; i < this.data.length; ++i) {
                this.data[i] = this.iterators[i].next();
            }
        }

        @Override
        public boolean hasNext() {
            return Arrays.stream(this.iterators).anyMatch(Iterator::hasNext);
        }

        @Override
        public UnivariatePolynomial<E> next() {
            if (this.first) {
                this.first = false;
                return UnivariatePolynomial.create(this.ring, (Object[])this.data.clone());
            }
            int i = 0;
            if (!this.iterators[i].hasNext()) {
                while (i < this.iterators.length && !this.iterators[i].hasNext()) {
                    this.iterators[i] = this.ring.iterator();
                    this.data[i] = this.iterators[i].next();
                    ++i;
                }
            }
            if (i >= this.iterators.length) {
                return null;
            }
            this.data[i] = this.iterators[i].next();
            return UnivariatePolynomial.createUnsafe(this.ring, (Object[])this.data.clone());
        }
    }

    private static final class lIt
    implements Iterator<UnivariatePolynomialZp64> {
        final IntegersZp64 ring;
        final long[] data;
        private boolean first = true;

        lIt(IntegersZp64 ring, int degree) {
            this.ring = ring;
            this.data = new long[degree];
        }

        @Override
        public boolean hasNext() {
            return Arrays.stream(this.data).anyMatch(l -> l < this.ring.modulus - 1L);
        }

        @Override
        public UnivariatePolynomialZp64 next() {
            if (this.first) {
                this.first = false;
                return UnivariatePolynomialZp64.createUnsafe(this.ring, (long[])this.data.clone());
            }
            int i = 0;
            if (this.data[i] >= this.ring.modulus - 1L) {
                while (i < this.data.length && this.data[i] >= this.ring.modulus - 1L) {
                    this.data[i] = 0L;
                    ++i;
                }
            }
            if (i >= this.data.length) {
                return null;
            }
            int n = i;
            this.data[n] = this.data[n] + 1L;
            return UnivariatePolynomialZp64.createUnsafe(this.ring, (long[])this.data.clone());
        }
    }
}

