/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.libdivide4j.FastDivision;
import cc.redberry.rings.bigint.BigInteger;

public final class MachineArithmetic {
    public static final int MAX_SUPPORTED_MODULUS_BITS = 62;
    public static final long MAX_SUPPORTED_MODULUS = 0x3FFFFFFFFFFFFFFFL;
    public static final BigInteger b_MAX_SUPPORTED_MODULUS = BigInteger.valueOf(0x3FFFFFFFFFFFFFFFL);

    private MachineArithmetic() {
    }

    public static boolean fits32bitWord(long val) {
        return Long.compareUnsigned(val, 0xFFFFFFFFL) <= 0;
    }

    public static boolean fits31bitWord(long val) {
        return Long.compareUnsigned(val, Integer.MAX_VALUE) <= 0;
    }

    public static long safeMultiply(long x, long y) {
        return Math.multiplyExact(x, y);
    }

    public static long safeMultiply(long x, long y, long z) {
        return Math.multiplyExact(Math.multiplyExact(x, y), z);
    }

    public static long safeAdd(long x, long y) {
        return Math.addExact(x, y);
    }

    public static long safeSubtract(long a, long b) {
        return Math.subtractExact(a, b);
    }

    public static long safeNegate(long x) {
        return Math.negateExact(x);
    }

    public static boolean isOverflowMultiply(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        return (ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L);
    }

    public static boolean isOverflowAdd(long x, long y) {
        long r = x + y;
        return ((x ^ r) & (y ^ r)) < 0L;
    }

    public static long safePow(long base, long exponent) {
        if (exponent < 0L) {
            throw new IllegalArgumentException();
        }
        long result = 1L;
        long k2p = base;
        while (true) {
            if ((exponent & 1L) != 0L) {
                result = MachineArithmetic.safeMultiply(result, k2p);
            }
            if ((exponent >>= 1) == 0L) {
                return result;
            }
            k2p = MachineArithmetic.safeMultiply(k2p, k2p);
        }
    }

    public static long unsafePow(long base, long exponent) {
        if (exponent < 0L) {
            throw new IllegalArgumentException();
        }
        long result = 1L;
        long k2p = base;
        while (true) {
            if ((exponent & 1L) != 0L) {
                result *= k2p;
            }
            if ((exponent >>= 1) == 0L) {
                return result;
            }
            k2p *= k2p;
        }
    }

    public static long gcd(long p, long q) {
        long t;
        int k;
        long u = p;
        long v = q;
        if (u == 0L || v == 0L) {
            if (u == Long.MIN_VALUE || v == Long.MIN_VALUE) {
                throw new IllegalArgumentException("long overflow");
            }
            return Math.abs(u) + Math.abs(v);
        }
        if (u > 0L) {
            u = -u;
        }
        if (v > 0L) {
            v = -v;
        }
        for (k = 0; (u & 1L) == 0L && (v & 1L) == 0L && k < 63; ++k) {
            u /= 2L;
            v /= 2L;
        }
        if (k == 63) {
            throw new IllegalArgumentException("Overflow");
        }
        long l = t = (u & 1L) == 1L ? v : -(u / 2L);
        while (true) {
            if ((t & 1L) == 0L) {
                t /= 2L;
                continue;
            }
            if (t > 0L) {
                u = -t;
            } else {
                v = t;
            }
            if ((t = (v - u) / 2L) == 0L) break;
        }
        return -u * (1L << k);
    }

    public static int gcd(int p, int q) {
        int a = p;
        int b = q;
        if (a == 0 || b == 0) {
            if (a == Integer.MIN_VALUE || b == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("int overflow");
            }
            return Math.abs(a + b);
        }
        long al = a;
        long bl = b;
        boolean useLong = false;
        if (a < 0) {
            if (Integer.MIN_VALUE == a) {
                useLong = true;
            } else {
                a = -a;
            }
            al = -al;
        }
        if (b < 0) {
            if (Integer.MIN_VALUE == b) {
                useLong = true;
            } else {
                b = -b;
            }
            bl = -bl;
        }
        if (useLong) {
            if (al == bl) {
                throw new IllegalArgumentException("int overflow");
            }
            long blbu = bl;
            bl = al;
            if ((al = blbu % al) == 0L) {
                if (bl > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("int overflow");
                }
                return (int)bl;
            }
            blbu = bl;
            b = (int)al;
            a = (int)(blbu % al);
        }
        return MachineArithmetic.gcdPositive(a, b);
    }

    private static int gcdPositive(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        int shift = Math.min(aTwos, bTwos);
        while (a != b) {
            int delta = a - b;
            b = Math.min(a, b);
            a = Math.abs(delta);
            a >>= Integer.numberOfTrailingZeros(a);
        }
        return a << shift;
    }

    public static long[] gcdExtended(long a, long b) {
        long s = 0L;
        long old_s = 1L;
        long t = 1L;
        long old_t = 0L;
        long r = b;
        long old_r = a;
        while (r != 0L) {
            long q = old_r / r;
            long tmp = old_r;
            old_r = r;
            r = tmp - q * r;
            tmp = old_s;
            old_s = s;
            s = tmp - q * s;
            tmp = old_t;
            old_t = t;
            t = tmp - q * t;
        }
        assert (old_r == a * old_s + b * old_t);
        return new long[]{old_r, old_s, old_t};
    }

    public static long lcm(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        return MachineArithmetic.safeMultiply(a / MachineArithmetic.gcd(a, b), b);
    }

    public static int lcm(int a, int b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        return a / MachineArithmetic.gcd(a, b) * b;
    }

    public static long gcd(long[] integers, int from, int to) {
        if (integers.length < 2) {
            throw new IllegalArgumentException();
        }
        long gcd = MachineArithmetic.gcd(integers[from], integers[from + 1]);
        if (gcd == 1L) {
            return gcd;
        }
        for (int i = from + 2; i < to; ++i) {
            if ((gcd = MachineArithmetic.gcd(integers[i], gcd)) != 1L) continue;
            return gcd;
        }
        return gcd;
    }

    public static long gcd(long ... integers) {
        return MachineArithmetic.gcd(integers, 0, integers.length);
    }

    public static long gcd(int[] integers, int from, int to) {
        if (integers.length < 2) {
            throw new IllegalArgumentException();
        }
        long gcd = MachineArithmetic.gcd(integers[from], integers[from + 1]);
        if (gcd == 1L) {
            return gcd;
        }
        for (int i = from + 2; i < to; ++i) {
            if ((gcd = MachineArithmetic.gcd((long)integers[i], gcd)) != 1L) continue;
            return gcd;
        }
        return gcd;
    }

    public static long gcd(int ... integers) {
        return MachineArithmetic.gcd(integers, 0, integers.length);
    }

    public static long mod(long num, long modulus) {
        if (num < 0L) {
            num += modulus;
        }
        return num >= modulus || num < 0L ? Math.floorMod(num, modulus) : num;
    }

    public static long symMod(long value, long modulus) {
        return (value = MachineArithmetic.mod(value, modulus)) <= modulus / 2L ? value : value - modulus;
    }

    public static long modInverse(long num, long modulus) {
        if (num == 1L) {
            return num;
        }
        if (num < 0L) {
            num = MachineArithmetic.mod(num, modulus);
        }
        long s = 0L;
        long old_s = 1L;
        long r = modulus;
        long old_r = num;
        while (r != 0L) {
            long q = old_r / r;
            long tmp = old_r;
            old_r = r;
            r = tmp - q * r;
            tmp = old_s;
            old_s = s;
            s = tmp - q * s;
        }
        if (old_r != 1L) {
            throw new IllegalArgumentException(String.format("modInverse(%s, %s) : not invertible (old_r = %s)", num, modulus, old_r));
        }
        return MachineArithmetic.mod(old_s, modulus);
    }

    public static int safeToInt(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow: " + value);
        }
        return (int)value;
    }

    public static long powMod(long base, long exponent, long modulus) {
        return MachineArithmetic.powModSigned(base, exponent, FastDivision.magicSigned(modulus));
    }

    public static long powModSigned(long base, long exponent, FastDivision.Magic magic) {
        if (exponent < 0L) {
            throw new IllegalArgumentException();
        }
        if (exponent == 0L) {
            return 1L;
        }
        long result = 1L;
        long k2p = FastDivision.modSignedFast(base, magic);
        while (true) {
            if ((exponent & 1L) != 0L) {
                result = FastDivision.modSignedFast(result * k2p, magic);
            }
            if ((exponent >>= 1) == 0L) {
                return result;
            }
            k2p = FastDivision.modSignedFast(k2p * k2p, magic);
        }
    }

    public static long powModUnsigned(long base, long exponent, FastDivision.Magic magic) {
        if (exponent < 0L) {
            throw new IllegalArgumentException();
        }
        if (exponent == 0L) {
            return 1L;
        }
        long result = 1L;
        long k2p = FastDivision.modUnsignedFast(base, magic);
        while (true) {
            if ((exponent & 1L) != 0L) {
                result = FastDivision.modUnsignedFast(result * k2p, magic);
            }
            if ((exponent >>= 1) == 0L) {
                return result;
            }
            k2p = FastDivision.modUnsignedFast(k2p * k2p, magic);
        }
    }

    public static long[] perfectPowerDecomposition(long n) {
        if (n < 0L) {
            long[] ipp = MachineArithmetic.perfectPowerDecomposition(-n);
            if (ipp == null) {
                return null;
            }
            if (ipp[1] % 2L == 0L) {
                return null;
            }
            ipp[0] = -ipp[0];
            return ipp;
        }
        if ((-n & n) == n) {
            return new long[]{2L, 63 - Long.numberOfLeadingZeros(n)};
        }
        int lgn = 1 + (64 - Long.numberOfLeadingZeros(n));
        for (int b = 2; b < lgn; ++b) {
            long lowa = 1L;
            long higha = 1L << lgn / b + 1;
            while (lowa < higha - 1L) {
                long mida = lowa + higha >> 1;
                long ab = MachineArithmetic.unsafePow(mida, b);
                if (ab > n) {
                    higha = mida;
                    continue;
                }
                if (ab < n) {
                    lowa = mida;
                    continue;
                }
                long[] ipp = MachineArithmetic.perfectPowerDecomposition(mida);
                if (ipp != null) {
                    return new long[]{ipp[0], ipp[1] * (long)b};
                }
                return new long[]{mida, b};
            }
        }
        return null;
    }
}

