/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.ImageRing;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.Coder;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.multivar.MultivariateResultants;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateFactorization;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.UnivariateSquareFreeFactorization;
import cc.redberry.rings.util.ArraysUtil;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MultipleFieldExtension<Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>>
extends ImageRing<sPoly, mPoly>
implements IPolynomialRing<mPoly> {
    final mPoly mFactory;
    final sPoly sFactory;
    final MultipleFieldExtension<Term, mPoly, sPoly>[] tower;
    final UnivariatePolynomial<mPoly>[] minimalPolynomialsOfGenerators;
    final mPoly primitiveElement;
    final SimpleFieldExtension<sPoly> simpleExtension;
    final sPoly[] generatorsReps;

    public MultipleFieldExtension(MultipleFieldExtension<Term, mPoly, sPoly>[] tower, UnivariatePolynomial<mPoly>[] minimalPolynomialsOfGenerators, mPoly primitiveElement, sPoly[] generatorsReps, SimpleFieldExtension<sPoly> simpleExtension) {
        super(simpleExtension, new MultipleToSimple(primitiveElement, simpleExtension, generatorsReps), new SimpleToMultiple(primitiveElement, simpleExtension, generatorsReps, (MultipleFieldExtension[])tower, (UnivariatePolynomial[])minimalPolynomialsOfGenerators));
        this.tower = tower;
        this.minimalPolynomialsOfGenerators = minimalPolynomialsOfGenerators;
        this.primitiveElement = primitiveElement;
        this.simpleExtension = simpleExtension;
        this.generatorsReps = generatorsReps;
        this.mFactory = (AMultivariatePolynomial)primitiveElement.createOne();
        this.sFactory = (IUnivariatePolynomial)simpleExtension.factory().createOne();
    }

    @Override
    public int nVariables() {
        return ((AMultivariatePolynomial)this.mFactory).nVariables;
    }

    @Override
    public mPoly factory() {
        return this.mFactory;
    }

    @Override
    public mPoly variable(int variable) {
        return (mPoly)((AMultivariatePolynomial)this.mFactory).createMonomial(variable, 1);
    }

    public sPoly getUnivariateFactory() {
        return this.sFactory;
    }

    public mPoly getPrimitiveElement() {
        return (mPoly)((AMultivariatePolynomial)this.primitiveElement).clone();
    }

    public int degree() {
        return this.simpleExtension.degree();
    }

    public SimpleFieldExtension<sPoly> getSimpleExtension() {
        return this.simpleExtension;
    }

    public UnivariatePolynomial<mPoly> getGeneratorMinimalPoly(int iGenerator) {
        return this.minimalPolynomialsOfGenerators[iGenerator].clone();
    }

    public MultipleFieldExtension<Term, mPoly, sPoly> getSubExtension(int i) {
        return this.tower[i];
    }

    public sPoly getGeneratorRep(int iGenerator) {
        return (sPoly)this.generatorsReps[iGenerator].clone();
    }

    public sPoly[] getGeneratorReps() {
        return (IUnivariatePolynomial[])this.generatorsReps.clone();
    }

    public MultipleFieldExtension<Term, mPoly, sPoly> joinAlgebraicElement(UnivariatePolynomial<mPoly> algebraicElement) {
        UnivariatePolynomial<IUnivariatePolynomial> minimalPoly = algebraicElement.mapCoefficients(this.simpleExtension, this::inverse);
        MultipleFieldExtension<Term, mPoly, IUnivariatePolynomial> ext = MultipleFieldExtension.mkMultipleExtension0(this.simpleExtension.minimalPoly, minimalPoly);
        MultipleFieldExtension[] tower = ArraysUtil.addAll(this.tower, this);
        UnivariatePolynomial[] minPolys = ArraysUtil.addAll(this.minimalPolynomialsOfGenerators, algebraicElement);
        Object primitiveElement = ((AMultivariatePolynomial)((AMultivariatePolynomial)ext.primitiveElement).insertVariable(1, this.nVariables() - 1)).composition(0, ((AMultivariatePolynomial)this.primitiveElement).joinNewVariable());
        SimpleFieldExtension simpleExtension = ext.simpleExtension;
        IUnivariatePolynomial[] generatorsReps = (IUnivariatePolynomial[])Stream.concat(Arrays.stream(this.generatorsReps).map(rep -> rep.composition(simpleExtension, ext.generatorsReps[0])), Stream.of(ext.generatorsReps[1])).toArray((IntFunction<IUnivariatePolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/univar/IUnivariatePolynomial;)(this.sFactory));
        return new MultipleFieldExtension(tower, minPolys, primitiveElement, generatorsReps, simpleExtension);
    }

    public MultipleFieldExtension<Term, mPoly, sPoly> joinAlgebraicElement(sPoly minimalPoly) {
        return this.joinAlgebraicElement((sPoly)minimalPoly.mapCoefficientsAsPolys(this, this::image));
    }

    public MultipleFieldExtension<Term, mPoly, sPoly> joinRedundantElement(mPoly element) {
        UnivariatePolynomial<AMultivariatePolynomial> minimalPoly = UnivariatePolynomial.create(this, (AMultivariatePolynomial)this.negate(element), this.getOne());
        MultipleFieldExtension[] tower = ArraysUtil.addAll(this.tower, this);
        UnivariatePolynomial[] minPolys = ArraysUtil.addAll(this.minimalPolynomialsOfGenerators, minimalPoly);
        Object primitiveElement = ((AMultivariatePolynomial)this.primitiveElement).joinNewVariable();
        SimpleFieldExtension<sPoly> simpleExtension = this.simpleExtension;
        IUnivariatePolynomial[] generatorsReps = ArraysUtil.addAll(this.generatorsReps, (IUnivariatePolynomial)this.inverse(element));
        return new MultipleFieldExtension(tower, minPolys, primitiveElement, generatorsReps, simpleExtension);
    }

    @Override
    public mPoly valueOf(long val) {
        return (mPoly)((AMultivariatePolynomial)this.mFactory.createConstant(val));
    }

    @Override
    public mPoly valueOfBigInteger(BigInteger val) {
        return (mPoly)((AMultivariatePolynomial)((AMultivariatePolynomial)this.mFactory.createOne()).multiplyByBigInteger(val));
    }

    @Override
    public mPoly getZero() {
        return (mPoly)((AMultivariatePolynomial)this.mFactory.createZero());
    }

    @Override
    public mPoly getOne() {
        return (mPoly)((AMultivariatePolynomial)this.mFactory.createOne());
    }

    @Override
    public mPoly copy(mPoly element) {
        return (mPoly)((AMultivariatePolynomial)element).clone();
    }

    @Override
    public boolean isZero(mPoly element) {
        return ((AMultivariatePolynomial)element).isZero();
    }

    @Override
    public boolean isOne(mPoly element) {
        return element.isOne();
    }

    @Override
    public boolean isUnit(mPoly element) {
        return this.isField() ? !this.isZero(element) : this.isOne(element) || this.isMinusOne(element);
    }

    @Override
    public mPoly gcd(mPoly a, mPoly b) {
        return (mPoly)(this.isField() ? ((AMultivariatePolynomial)a).clone() : this.getOne());
    }

    @Override
    public mPoly[] extendedGCD(mPoly a, mPoly b) {
        return (AMultivariatePolynomial[])super.extendedGCD(a, b);
    }

    @Override
    public mPoly lcm(mPoly a, mPoly b) {
        return (mPoly)((AMultivariatePolynomial)super.lcm(a, b));
    }

    @Override
    public mPoly gcd(mPoly ... elements) {
        return (mPoly)((AMultivariatePolynomial)super.gcd((I[])elements));
    }

    @Override
    public mPoly gcd(Iterable<mPoly> elements) {
        return (mPoly)((AMultivariatePolynomial)super.gcd(elements));
    }

    @Override
    public int signum(mPoly element) {
        return element.signumOfLC();
    }

    @Override
    public mPoly factorial(long num) {
        return (mPoly)((AMultivariatePolynomial)super.factorial(num));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultipleFieldExtension that = (MultipleFieldExtension)o;
        return Arrays.equals(this.minimalPolynomialsOfGenerators, that.minimalPolynomialsOfGenerators);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.minimalPolynomialsOfGenerators);
        return result;
    }

    @Override
    public String toString(IStringifier stringifier) {
        String cfrStr = this.sFactory.coefficientRingToString(stringifier);
        String varStr = IntStream.range(0, this.nVariables()).mapToObj(i -> stringifier.getBinding(this.variable(i))).collect(Collectors.joining(", "));
        String irrStr = IntStream.range(0, this.nVariables()).mapToObj(i -> {
            String pString;
            UnivariatePolynomial<mPoly> p = this.minimalPolynomialsOfGenerators[i];
            if (stringifier instanceof Coder) {
                Map bindings = stringifier.getBindings();
                Object v = p.createMonomial(1);
                String old = bindings.put(v, stringifier.getBinding(this.variable(i)));
                pString = p.toString(stringifier);
                if (old == null) {
                    bindings.remove(v);
                } else {
                    bindings.put(v, old);
                }
            } else {
                pString = p.toString(stringifier);
            }
            return pString + " = 0";
        }).collect(Collectors.joining(", "));
        return "(" + cfrStr + ")[" + varStr + "]/<" + irrStr + ">";
    }

    public String toString(String ... variables) {
        return this.toString(IStringifier.mkPolyStringifier(this.mFactory, variables));
    }

    public String toString() {
        return this.toString(IStringifier.defaultVars(this.nVariables()));
    }

    public static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> MultipleFieldExtension<Term, mPoly, sPoly> mkMultipleExtension(sPoly a) {
        return MultipleFieldExtension.mkMultipleExtension(Rings.SimpleFieldExtension(a));
    }

    public static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> MultipleFieldExtension<Term, mPoly, sPoly> mkMultipleExtension(SimpleFieldExtension<sPoly> ext) {
        sPoly m = ext.getMinimalPolynomial();
        return new MultipleFieldExtension(new MultipleFieldExtension[0], new UnivariatePolynomial[]{m.mapCoefficientsAsPolys(Rings.MultivariateRing(m.asMultivariate()), cf -> cf.asMultivariate())}, m.asMultivariate().createMonomial(0, 1), (IUnivariatePolynomial[])m.createArray(m.createMonomial(1)), ext);
    }

    private static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> MultipleFieldExtension<Term, mPoly, sPoly> mkMultipleExtension0(sPoly a, UnivariatePolynomial<sPoly> b) {
        if (a instanceof UnivariatePolynomial) {
            return MultipleFieldExtension.mkMultipleExtensionE((UnivariatePolynomial)a, b);
        }
        return MultipleFieldExtension.mkMultipleExtensionZp64((UnivariatePolynomialZp64)a, b);
    }

    private static <E> MultipleFieldExtension<Monomial<E>, MultivariatePolynomial<E>, UnivariatePolynomial<E>> mkMultipleExtensionE(UnivariatePolynomial<E> a, UnivariatePolynomial<UnivariatePolynomial<E>> b) {
        MultivariatePolynomial ma = (MultivariatePolynomial)a.asMultivariate().insertVariable(0);
        IPolynomial factory = ma.createOne();
        int s = 0;
        while (true) {
            IUnivariatePolynomial primitiveElement;
            MultivariatePolynomial mb = (MultivariatePolynomial)MultipleFieldExtension.asBivariate(b);
            if (s != 0) {
                mb = mb.composition(0, (MultivariatePolynomial)((MultivariatePolynomial)((AMultivariatePolynomial)factory).createMonomial(0, 1)).subtract(((MultivariatePolynomial)((AMultivariatePolynomial)factory).createMonomial(1, 1)).multiply(s)));
            }
            if (UnivariateSquareFreeFactorization.isSquareFree(primitiveElement = MultivariateResultants.Resultant(ma, mb, 1).asUnivariate())) {
                SimpleFieldExtension<IUnivariatePolynomial> extension = Rings.SimpleFieldExtension(primitiveElement);
                UnivariatePolynomial<UnivariatePolynomial> aE = a.mapCoefficientsAsPolys(extension, extension::valueOf);
                UnivariatePolynomial bE = (UnivariatePolynomial)mb.mapCoefficients(extension, ((UnivariatePolynomial)extension.factory)::createConstant).composition(new UnivariatePolynomial[]{aE.createConstant((UnivariatePolynomial)extension.generator()), aE.createMonomial(1)});
                IPolynomial gcd = UnivariateGCD.PolynomialGCD(aE, bE).monic();
                assert (((UnivariatePolynomial)gcd).degree() == 1) : ((UnivariatePolynomial)gcd).degree();
                UnivariatePolynomial aRep = (UnivariatePolynomial)extension.negate((UnivariatePolynomial)((UnivariatePolynomial)gcd).cc());
                UnivariatePolynomial bRep = (UnivariatePolynomial)extension.subtract((UnivariatePolynomial)extension.generator(), (IUnivariatePolynomial)((UnivariatePolynomial)aRep.clone()).multiply(s));
                MultipleFieldExtension result = new MultipleFieldExtension(null, null, (AMultivariatePolynomial)((MultivariatePolynomial)((MultivariatePolynomial)((AMultivariatePolynomial)factory).createMonomial(1, 1)).add(((MultivariatePolynomial)((AMultivariatePolynomial)factory).createMonomial(0, 1)).multiply(s))), (IUnivariatePolynomial[])a.createArray(aRep, bRep), extension);
                return result;
            }
            ++s;
        }
    }

    private static MultipleFieldExtension<MonomialZp64, MultivariatePolynomialZp64, UnivariatePolynomialZp64> mkMultipleExtensionZp64(UnivariatePolynomialZp64 a, UnivariatePolynomial<UnivariatePolynomialZp64> b) {
        MultivariatePolynomialZp64 ma = (MultivariatePolynomialZp64)a.asMultivariate().insertVariable(0);
        MultivariatePolynomialZp64 factory = ma.createOne();
        int s = 0;
        while (true) {
            UnivariatePolynomialZp64 primitiveElement;
            MultivariatePolynomialZp64 mb = (MultivariatePolynomialZp64)MultipleFieldExtension.asBivariate(b);
            if (s != 0) {
                mb = mb.composition(0, (MultivariatePolynomialZp64)((MultivariatePolynomialZp64)factory.createMonomial(0, 1)).subtract(((MultivariatePolynomialZp64)factory.createMonomial(1, 1)).multiply(s)));
            }
            if (UnivariateSquareFreeFactorization.isSquareFree(primitiveElement = MultivariateResultants.Resultant(ma, mb, 1).asUnivariate())) {
                SimpleFieldExtension<UnivariatePolynomialZp64> extension = Rings.SimpleFieldExtension(primitiveElement);
                UnivariatePolynomial<UnivariatePolynomialZp64> aE = a.mapCoefficientsAsPolys(extension, extension::valueOf);
                UnivariatePolynomial bE = (UnivariatePolynomial)mb.mapCoefficients(extension, arg_0 -> MultipleFieldExtension.lambda$mkMultipleExtensionZp64$4((UnivariatePolynomialZp64)extension.factory, arg_0)).composition(new UnivariatePolynomial[]{aE.createConstant(extension.generator()), aE.createMonomial(1)});
                IPolynomial gcd = UnivariateGCD.PolynomialGCD(aE, bE).monic();
                assert (((UnivariatePolynomial)gcd).degree() == 1);
                UnivariatePolynomialZp64 aRep = extension.negate((UnivariatePolynomialZp64)((UnivariatePolynomial)gcd).cc());
                UnivariatePolynomialZp64 bRep = extension.subtract(extension.generator(), (UnivariatePolynomialZp64)aRep.clone().multiply(s));
                MultipleFieldExtension result = new MultipleFieldExtension(null, null, (AMultivariatePolynomial)((MultivariatePolynomialZp64)((MultivariatePolynomialZp64)factory.createMonomial(0, 1)).add(((MultivariatePolynomialZp64)factory.createMonomial(1, 1)).multiply(s))), (IUnivariatePolynomial[])a.createArray(aRep, bRep), extension);
                return result;
            }
            ++s;
        }
    }

    private static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> mPoly asBivariate(UnivariatePolynomial<sPoly> b) {
        if (b.lc() instanceof UnivariatePolynomialZp64) {
            return MultipleFieldExtension.asBivariateZp64(b);
        }
        return MultipleFieldExtension.asBivariateE(b);
    }

    private static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>> mPoly asBivariateZp64(UnivariatePolynomial<UnivariatePolynomialZp64> b) {
        return (mPoly)MultivariatePolynomialZp64.asNormalMultivariate((MultivariatePolynomial<UnivariatePolynomialZp64>)b.asMultivariate(), 1);
    }

    private static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, E> mPoly asBivariateE(UnivariatePolynomial<UnivariatePolynomial<E>> b) {
        return (mPoly)MultivariatePolynomial.asNormalMultivariate(b.asMultivariate(), 1);
    }

    public static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> MultipleFieldExtension<Term, mPoly, sPoly> mkMultipleExtension(sPoly ... minimalPolynomials) {
        MultipleFieldExtension<Term, mPoly, sPoly> ext = MultipleFieldExtension.mkMultipleExtension(minimalPolynomials[0]);
        for (int i = 1; i < minimalPolynomials.length; ++i) {
            ext = ext.joinAlgebraicElement(minimalPolynomials[i]);
        }
        return ext;
    }

    public static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> MultipleFieldExtension<Term, mPoly, sPoly> mkSplittingField(sPoly poly) {
        MultipleFieldExtension<Term, Object, Object> extension = MultipleFieldExtension.mkMultipleExtension(poly);
        ArrayList<UnivariatePolynomial> nonLinearFactors = new ArrayList<UnivariatePolynomial>();
        nonLinearFactors.add(poly.mapCoefficientsAsPolys(extension, extension::image));
        boolean first = true;
        while (!nonLinearFactors.isEmpty()) {
            MultipleFieldExtension<Term, Object, Object> nextExt;
            UnivariatePolynomial<AMultivariatePolynomial> factor = (UnivariatePolynomial<AMultivariatePolynomial>)nonLinearFactors.remove(nonLinearFactors.size() - 1);
            if (first) {
                nextExt = extension;
                first = false;
            } else {
                nextExt = extension.joinAlgebraicElement(factor);
                MultipleFieldExtension _nextExt = nextExt;
                nonLinearFactors.replaceAll(f -> f.mapCoefficients(_nextExt, AMultivariatePolynomial::joinNewVariable));
                factor = factor.mapCoefficients(nextExt, AMultivariatePolynomial::joinNewVariable);
            }
            factor = UnivariateDivision.divideExact(factor, UnivariatePolynomial.create(nextExt, (AMultivariatePolynomial)nextExt.negate(nextExt.variable(nextExt.nVariables() - 1)), nextExt.getOne()), false);
            List factors = UnivariateFactorization.Factor(factor).factors;
            for (int i = 0; i < factors.size(); ++i) {
                UnivariatePolynomial f2 = (UnivariatePolynomial)factors.get(i);
                if (f2.degree() > 1) {
                    nonLinearFactors.add(f2);
                    continue;
                }
                nextExt = nextExt.joinRedundantElement(nextExt.negate(nextExt.divideExact((AMultivariatePolynomial)f2.cc(), (AMultivariatePolynomial)f2.lc())));
                for (int j = i + 1; j < factors.size(); ++j) {
                    factors.set(j, ((UnivariatePolynomial)factors.get(j)).mapCoefficients(nextExt, AMultivariatePolynomial::joinNewVariable));
                }
            }
            extension = nextExt;
        }
        return extension;
    }

    private static /* synthetic */ UnivariatePolynomialZp64 lambda$mkMultipleExtensionZp64$4(UnivariatePolynomialZp64 rec$, long x$0) {
        return (UnivariatePolynomialZp64)rec$.createConstant(x$0);
    }

    static final class MultipleToSimple<Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>>
    extends MappingFunc<Term, mPoly, sPoly>
    implements Function<mPoly, sPoly> {
        MultipleToSimple(mPoly primitiveElement, SimpleFieldExtension<sPoly> simpleExtension, sPoly[] generatorsReps) {
            super(primitiveElement, simpleExtension, generatorsReps);
        }

        @Override
        public sPoly apply(mPoly mPoly) {
            return (sPoly)mPoly.composition((Ring)this.simpleExtension, this.generatorsReps);
        }
    }

    static final class SimpleToMultiple<Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>>
    extends MappingFunc<Term, mPoly, sPoly>
    implements Function<sPoly, mPoly> {
        final MultipleFieldExtension<Term, mPoly, sPoly>[] tower;
        final UnivariatePolynomial<mPoly>[] minimalPolynomials;

        public SimpleToMultiple(mPoly primitiveElement, SimpleFieldExtension<sPoly> simpleExtension, sPoly[] generatorsReps, MultipleFieldExtension<Term, mPoly, sPoly>[] tower, UnivariatePolynomial<mPoly>[] minimalPolynomials) {
            super(primitiveElement, simpleExtension, generatorsReps);
            this.tower = tower;
            this.minimalPolynomials = minimalPolynomials;
        }

        @Override
        public mPoly apply(sPoly sPoly) {
            AMultivariatePolynomial r = sPoly.composition(this.primitiveElement);
            if (r.nVariables > 1) {
                MultipleFieldExtension<Term, mPoly, sPoly> prevExt = this.tower[this.tower.length - 1];
                int variable = r.nVariables - 1;
                r = AMultivariatePolynomial.asMultivariate(UnivariateDivision.remainder(r.asUnivariateEliminate(variable).setRingUnsafe(prevExt), this.minimalPolynomials[variable], false), variable, true);
            }
            return (mPoly)r;
        }
    }

    static class MappingFunc<Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>>
    implements Serializable {
        final mPoly primitiveElement;
        final SimpleFieldExtension<sPoly> simpleExtension;
        final sPoly[] generatorsReps;

        MappingFunc(mPoly primitiveElement, SimpleFieldExtension<sPoly> simpleExtension, sPoly[] generatorsReps) {
            this.primitiveElement = primitiveElement;
            this.simpleExtension = simpleExtension;
            this.generatorsReps = generatorsReps;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappingFunc that = (MappingFunc)o;
            return Objects.equals(this.primitiveElement, that.primitiveElement) && Arrays.equals(this.generatorsReps, that.generatorsReps);
        }

        public int hashCode() {
            int result = Objects.hash(this.primitiveElement);
            result = 31 * result + Arrays.hashCode(this.generatorsReps);
            return result;
        }
    }
}

