/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.util.ArraysUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class DegreeVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int[] exponents;
    public final int totalDegree;

    public DegreeVector(int[] exponents, int totalDegree) {
        this.exponents = exponents;
        this.totalDegree = totalDegree;
    }

    public DegreeVector(int[] exponents) {
        this(exponents, ArraysUtil.sum(exponents));
    }

    public final int nVariables() {
        return this.exponents.length;
    }

    public final boolean isZeroVector() {
        return this.totalDegree == 0;
    }

    public DegreeVector dv() {
        return this;
    }

    public final int dvTotalDegree(int ... variables) {
        int d = 0;
        for (int v : variables) {
            d += this.exponents[v];
        }
        return d;
    }

    public final DegreeVector dvMultiply(DegreeVector oth) {
        if (oth.isZeroVector()) {
            return this;
        }
        int[] res = new int[this.exponents.length];
        for (int i = 0; i < this.exponents.length; ++i) {
            res[i] = this.exponents[i] + oth.exponents[i];
        }
        return new DegreeVector(res, this.totalDegree + oth.totalDegree);
    }

    public final DegreeVector dvMultiply(int[] oth) {
        int deg = this.totalDegree;
        int[] res = new int[this.exponents.length];
        for (int i = 0; i < this.exponents.length; ++i) {
            res[i] = this.exponents[i] + oth[i];
            deg += oth[i];
        }
        if (deg == 0) {
            return this;
        }
        return new DegreeVector(res, deg);
    }

    public final DegreeVector dvMultiply(int variable, int exponent) {
        int[] res = (int[])this.exponents.clone();
        int n = variable;
        res[n] = res[n] + exponent;
        if (res[variable] < 0) {
            return null;
        }
        return new DegreeVector(res, this.totalDegree + exponent);
    }

    public final DegreeVector dvDivideOrNull(int variable, int exponent) {
        return this.dvMultiply(variable, -exponent);
    }

    public final DegreeVector dvDivideOrNull(DegreeVector divider) {
        if (divider.isZeroVector()) {
            return this;
        }
        int[] res = new int[this.exponents.length];
        for (int i = 0; i < this.exponents.length; ++i) {
            res[i] = this.exponents[i] - divider.exponents[i];
            if (res[i] >= 0) continue;
            return null;
        }
        return new DegreeVector(res, this.totalDegree - divider.totalDegree);
    }

    public final DegreeVector dvDivideOrNull(int[] divider) {
        int deg = this.totalDegree;
        int[] res = new int[this.exponents.length];
        for (int i = 0; i < this.exponents.length; ++i) {
            res[i] = this.exponents[i] - divider[i];
            if (res[i] < 0) {
                return null;
            }
            deg -= divider[i];
        }
        if (deg == 0) {
            return this;
        }
        return new DegreeVector(res, deg);
    }

    public final DegreeVector dvDivideExact(DegreeVector divider) {
        DegreeVector quot = this.dvDivideOrNull(divider);
        if (quot == null) {
            throw new ArithmeticException("not divisible");
        }
        return quot;
    }

    public final DegreeVector dvDivideExact(int[] divider) {
        DegreeVector quot = this.dvDivideOrNull(divider);
        if (quot == null) {
            throw new ArithmeticException("not divisible");
        }
        return quot;
    }

    public final boolean dvDivisibleBy(int[] oth) {
        for (int i = 0; i < this.exponents.length; ++i) {
            if (this.exponents[i] >= oth[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean dvDivisibleBy(DegreeVector oth) {
        return this.dvDivisibleBy(oth.exponents);
    }

    public final DegreeVector dvJoinNewVariable() {
        return this.dvJoinNewVariables(1);
    }

    public final DegreeVector dvJoinNewVariables(int n) {
        return new DegreeVector(Arrays.copyOf(this.exponents, this.exponents.length + n), this.totalDegree);
    }

    public final DegreeVector dvJoinNewVariables(int newNVariables, int[] mapping) {
        int[] res = new int[newNVariables];
        int c = 0;
        for (int i : mapping) {
            res[i] = this.exponents[c++];
        }
        return new DegreeVector(res, this.totalDegree);
    }

    public final DegreeVector dvSetNVariables(int n) {
        if (n == this.exponents.length) {
            return this;
        }
        if (n > this.exponents.length) {
            return new DegreeVector(Arrays.copyOf(this.exponents, n), this.totalDegree);
        }
        return new DegreeVector(Arrays.copyOf(this.exponents, n));
    }

    public final DegreeVector dvSelect(int var) {
        int[] res = new int[this.exponents.length];
        res[var] = this.exponents[var];
        return new DegreeVector(res, this.exponents[var]);
    }

    public final DegreeVector dvSelect(int[] variables) {
        int[] res = new int[this.exponents.length];
        int deg = 0;
        for (int i : variables) {
            res[i] = this.exponents[i];
            deg += this.exponents[i];
        }
        return new DegreeVector(res, deg);
    }

    public final DegreeVector dvDropSelect(int[] variables) {
        int[] res = new int[variables.length];
        int deg = 0;
        int c = 0;
        for (int i : variables) {
            res[c++] = this.exponents[i];
            deg += this.exponents[i];
        }
        return new DegreeVector(res, deg);
    }

    public final DegreeVector dvRange(int from, int to) {
        if (from == 0 && to == this.exponents.length) {
            return this;
        }
        return new DegreeVector(Arrays.copyOfRange(this.exponents, from, to));
    }

    public final DegreeVector dvSetZero(int var) {
        int[] res = (int[])this.exponents.clone();
        res[var] = 0;
        return new DegreeVector(res, this.totalDegree - this.exponents[var]);
    }

    public final DegreeVector dvSetZero(int[] variables) {
        int[] res = (int[])this.exponents.clone();
        int deg = this.totalDegree;
        for (int i : variables) {
            deg -= this.exponents[i];
            res[i] = 0;
        }
        return new DegreeVector(res, deg);
    }

    public final DegreeVector dvWithout(int variable) {
        return new DegreeVector(ArraysUtil.remove(this.exponents, variable), this.totalDegree - this.exponents[variable]);
    }

    public final DegreeVector dvWithout(int[] variables) {
        return new DegreeVector(ArraysUtil.remove(this.exponents, variables));
    }

    public final DegreeVector dvInsert(int variable) {
        return new DegreeVector(ArraysUtil.insert(this.exponents, variable, 0), this.totalDegree);
    }

    public final DegreeVector dvInsert(int variable, int count) {
        return new DegreeVector(ArraysUtil.insert(this.exponents, variable, 0, count), this.totalDegree);
    }

    public final DegreeVector dvSet(int variable, int exponent) {
        if (this.exponents[variable] == exponent) {
            return this;
        }
        int deg = this.totalDegree - this.exponents[variable] + exponent;
        int[] res = (int[])this.exponents.clone();
        res[variable] = exponent;
        return new DegreeVector(res, deg);
    }

    public final DegreeVector dvMap(int nVariables, int[] mapping) {
        int[] newExponents = new int[nVariables];
        for (int i = 0; i < this.exponents.length; ++i) {
            newExponents[mapping[i]] = this.exponents[i];
        }
        return new DegreeVector(newExponents, this.totalDegree);
    }

    final int firstNonZeroVariable() {
        for (int i = 0; i < this.exponents.length; ++i) {
            if (this.exponents[i] == 0) continue;
            return i;
        }
        return -1;
    }

    private static String toString0(String var, int exp) {
        return exp == 0 ? "" : var + (exp == 1 ? "" : "^" + exp);
    }

    public final String toString(String[] vars) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.exponents.length; ++i) {
            result.add(DegreeVector.toString0(vars[i], this.exponents[i]));
        }
        return result.stream().filter(s -> !s.isEmpty()).collect(Collectors.joining("*"));
    }

    public String toString() {
        return this.toString(IStringifier.defaultVars(this.exponents.length));
    }

    public final String toStringArray() {
        return Arrays.toString(this.exponents);
    }

    public final boolean dvEquals(DegreeVector dVector) {
        return this.totalDegree == dVector.totalDegree && Arrays.equals(this.exponents, dVector.exponents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DegreeVector dVector = (DegreeVector)o;
        return this.dvEquals(dVector);
    }

    public int hashCode() {
        return Arrays.hashCode(this.exponents);
    }
}

