/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.libdivide4j.FastDivision;
import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.PolynomialMethods;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.IMonomialAlgebra;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MonomialSet;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZ64;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.util.ArraysUtil;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.apache.commons.math3.random.RandomGenerator;

public final class MultivariatePolynomialZp64
extends AMultivariatePolynomial<MonomialZp64, MultivariatePolynomialZp64> {
    private static final long serialVersionUID = 1L;
    public final IntegersZp64 ring;
    static final int DEFAULT_POWERS_CACHE_SIZE = 64;
    static final int MAX_POWERS_CACHE_SIZE = 1014;

    private MultivariatePolynomialZp64(int nVariables, IntegersZp64 ring, Comparator<DegreeVector> ordering, MonomialSet<MonomialZp64> lMonomialTerms) {
        super(nVariables, ordering, new IMonomialAlgebra.MonomialAlgebraZp64(ring), lMonomialTerms);
        this.ring = ring;
    }

    static void add(Map<DegreeVector, MonomialZp64> polynomial, MonomialZp64 term, IntegersZp64 ring) {
        if (term.coefficient == 0L) {
            return;
        }
        polynomial.merge(term, term, (o, n) -> {
            long r = ring.add(o.coefficient, n.coefficient);
            if (r == 0L) {
                return null;
            }
            return o.setCoefficient(r);
        });
    }

    static void subtract(Map<DegreeVector, MonomialZp64> polynomial, MonomialZp64 term, IntegersZp64 ring) {
        MultivariatePolynomialZp64.add(polynomial, term.setCoefficient(ring.negate(term.coefficient)), ring);
    }

    public static MultivariatePolynomialZp64 create(int nVariables, IntegersZp64 ring, Comparator<DegreeVector> ordering, MonomialSet<MonomialZp64> terms) {
        return new MultivariatePolynomialZp64(nVariables, ring, ordering, terms);
    }

    public static MultivariatePolynomialZp64 create(int nVariables, IntegersZp64 ring, Comparator<DegreeVector> ordering, Iterable<MonomialZp64> terms) {
        MonomialSet<MonomialZp64> map = new MonomialSet<MonomialZp64>(ordering);
        for (MonomialZp64 term : terms) {
            MultivariatePolynomialZp64.add(map, term.setCoefficient(ring.modulus(term.coefficient)), ring);
        }
        return new MultivariatePolynomialZp64(nVariables, ring, ordering, map);
    }

    public static MultivariatePolynomialZp64 create(int nVariables, IntegersZp64 ring, Comparator<DegreeVector> ordering, MonomialZp64 ... terms) {
        return MultivariatePolynomialZp64.create(nVariables, ring, ordering, Arrays.asList(terms));
    }

    public static MultivariatePolynomialZp64 zero(int nVariables, IntegersZp64 ring, Comparator<DegreeVector> ordering) {
        return new MultivariatePolynomialZp64(nVariables, ring, ordering, new MonomialSet<MonomialZp64>(ordering));
    }

    public static MultivariatePolynomialZp64 one(int nVariables, IntegersZp64 ring, Comparator<DegreeVector> ordering) {
        return MultivariatePolynomialZp64.create(nVariables, ring, ordering, new MonomialZp64(nVariables, 1L));
    }

    public static MultivariatePolynomialZp64 parse(String string, IntegersZp64 ring, String ... variables) {
        return MultivariatePolynomialZp64.parse(string, ring, MonomialOrder.DEFAULT, variables);
    }

    @Deprecated
    public static MultivariatePolynomialZp64 parse(String string, IntegersZp64 ring) {
        return MultivariatePolynomialZp64.parse(string, ring, MonomialOrder.DEFAULT);
    }

    public static MultivariatePolynomialZp64 parse(String string, IntegersZp64 ring, Comparator<DegreeVector> ordering, String ... variables) {
        IntegersZp lDomain = ring.asGenericRing();
        return MultivariatePolynomial.asOverZp64(MultivariatePolynomial.parse(string, lDomain, ordering, variables));
    }

    @Deprecated
    public static MultivariatePolynomialZp64 parse(String string, IntegersZp64 ring, Comparator<DegreeVector> ordering) {
        IntegersZp lDomain = ring.asGenericRing();
        return MultivariatePolynomial.asOverZp64(MultivariatePolynomial.parse(string, lDomain, ordering));
    }

    public static MultivariatePolynomialZp64 asMultivariate(UnivariatePolynomialZp64 poly, int nVariables, int variable, Comparator<DegreeVector> ordering) {
        MonomialSet<MonomialZp64> map = new MonomialSet<MonomialZp64>(ordering);
        for (int i = poly.degree(); i >= 0; --i) {
            if (poly.isZeroAt(i)) continue;
            int[] degreeVector = new int[nVariables];
            degreeVector[variable] = i;
            map.add(new MonomialZp64(degreeVector, i, poly.get(i)));
        }
        return new MultivariatePolynomialZp64(nVariables, poly.ring, ordering, map);
    }

    @Override
    public UnivariatePolynomialZp64 asUnivariate() {
        if (this.isConstant()) {
            return UnivariatePolynomialZp64.createUnsafe(this.ring, new long[]{this.lc()});
        }
        int[] degrees = this.degreesRef();
        int theVar = -1;
        for (int i = 0; i < degrees.length; ++i) {
            if (degrees[i] == 0) continue;
            if (theVar != -1) {
                throw new IllegalArgumentException("not a univariate polynomial: " + this);
            }
            theVar = i;
        }
        if (theVar == -1) {
            throw new IllegalStateException("Not a univariate polynomial: " + this);
        }
        long[] univarData = new long[degrees[theVar] + 1];
        for (MonomialZp64 e : this.terms) {
            univarData[e.exponents[theVar]] = e.coefficient;
        }
        return UnivariatePolynomialZp64.createUnsafe(this.ring, univarData);
    }

    @Override
    public MultivariatePolynomial<UnivariatePolynomialZp64> asOverUnivariate(int variable) {
        UnivariatePolynomialZp64 factory = UnivariatePolynomialZp64.zero(this.ring);
        UnivariateRing<UnivariatePolynomialZp64> pDomain = new UnivariateRing<UnivariatePolynomialZp64>(factory);
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering)));
        for (MonomialZp64 e : this.terms) {
            Monomial<UnivariatePolynomialZp64> eMonomial = new Monomial<UnivariatePolynomialZp64>(e.dvSetZero(variable), factory.createMonomial(e.coefficient, e.exponents[variable]));
            MultivariatePolynomial.add(newData, eMonomial, pDomain);
        }
        return new MultivariatePolynomial<UnivariatePolynomialZp64>(this.nVariables, pDomain, this.ordering, newData);
    }

    @Override
    public MultivariatePolynomial<UnivariatePolynomialZp64> asOverUnivariateEliminate(int variable) {
        UnivariatePolynomialZp64 factory = UnivariatePolynomialZp64.zero(this.ring);
        UnivariateRing<UnivariatePolynomialZp64> pDomain = new UnivariateRing<UnivariatePolynomialZp64>(factory);
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering)));
        for (MonomialZp64 e : this.terms) {
            Monomial<UnivariatePolynomialZp64> eMonomial = new Monomial<UnivariatePolynomialZp64>(e.dvWithout(variable), factory.createMonomial(e.coefficient, e.exponents[variable]));
            MultivariatePolynomial.add(newData, eMonomial, pDomain);
        }
        return new MultivariatePolynomial<UnivariatePolynomialZp64>(this.nVariables - 1, pDomain, this.ordering, newData);
    }

    @Override
    public MultivariatePolynomial<MultivariatePolynomialZp64> asOverMultivariate(int ... variables) {
        MultivariateRing<MultivariatePolynomialZp64> ring = new MultivariateRing<MultivariatePolynomialZp64>(this);
        MonomialSet terms = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering)));
        for (MonomialZp64 term : this) {
            int[] coeffExponents = new int[this.nVariables];
            for (int var : variables) {
                coeffExponents[var] = term.exponents[var];
            }
            Monomial<MultivariatePolynomialZp64> newTerm = new Monomial<MultivariatePolynomialZp64>(term.dvSetZero(variables), (MultivariatePolynomialZp64)this.create(new MonomialZp64(coeffExponents, term.coefficient)));
            MultivariatePolynomial.add(terms, newTerm, ring);
        }
        return new MultivariatePolynomial<MultivariatePolynomialZp64>(this.nVariables, ring, this.ordering, terms);
    }

    @Override
    public MultivariatePolynomial<MultivariatePolynomialZp64> asOverMultivariateEliminate(int[] variables, Comparator<DegreeVector> ordering) {
        variables = (int[])variables.clone();
        Arrays.sort(variables);
        int[] restVariables = ArraysUtil.intSetDifference(ArraysUtil.sequence(this.nVariables), variables);
        MultivariateRing<MultivariatePolynomialZp64> ring = new MultivariateRing<MultivariatePolynomialZp64>((MultivariatePolynomialZp64)this.create(variables.length, new MonomialSet((Comparator<? super DegreeVector>)ordering)));
        MonomialSet terms = new MonomialSet((Comparator<? super DegreeVector>)ordering);
        for (MonomialZp64 term : this) {
            int i = 0;
            int[] coeffExponents = new int[variables.length];
            for (int var : variables) {
                coeffExponents[i++] = term.exponents[var];
            }
            i = 0;
            int[] termExponents = new int[restVariables.length];
            for (int var : restVariables) {
                termExponents[i++] = term.exponents[var];
            }
            Monomial<MultivariatePolynomialZp64> newTerm = new Monomial<MultivariatePolynomialZp64>(termExponents, MultivariatePolynomialZp64.create(variables.length, this.ring, (Comparator<DegreeVector>)this.ordering, new MonomialZp64(coeffExponents, term.coefficient)));
            MultivariatePolynomial.add(terms, newTerm, ring);
        }
        return new MultivariatePolynomial<MultivariatePolynomialZp64>(restVariables.length, ring, ordering, terms);
    }

    public static MultivariatePolynomialZp64 asNormalMultivariate(MultivariatePolynomial<UnivariatePolynomialZp64> poly, int variable) {
        IntegersZp64 ring = ((UnivariatePolynomialZp64)poly.ring.getZero()).ring;
        int nVariables = poly.nVariables + 1;
        MultivariatePolynomialZp64 result = MultivariatePolynomialZp64.zero(nVariables, ring, poly.ordering);
        for (Monomial entry : poly.terms) {
            UnivariatePolynomialZp64 uPoly = (UnivariatePolynomialZp64)entry.coefficient;
            DegreeVector dv = entry.dvInsert(variable);
            for (int i = 0; i <= uPoly.degree(); ++i) {
                if (uPoly.isZeroAt(i)) continue;
                result.add(new MonomialZp64(dv.dvSet(variable, i), uPoly.get(i)));
            }
        }
        return result;
    }

    public static MultivariatePolynomialZp64 asNormalMultivariate(MultivariatePolynomial<MultivariatePolynomialZp64> poly) {
        IntegersZp64 ring = ((MultivariatePolynomialZp64)poly.ring.getZero()).ring;
        int nVariables = poly.nVariables;
        MultivariatePolynomialZp64 result = MultivariatePolynomialZp64.zero(nVariables, ring, poly.ordering);
        for (Monomial term : poly.terms) {
            MultivariatePolynomialZp64 uPoly = (MultivariatePolynomialZp64)term.coefficient;
            result.add(uPoly.clone().multiply(new MonomialZp64(term.exponents, term.totalDegree, 1L)));
        }
        return result;
    }

    public static MultivariatePolynomialZp64 asNormalMultivariate(MultivariatePolynomial<MultivariatePolynomialZp64> poly, int[] coefficientVariables, int[] mainVariables) {
        IntegersZp64 ring = ((MultivariatePolynomialZp64)poly.ring.getZero()).ring;
        int nVariables = coefficientVariables.length + mainVariables.length;
        MultivariatePolynomialZp64 result = MultivariatePolynomialZp64.zero(nVariables, ring, poly.ordering);
        for (Monomial term : poly.terms) {
            MultivariatePolynomialZp64 coefficient = (MultivariatePolynomialZp64)((MultivariatePolynomialZp64)term.coefficient).joinNewVariables(nVariables, coefficientVariables);
            Monomial t = (Monomial)term.joinNewVariables(nVariables, mainVariables);
            result.add(coefficient.multiply(new MonomialZp64(t.exponents, t.totalDegree, 1L)));
        }
        return result;
    }

    public MultivariatePolynomial<BigInteger> asPolyZSymmetric() {
        MonomialSet bTerms = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering)));
        for (MonomialZp64 t : this) {
            bTerms.add(new Monomial<BigInteger>(t.exponents, t.totalDegree, BigInteger.valueOf(this.ring.symmetricForm(t.coefficient))));
        }
        return new MultivariatePolynomial<BigInteger>(this.nVariables, Rings.Z, this.ordering, bTerms);
    }

    public MultivariatePolynomial<BigInteger> asPolyZ() {
        MonomialSet bTerms = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering)));
        for (MonomialZp64 t : this) {
            bTerms.add(t.toBigMonomial());
        }
        return new MultivariatePolynomial<BigInteger>(this.nVariables, Rings.Z, this.ordering, bTerms);
    }

    public MultivariatePolynomial<BigInteger> toBigPoly() {
        MonomialSet bTerms = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering)));
        for (MonomialZp64 t : this) {
            bTerms.add(t.toBigMonomial());
        }
        return new MultivariatePolynomial<BigInteger>(this.nVariables, this.ring.asGenericRing(), this.ordering, bTerms);
    }

    @Override
    public MultivariatePolynomialZp64 contentAsPoly() {
        return this.createConstant(this.content());
    }

    @Override
    public MultivariatePolynomialZp64 lcAsPoly() {
        return this.createConstant(this.lc());
    }

    @Override
    public MultivariatePolynomialZp64 lcAsPoly(Comparator<DegreeVector> ordering) {
        return this.createConstant(this.lc(ordering));
    }

    @Override
    public MultivariatePolynomialZp64 ccAsPoly() {
        return this.createConstant(this.cc());
    }

    @Override
    MultivariatePolynomialZp64 create(int nVariables, Comparator<DegreeVector> ordering, MonomialSet<MonomialZp64> lMonomialTerms) {
        return new MultivariatePolynomialZp64(nVariables, this.ring, ordering, lMonomialTerms);
    }

    @Override
    public boolean isOverField() {
        return true;
    }

    @Override
    public boolean isOverFiniteField() {
        return true;
    }

    @Override
    public boolean isOverZ() {
        return false;
    }

    @Override
    public BigInteger coefficientRingCardinality() {
        return BigInteger.valueOf(this.ring.modulus);
    }

    @Override
    public BigInteger coefficientRingCharacteristic() {
        return BigInteger.valueOf(this.ring.modulus);
    }

    @Override
    public boolean isOverPerfectPower() {
        return this.ring.isPerfectPower();
    }

    @Override
    public BigInteger coefficientRingPerfectPowerBase() {
        return BigInteger.valueOf(this.ring.perfectPowerBase());
    }

    @Override
    public BigInteger coefficientRingPerfectPowerExponent() {
        return BigInteger.valueOf(this.ring.perfectPowerExponent());
    }

    public MultivariatePolynomialZp64[] createArray(int length) {
        return new MultivariatePolynomialZp64[length];
    }

    public MultivariatePolynomialZp64[][] createArray2d(int length) {
        return new MultivariatePolynomialZp64[length][];
    }

    public MultivariatePolynomialZp64[][] createArray2d(int length1, int length2) {
        return new MultivariatePolynomialZp64[length1][length2];
    }

    @Override
    public boolean sameCoefficientRingWith(MultivariatePolynomialZp64 oth) {
        return this.nVariables == oth.nVariables && this.ring.equals(oth.ring);
    }

    @Override
    public MultivariatePolynomialZp64 setCoefficientRingFrom(MultivariatePolynomialZp64 lMonomialTerms) {
        return this.setRing(lMonomialTerms.ring);
    }

    @Override
    protected void release() {
        super.release();
    }

    public MultivariatePolynomialZp64 setRing(long newModulus) {
        return this.setRing(new IntegersZp64(newModulus));
    }

    public MultivariatePolynomialZp64 setRing(IntegersZp64 newDomain) {
        MonomialSet<MonomialZp64> newData = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (MonomialZp64 e : this.terms) {
            this.add(newData, e.setCoefficient(newDomain.modulus(e.coefficient)));
        }
        return new MultivariatePolynomialZp64(this.nVariables, newDomain, this.ordering, newData);
    }

    public <E> MultivariatePolynomial<E> setRing(Ring<E> newRing) {
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering)));
        for (MonomialZp64 e : this.terms) {
            MultivariatePolynomial.add(newData, new Monomial<long>(e, newRing.valueOf(e.coefficient)), newRing);
        }
        return new MultivariatePolynomial<E>(this.nVariables, newRing, this.ordering, newData);
    }

    public MultivariatePolynomialZp64 setRingUnsafe(IntegersZp64 newDomain) {
        return new MultivariatePolynomialZp64(this.nVariables, newDomain, this.ordering, this.terms);
    }

    @Override
    public MultivariatePolynomialZp64 createConstant(long val) {
        MonomialSet<MonomialZp64> data = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        if (val != 0L) {
            data.add(new MonomialZp64(this.nVariables, val));
        }
        return new MultivariatePolynomialZp64(this.nVariables, this.ring, this.ordering, data);
    }

    @Override
    public MultivariatePolynomialZp64 createConstantFromTerm(MonomialZp64 monomial) {
        return this.createConstant(monomial.coefficient);
    }

    @Override
    public MultivariatePolynomialZp64 createZero() {
        return this.createConstant(0L);
    }

    @Override
    public MultivariatePolynomialZp64 createOne() {
        return this.createConstant(1L);
    }

    public MultivariatePolynomialZp64 createLinear(int variable, long cc, long lc) {
        MonomialSet<MonomialZp64> data = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        lc = this.ring.modulus(lc);
        if ((cc = this.ring.modulus(cc)) != 0L) {
            data.add(new MonomialZp64(this.nVariables, cc));
        }
        if (lc != 0L) {
            int[] lcDegreeVector = new int[this.nVariables];
            lcDegreeVector[variable] = 1;
            data.add(new MonomialZp64(lcDegreeVector, 1, lc));
        }
        return new MultivariatePolynomialZp64(this.nVariables, this.ring, this.ordering, data);
    }

    @Override
    public boolean isMonic() {
        return this.lc() == 1L;
    }

    @Override
    public int signumOfLC() {
        return Long.signum(this.lc());
    }

    @Override
    public boolean isOne() {
        if (this.size() != 1) {
            return false;
        }
        MonomialZp64 lt = (MonomialZp64)this.terms.first();
        return lt.isZeroVector() && lt.coefficient == 1L;
    }

    @Override
    public boolean isUnitCC() {
        return this.cc() == 1L;
    }

    @Override
    public boolean isConstant() {
        return this.size() == 0 || this.size() == 1 && ((MonomialZp64)this.terms.first()).isZeroVector();
    }

    public long lc() {
        return ((MonomialZp64)this.lt()).coefficient;
    }

    public long lc(Comparator<DegreeVector> ordering) {
        return ((MonomialZp64)this.lt(ordering)).coefficient;
    }

    public MultivariatePolynomialZp64 setLC(long val) {
        if (this.isZero()) {
            return this.add(val);
        }
        this.terms.add(((MonomialZp64)this.lt()).setCoefficient(this.ring.modulus(val)));
        this.release();
        return this;
    }

    public long cc() {
        MonomialZp64 zero = new MonomialZp64(this.nVariables, 0L);
        return this.terms.getOrDefault((Object)zero, zero).coefficient;
    }

    public long content() {
        return this.lc();
    }

    public long[] coefficients() {
        return this.terms.values().stream().mapToLong(x -> x.coefficient).toArray();
    }

    @Override
    public MultivariatePolynomialZp64 primitivePart(int variable) {
        return MultivariatePolynomialZp64.asNormalMultivariate((MultivariatePolynomial<UnivariatePolynomialZp64>)this.asOverUnivariateEliminate(variable).primitivePart(), variable);
    }

    @Override
    public UnivariatePolynomialZp64 contentUnivariate(int variable) {
        return this.asOverUnivariate(variable).content();
    }

    @Override
    public MultivariatePolynomialZp64 primitivePart() {
        return this.divide(this.content());
    }

    @Override
    public MultivariatePolynomialZp64 primitivePartSameSign() {
        return this.primitivePart();
    }

    @Override
    public MultivariatePolynomialZp64 divideByLC(MultivariatePolynomialZp64 other) {
        return this.divide(other.lc());
    }

    public MultivariatePolynomialZp64 divide(long factor) {
        if (factor == 1L) {
            return this;
        }
        return this.multiply(this.ring.reciprocal(factor));
    }

    @Override
    public MultivariatePolynomialZp64 divideOrNull(MonomialZp64 monomial) {
        if (monomial.isZeroVector()) {
            return this.divide(monomial.coefficient);
        }
        long reciprocal = this.ring.reciprocal(monomial.coefficient);
        MonomialSet<MonomialZp64> map = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (MonomialZp64 term : this.terms) {
            DegreeVector dv = term.dvDivideOrNull(monomial);
            if (dv == null) {
                return null;
            }
            map.add(new MonomialZp64(dv, this.ring.multiply(term.coefficient, reciprocal)));
        }
        this.loadFrom(map);
        this.release();
        return this;
    }

    @Override
    public MultivariatePolynomialZp64 monic() {
        if (this.isMonic()) {
            return this;
        }
        if (this.isZero()) {
            return this;
        }
        return this.divide(this.lc());
    }

    @Override
    public MultivariatePolynomialZp64 monic(Comparator<DegreeVector> ordering) {
        if (this.isZero()) {
            return this;
        }
        return this.divide(this.lc(ordering));
    }

    public MultivariatePolynomialZp64 monic(long factor) {
        return this.multiply(this.ring.multiply(this.ring.modulus(factor), this.ring.reciprocal(this.lc())));
    }

    public MultivariatePolynomialZp64 monic(Comparator<DegreeVector> ordering, long factor) {
        return this.multiply(this.ring.multiply(this.ring.modulus(factor), this.ring.reciprocal(this.lc(ordering))));
    }

    @Override
    public MultivariatePolynomialZp64 monicWithLC(MultivariatePolynomialZp64 other) {
        if (this.lc() == other.lc()) {
            return this;
        }
        return this.monic(other.lc());
    }

    @Override
    public MultivariatePolynomialZp64 monicWithLC(Comparator<DegreeVector> ordering, MultivariatePolynomialZp64 other) {
        long olc;
        long lc = this.lc(ordering);
        if (lc == (olc = other.lc(ordering))) {
            return this;
        }
        return this.monic(ordering, olc);
    }

    public IUnivariatePolynomial toDenseRecursiveForm() {
        if (this.nVariables == 0) {
            throw new IllegalArgumentException("#variables = 0");
        }
        return this.toDenseRecursiveForm(this.nVariables - 1);
    }

    private IUnivariatePolynomial toDenseRecursiveForm(int variable) {
        if (variable == 0) {
            return this.asUnivariate();
        }
        UnivariatePolynomial result = this.asUnivariateEliminate(variable);
        IUnivariatePolynomial[] data = new IUnivariatePolynomial[result.degree() + 1];
        for (int j = 0; j < data.length; ++j) {
            data[j] = ((MultivariatePolynomialZp64)result.get(j)).toDenseRecursiveForm(variable - 1);
        }
        return UnivariatePolynomial.create(Rings.PolynomialRing(data[0]), data);
    }

    public static MultivariatePolynomialZp64 fromDenseRecursiveForm(IUnivariatePolynomial recForm, Comparator<DegreeVector> ordering) {
        int nVariables = 1;
        IUnivariatePolynomial p = recForm;
        while (p instanceof UnivariatePolynomial) {
            p = (IUnivariatePolynomial)((UnivariatePolynomial)p).cc();
            ++nVariables;
        }
        return MultivariatePolynomialZp64.fromDenseRecursiveForm(recForm, nVariables, ordering);
    }

    public static MultivariatePolynomialZp64 fromDenseRecursiveForm(IUnivariatePolynomial recForm, int nVariables, Comparator<DegreeVector> ordering) {
        return MultivariatePolynomialZp64.fromDenseRecursiveForm(recForm, nVariables, ordering, nVariables - 1);
    }

    private static MultivariatePolynomialZp64 fromDenseRecursiveForm(IUnivariatePolynomial recForm, int nVariables, Comparator<DegreeVector> ordering, int variable) {
        if (variable == 0) {
            return MultivariatePolynomialZp64.asMultivariate((UnivariatePolynomialZp64)recForm, nVariables, 0, ordering);
        }
        UnivariatePolynomial _recForm = (UnivariatePolynomial)recForm;
        MultivariatePolynomialZp64[] data = new MultivariatePolynomialZp64[_recForm.degree() + 1];
        for (int j = 0; j < data.length; ++j) {
            data[j] = MultivariatePolynomialZp64.fromDenseRecursiveForm((IUnivariatePolynomial)_recForm.get(j), nVariables, ordering, variable - 1);
        }
        return MultivariatePolynomialZp64.asMultivariate(UnivariatePolynomial.create(Rings.MultivariateRing(data[0]), data), variable);
    }

    public static long evaluateDenseRecursiveForm(IUnivariatePolynomial recForm, long[] values) {
        int nVariables = 1;
        IUnivariatePolynomial p = recForm;
        while (p instanceof UnivariatePolynomial) {
            p = (IUnivariatePolynomial)((UnivariatePolynomial)p).cc();
            ++nVariables;
        }
        if (nVariables != values.length) {
            throw new IllegalArgumentException();
        }
        return MultivariatePolynomialZp64.evaluateDenseRecursiveForm(recForm, values, ((UnivariatePolynomialZp64)p).ring, nVariables - 1);
    }

    private static long evaluateDenseRecursiveForm(IUnivariatePolynomial recForm, long[] values, IntegersZp64 ring, int variable) {
        if (variable == 0) {
            return ((UnivariatePolynomialZp64)recForm).evaluate(values[0]);
        }
        UnivariatePolynomial _recForm = (UnivariatePolynomial)recForm;
        long result = 0L;
        for (int i = _recForm.degree(); i >= 0; --i) {
            result = ring.add(ring.multiply(values[variable], result), MultivariatePolynomialZp64.evaluateDenseRecursiveForm((IUnivariatePolynomial)_recForm.get(i), values, ring, variable - 1));
        }
        return result;
    }

    public AMultivariatePolynomial toSparseRecursiveForm() {
        if (this.nVariables == 0) {
            throw new IllegalArgumentException("#variables = 0");
        }
        return this.toSparseRecursiveForm(this.nVariables - 1);
    }

    private AMultivariatePolynomial toSparseRecursiveForm(int variable) {
        if (variable == 0) {
            assert (MonomialOrder.isGradedOrder(this.ordering));
            return this.setNVariables(1);
        }
        MultivariatePolynomial<MultivariatePolynomialZp64> result = this.asOverMultivariateEliminate(ArraysUtil.sequence(0, variable), MonomialOrder.GRLEX);
        Monomial[] data = new Monomial[result.size() == 0 ? 1 : result.size()];
        int j = 0;
        for (Monomial monomial : result.size() == 0 ? Collections.singletonList((Monomial)result.lt()) : result) {
            data[j++] = new Monomial<AMultivariatePolynomial>(monomial, ((MultivariatePolynomialZp64)monomial.coefficient).toSparseRecursiveForm(variable - 1));
        }
        return MultivariatePolynomial.create(1, Rings.MultivariateRing((AMultivariatePolynomial)data[0].coefficient), MonomialOrder.GRLEX, data);
    }

    public static MultivariatePolynomialZp64 fromSparseRecursiveForm(AMultivariatePolynomial recForm, Comparator<DegreeVector> ordering) {
        int nVariables = 1;
        AMultivariatePolynomial p = recForm;
        while (p instanceof MultivariatePolynomial) {
            p = (AMultivariatePolynomial)((MultivariatePolynomial)p).cc();
            ++nVariables;
        }
        return MultivariatePolynomialZp64.fromSparseRecursiveForm(recForm, nVariables, ordering);
    }

    public static MultivariatePolynomialZp64 fromSparseRecursiveForm(AMultivariatePolynomial recForm, int nVariables, Comparator<DegreeVector> ordering) {
        return MultivariatePolynomialZp64.fromSparseRecursiveForm(recForm, nVariables, ordering, nVariables - 1);
    }

    private static MultivariatePolynomialZp64 fromSparseRecursiveForm(AMultivariatePolynomial recForm, int nVariables, Comparator<DegreeVector> ordering, int variable) {
        if (variable == 0) {
            assert (recForm.nVariables == 1);
            return (MultivariatePolynomialZp64)((MultivariatePolynomialZp64)((MultivariatePolynomialZp64)recForm).setNVariables(nVariables)).setOrdering(ordering);
        }
        MultivariatePolynomial _recForm = (MultivariatePolynomial)recForm;
        Monomial[] data = new Monomial[_recForm.size() == 0 ? 1 : _recForm.size()];
        int j = 0;
        for (Monomial monomial : _recForm.size() == 0 ? Collections.singletonList((Monomial)_recForm.lt()) : _recForm) {
            int[] exponents = new int[nVariables];
            exponents[variable] = monomial.totalDegree;
            data[j++] = new Monomial<MultivariatePolynomialZp64>(exponents, monomial.totalDegree, MultivariatePolynomialZp64.fromSparseRecursiveForm((AMultivariatePolynomial)monomial.coefficient, nVariables, ordering, variable - 1));
        }
        MultivariatePolynomial<MultivariatePolynomialZp64> result = MultivariatePolynomial.create(nVariables, Rings.MultivariateRing((MultivariatePolynomialZp64)data[0].coefficient), ordering, data);
        return MultivariatePolynomialZp64.asNormalMultivariate(result);
    }

    public static long evaluateSparseRecursiveForm(AMultivariatePolynomial recForm, long[] values) {
        int nVariables = 1;
        AMultivariatePolynomial p = recForm;
        TIntArrayList degrees = new TIntArrayList();
        while (p instanceof MultivariatePolynomial) {
            p = (AMultivariatePolynomial)((MultivariatePolynomial)p).cc();
            degrees.add(p.degree());
            ++nVariables;
        }
        degrees.add(p.degree());
        if (nVariables != values.length) {
            throw new IllegalArgumentException();
        }
        IntegersZp64 ring = ((MultivariatePolynomialZp64)p).ring;
        lPrecomputedPowers[] pp = new lPrecomputedPowers[nVariables];
        for (int i = 0; i < nVariables; ++i) {
            pp[i] = new lPrecomputedPowers(Math.min(degrees.get(i), 1014), values[i], ring);
        }
        return MultivariatePolynomialZp64.evaluateSparseRecursiveForm(recForm, new lPrecomputedPowersHolder(ring, pp), nVariables - 1);
    }

    static long evaluateSparseRecursiveForm(AMultivariatePolynomial recForm, lPrecomputedPowersHolder ph, int variable) {
        IntegersZp64 ring = ph.ring;
        if (variable == 0) {
            assert (MonomialOrder.isGradedOrder(recForm.ordering));
            MultivariatePolynomialZp64 _recForm = (MultivariatePolynomialZp64)recForm;
            Iterator it = _recForm.terms.descendingIterator();
            int previousExponent = -1;
            long result = 0L;
            while (it.hasNext()) {
                MonomialZp64 m = (MonomialZp64)it.next();
                assert (previousExponent == -1 || previousExponent > m.totalDegree);
                result = ring.add(ring.multiply(result, ph.pow(variable, previousExponent == -1 ? 1 : previousExponent - m.totalDegree)), m.coefficient);
                previousExponent = m.totalDegree;
            }
            if (previousExponent > 0) {
                result = ring.multiply(result, ph.pow(variable, previousExponent));
            }
            return result;
        }
        MultivariatePolynomial _recForm = (MultivariatePolynomial)recForm;
        Iterator it = _recForm.terms.descendingIterator();
        int previousExponent = -1;
        long result = 0L;
        while (it.hasNext()) {
            Monomial m = (Monomial)it.next();
            assert (previousExponent == -1 || previousExponent > m.totalDegree);
            result = ring.add(ring.multiply(result, ph.pow(variable, previousExponent == -1 ? 1 : previousExponent - m.totalDegree)), MultivariatePolynomialZp64.evaluateSparseRecursiveForm((AMultivariatePolynomial)m.coefficient, ph, variable - 1));
            previousExponent = m.totalDegree;
        }
        if (previousExponent > 0) {
            result = ring.multiply(result, ph.pow(variable, previousExponent));
        }
        return result;
    }

    public HornerFormZp64 getHornerForm(int[] evaluationVariables) {
        int[] evalDegrees = ArraysUtil.select(this.degreesRef(), evaluationVariables);
        MultivariatePolynomial p = this.asOverMultivariateEliminate(evaluationVariables);
        IPolynomialRing<AMultivariatePolynomial> newRing = Rings.PolynomialRing(((MultivariatePolynomialZp64)p.cc()).toSparseRecursiveForm());
        return new HornerFormZp64(this.ring, evalDegrees, evaluationVariables.length, p.mapCoefficients(newRing, MultivariatePolynomialZp64::toSparseRecursiveForm));
    }

    public MultivariatePolynomialZp64 evaluate(int variable, long value) {
        if ((value = this.ring.modulus(value)) == 0L) {
            return (MultivariatePolynomialZp64)this.evaluateAtZero(variable);
        }
        lPrecomputedPowers powers = new lPrecomputedPowers(value, this.ring);
        return this.evaluate(variable, powers);
    }

    MultivariatePolynomialZp64 evaluate(int variable, lPrecomputedPowers powers) {
        if (this.degree(variable) == 0) {
            return this.clone();
        }
        if (powers.value == 0L) {
            return (MultivariatePolynomialZp64)this.evaluateAtZero(variable);
        }
        MonomialSet<MonomialZp64> newData = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (MonomialZp64 el : this.terms) {
            long val = this.ring.multiply(el.coefficient, powers.pow(el.exponents[variable]));
            this.add(newData, ((MonomialZp64)el.setZero(variable)).setCoefficient(val));
        }
        return new MultivariatePolynomialZp64(this.nVariables, this.ring, this.ordering, newData);
    }

    UnivariatePolynomialZp64 evaluateAtZeroAllExcept(int variable) {
        long[] uData = new long[this.degree(variable) + 1];
        for (MonomialZp64 el : this.terms) {
            if (el.totalDegree != el.exponents[variable]) continue;
            int uExp = el.exponents[variable];
            uData[uExp] = this.ring.add(uData[uExp], el.coefficient);
        }
        return UnivariatePolynomialZp64.createUnsafe(this.ring, uData);
    }

    public MultivariatePolynomialZp64 evaluate(int[] variables, long[] values) {
        for (long value : values) {
            if (value == 0L) continue;
            return this.evaluate(this.mkPrecomputedPowers(variables, values), variables);
        }
        return (MultivariatePolynomialZp64)this.evaluateAtZero(variables);
    }

    MultivariatePolynomialZp64 evaluate(lPrecomputedPowersHolder powers, int[] variables) {
        MonomialSet<MonomialZp64> newData = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        Iterator iterator = this.terms.iterator();
        while (iterator.hasNext()) {
            MonomialZp64 el;
            MonomialZp64 r = el = (MonomialZp64)iterator.next();
            long value = el.coefficient;
            for (int variable : variables) {
                value = this.ring.multiply(value, powers.pow(variable, el.exponents[variable]));
            }
            r = ((MonomialZp64)r.setZero(variables)).setCoefficient(value);
            this.add(newData, r);
        }
        return new MultivariatePolynomialZp64(this.nVariables, this.ring, this.ordering, newData);
    }

    public long evaluate(long ... values) {
        if (values.length != this.nVariables) {
            throw new IllegalArgumentException();
        }
        if (this.nVariables == 1 && MonomialOrder.isGradedOrder(this.ordering)) {
            return MultivariatePolynomialZp64.evaluateSparseRecursiveForm(this, values);
        }
        return this.evaluate(ArraysUtil.sequence(0, this.nVariables), values).cc();
    }

    public MultivariatePolynomialZp64[] evaluate(int variable, long ... values) {
        return (MultivariatePolynomialZp64[])Arrays.stream(values).mapToObj(p -> this.evaluate(variable, p)).toArray(MultivariatePolynomialZp64[]::new);
    }

    public MultivariatePolynomialZp64 eliminate(int variable, long value) {
        value = this.ring.modulus(value);
        MonomialSet<MonomialZp64> newData = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        lPrecomputedPowers powers = new lPrecomputedPowers(value, this.ring);
        for (MonomialZp64 el : this.terms) {
            long val = this.ring.multiply(el.coefficient, powers.pow(el.exponents[variable]));
            this.add(newData, ((MonomialZp64)el.without(variable)).setCoefficient(val));
        }
        return new MultivariatePolynomialZp64(this.nVariables - 1, this.ring, this.ordering, newData);
    }

    public MultivariatePolynomialZp64 eliminate(int[] variables, long[] values) {
        for (long value : values) {
            if (value == 0L) continue;
            return this.eliminate(this.mkPrecomputedPowers(variables, values), variables);
        }
        return (MultivariatePolynomialZp64)((MultivariatePolynomialZp64)this.evaluateAtZero(variables)).dropVariables(variables);
    }

    MultivariatePolynomialZp64 eliminate(lPrecomputedPowersHolder powers, int[] variables) {
        MonomialSet<MonomialZp64> newData = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        Iterator iterator = this.terms.iterator();
        while (iterator.hasNext()) {
            MonomialZp64 el;
            MonomialZp64 r = el = (MonomialZp64)iterator.next();
            long value = el.coefficient;
            for (int variable : variables) {
                value = this.ring.multiply(value, powers.pow(variable, el.exponents[variable]));
            }
            r = ((MonomialZp64)r.without(variables)).setCoefficient(value);
            this.add(newData, r);
        }
        return new MultivariatePolynomialZp64(this.nVariables - variables.length, this.ring, this.ordering, newData);
    }

    public lPrecomputedPowersHolder mkPrecomputedPowers(int variable, long value) {
        lPrecomputedPowers[] pp = new lPrecomputedPowers[this.nVariables];
        pp[variable] = new lPrecomputedPowers(Math.min(this.degree(variable), 1014), value, this.ring);
        return new lPrecomputedPowersHolder(this.ring, pp);
    }

    public lPrecomputedPowersHolder mkPrecomputedPowers(int[] variables, long[] values) {
        int[] degrees = this.degreesRef();
        lPrecomputedPowers[] pp = new lPrecomputedPowers[this.nVariables];
        for (int i = 0; i < variables.length; ++i) {
            pp[variables[i]] = new lPrecomputedPowers(Math.min(degrees[variables[i]], 1014), values[i], this.ring);
        }
        return new lPrecomputedPowersHolder(this.ring, pp);
    }

    public static lPrecomputedPowersHolder mkPrecomputedPowers(int nVariables, IntegersZp64 ring, int[] variables, long[] values) {
        lPrecomputedPowers[] pp = new lPrecomputedPowers[nVariables];
        for (int i = 0; i < variables.length; ++i) {
            pp[variables[i]] = new lPrecomputedPowers(1014, values[i], ring);
        }
        return new lPrecomputedPowersHolder(ring, pp);
    }

    public lPrecomputedPowersHolder mkPrecomputedPowers(long[] values) {
        if (values.length != this.nVariables) {
            throw new IllegalArgumentException();
        }
        int[] degrees = this.degreesRef();
        lPrecomputedPowers[] pp = new lPrecomputedPowers[this.nVariables];
        for (int i = 0; i < this.nVariables; ++i) {
            pp[i] = new lPrecomputedPowers(Math.min(degrees[i], 1014), values[i], this.ring);
        }
        return new lPrecomputedPowersHolder(this.ring, pp);
    }

    public MultivariatePolynomialZp64 substitute(int variable, MultivariatePolynomialZp64 poly) {
        if (poly.isConstant()) {
            return this.evaluate(variable, poly.cc());
        }
        lPrecomputedSubstitution subsPowers = poly.isEffectiveUnivariate() ? new lUSubstitution(poly.asUnivariate(), poly.univariateVariable(), this.nVariables, this.ordering) : new lMSubstitution(poly);
        MultivariatePolynomialZp64 result = this.createZero();
        for (MonomialZp64 term : this) {
            int exponent = term.exponents[variable];
            if (exponent == 0) {
                result.add(term);
                continue;
            }
            result.add(subsPowers.pow(exponent).multiply((MonomialZp64)term.setZero(variable)));
        }
        return result;
    }

    public MultivariatePolynomialZp64 shift(int variable, long shift) {
        if (shift == 0L) {
            return this.clone();
        }
        lUSubstitution shifts = new lUSubstitution(UnivariatePolynomialZ64.create(shift, 1L).modulus(this.ring), variable, this.nVariables, this.ordering);
        MultivariatePolynomialZp64 result = this.createZero();
        for (MonomialZp64 term : this) {
            int exponent = term.exponents[variable];
            if (exponent == 0) {
                result.add(term);
                continue;
            }
            result.add(shifts.pow(exponent).multiply((MonomialZp64)term.setZero(variable)));
        }
        return result;
    }

    public MultivariatePolynomialZp64 shift(int[] variables, long[] shifts) {
        lPrecomputedSubstitution[] powers = new lPrecomputedSubstitution[this.nVariables];
        boolean allShiftsAreZero = true;
        for (int i = 0; i < variables.length; ++i) {
            if (shifts[i] != 0L) {
                allShiftsAreZero = false;
            }
            powers[variables[i]] = new lUSubstitution(UnivariatePolynomialZ64.create(shifts[i], 1L).modulus(this.ring, false), variables[i], this.nVariables, this.ordering);
        }
        if (allShiftsAreZero) {
            return this.clone();
        }
        lPrecomputedSubstitutions calculatedShifts = new lPrecomputedSubstitutions(powers);
        MultivariatePolynomialZp64 result = this.createZero();
        for (MonomialZp64 term : this) {
            MultivariatePolynomialZp64 temp = this.createOne();
            for (int variable : variables) {
                if (term.exponents[variable] == 0) continue;
                temp = temp.multiply(calculatedShifts.getSubstitutionPower(variable, term.exponents[variable]));
                term = (MonomialZp64)term.setZero(variable);
            }
            if (temp.isOne()) {
                result.add(term);
                continue;
            }
            result.add(temp.multiply(term));
        }
        return result;
    }

    @Override
    void add(MonomialSet<MonomialZp64> terms, MonomialZp64 term) {
        MultivariatePolynomialZp64.add(terms, term, this.ring);
    }

    @Override
    void subtract(MonomialSet<MonomialZp64> terms, MonomialZp64 term) {
        MultivariatePolynomialZp64.subtract(terms, term, this.ring);
    }

    @Override
    public MultivariatePolynomialZp64 add(long oth) {
        if ((oth = this.ring.modulus(oth)) == 0L) {
            return this;
        }
        this.add((MonomialSet<MonomialZp64>)this.terms, new MonomialZp64(this.nVariables, oth));
        this.release();
        return this;
    }

    @Override
    public MultivariatePolynomialZp64 subtract(long oth) {
        return this.add(this.ring.negate(this.ring.modulus(oth)));
    }

    @Override
    public MultivariatePolynomialZp64 increment() {
        return this.add(1L);
    }

    @Override
    public MultivariatePolynomialZp64 decrement() {
        return this.subtract(1L);
    }

    @Override
    public MultivariatePolynomialZp64 multiply(long factor) {
        if ((factor = this.ring.modulus(factor)) == 1L) {
            return this;
        }
        if (factor == 0L) {
            return (MultivariatePolynomialZp64)this.toZero();
        }
        Iterator it = this.terms.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            MonomialZp64 term = (MonomialZp64)entry.getValue();
            long val = this.ring.multiply(term.coefficient, factor);
            if (val == 0L) {
                it.remove();
                continue;
            }
            entry.setValue(term.setCoefficient(val));
        }
        this.release();
        return this;
    }

    @Override
    public MultivariatePolynomialZp64 multiplyByLC(MultivariatePolynomialZp64 other) {
        return this.multiply(other.lc());
    }

    @Override
    public MultivariatePolynomialZp64 multiplyByBigInteger(BigInteger factor) {
        return this.multiply(factor.mod(BigInteger.valueOf(this.ring.modulus)).longValueExact());
    }

    @Override
    public MultivariatePolynomialZp64 multiply(MonomialZp64 monomial) {
        this.checkSameDomainWith(monomial);
        if (monomial.isZeroVector()) {
            return this.multiply(monomial.coefficient);
        }
        if (monomial.coefficient == 0L) {
            return (MultivariatePolynomialZp64)this.toZero();
        }
        MonomialSet<MonomialZp64> newMap = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (MonomialZp64 thisElement : this.terms) {
            MonomialZp64 mul = this.monomialAlgebra.multiply(thisElement, monomial);
            if (mul.coefficient == 0L) continue;
            newMap.add(mul);
        }
        return (MultivariatePolynomialZp64)this.loadFrom(newMap);
    }

    @Override
    public MultivariatePolynomialZp64 multiply(MultivariatePolynomialZp64 oth) {
        this.assertSameCoefficientRingWith(oth);
        if (oth.isZero()) {
            return (MultivariatePolynomialZp64)this.toZero();
        }
        if (this.isZero()) {
            return this;
        }
        if (oth.isConstant()) {
            return this.multiply(oth.cc());
        }
        if (this.size() > KRONECKER_THRESHOLD && oth.size() > KRONECKER_THRESHOLD) {
            return this.multiplyKronecker(oth);
        }
        return this.multiplyClassic(oth);
    }

    private MultivariatePolynomialZp64 multiplyClassic(MultivariatePolynomialZp64 oth) {
        MonomialSet<MonomialZp64> newMap = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (MonomialZp64 othElement : oth.terms) {
            for (MonomialZp64 thisElement : this.terms) {
                MultivariatePolynomialZp64.add(newMap, this.monomialAlgebra.multiply(thisElement, othElement), this.ring);
            }
        }
        return (MultivariatePolynomialZp64)this.loadFrom(newMap);
    }

    private MultivariatePolynomialZp64 multiplyKronecker(MultivariatePolynomialZp64 oth) {
        int[] resultDegrees = new int[this.nVariables];
        int[] thisDegrees = this.degreesRef();
        int[] othDegrees = oth.degreesRef();
        for (int i = 0; i < resultDegrees.length; ++i) {
            resultDegrees[i] = thisDegrees[i] + othDegrees[i];
        }
        long[] map = MultivariatePolynomialZp64.KroneckerMap(resultDegrees);
        if (map == null) {
            return this.multiplyClassic(oth);
        }
        double threshold = 0.0;
        for (int i = 0; i < this.nVariables; ++i) {
            threshold += 1.0 * (double)resultDegrees[i] * (double)map[i];
        }
        if ((threshold *= 2.0) > 9.223372036854776E18) {
            return this.multiplyClassic(oth);
        }
        return this.fromKronecker(MultivariatePolynomialZp64.multiplySparseUnivariate(this.ring, this.toKronecker(map), oth.toKronecker(map)), map);
    }

    private long[][] toKronecker(long[] kroneckerMap) {
        long[][] result = new long[this.size()][2];
        int j = 0;
        for (MonomialZp64 term : this) {
            long exponent = term.exponents[0];
            for (int i = 1; i < term.exponents.length; ++i) {
                exponent += (long)term.exponents[i] * kroneckerMap[i];
            }
            result[j][0] = exponent;
            result[j][1] = term.coefficient;
            ++j;
        }
        return result;
    }

    private static TLongObjectHashMap<CfHolder> multiplySparseUnivariate(IntegersZp64 ring, long[][] a, long[][] b) {
        TLongObjectHashMap<CfHolder> result = new TLongObjectHashMap<CfHolder>(a.length + b.length);
        for (long[] ai : a) {
            for (long[] bi : b) {
                long deg = ai[0] + bi[0];
                long val = ring.multiply(ai[1], bi[1]);
                CfHolder r = result.get(deg);
                if (r != null) {
                    r.coefficient = ring.add(r.coefficient, val);
                    continue;
                }
                result.put(deg, new CfHolder(val));
            }
        }
        return result;
    }

    private MultivariatePolynomialZp64 fromKronecker(TLongObjectHashMap<CfHolder> p, long[] kroneckerMap) {
        this.terms.clear();
        TLongObjectIterator<CfHolder> it = p.iterator();
        while (it.hasNext()) {
            it.advance();
            if (it.value().coefficient == 0L) continue;
            long exponent = it.key();
            int[] exponents = new int[this.nVariables];
            for (int i = 0; i < this.nVariables; ++i) {
                long div = exponent / kroneckerMap[this.nVariables - i - 1];
                exponent -= div * kroneckerMap[this.nVariables - i - 1];
                exponents[this.nVariables - i - 1] = MachineArithmetic.safeToInt(div);
            }
            this.terms.add(new MonomialZp64(exponents, it.value().coefficient));
        }
        this.release();
        return this;
    }

    @Override
    public MultivariatePolynomialZp64 square() {
        return this.multiply(this);
    }

    @Override
    public MultivariatePolynomialZp64 evaluateAtRandom(int variable, RandomGenerator rnd) {
        return this.evaluate(variable, this.ring.randomElement(rnd));
    }

    @Override
    public MultivariatePolynomialZp64 evaluateAtRandomPreservingSkeleton(int variable, RandomGenerator rnd) {
        long randomPoint;
        MultivariatePolynomialZp64 tmp;
        Set<DegreeVector> skeleton = this.getSkeletonExcept(variable);
        while (!skeleton.equals((tmp = this.evaluate(variable, randomPoint = this.ring.randomElement(rnd))).getSkeleton())) {
        }
        return tmp;
    }

    @Override
    public MultivariatePolynomialZp64 derivative(int variable, int order) {
        if (order == 0) {
            return this.clone();
        }
        if (this.isConstant()) {
            return this.createZero();
        }
        MonomialSet<MonomialZp64> newTerms = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (MonomialZp64 term : this) {
            int exponent = term.exponents[variable];
            if (exponent < order) continue;
            long newCoefficient = term.coefficient;
            for (int i = 0; i < order; ++i) {
                newCoefficient = this.ring.multiply(newCoefficient, exponent - i);
            }
            int[] newExponents = (int[])term.exponents.clone();
            int n = variable;
            newExponents[n] = newExponents[n] - order;
            this.add(newTerms, new MonomialZp64(newExponents, term.totalDegree - order, newCoefficient));
        }
        return new MultivariatePolynomialZp64(this.nVariables, this.ring, this.ordering, newTerms);
    }

    static long seriesCoefficientFactor(int exponent, int order, IntegersZp64 ring) {
        IntegersZp64 baseDomain = ring.perfectPowerBaseDomain();
        if ((long)order < baseDomain.modulus) {
            long factor = 1L;
            for (int i = 0; i < order; ++i) {
                factor = ring.multiply(factor, exponent - i);
            }
            factor = ring.divide(factor, ring.factorial(order));
            return factor;
        }
        long numerator = 1L;
        long denominator = 1L;
        int numZeros = 0;
        int denZeros = 0;
        for (int i = 1; i <= order; ++i) {
            long num = exponent - i + 1;
            long numMod = baseDomain.modulus(num);
            while (num > 1L && numMod == 0L) {
                num = FastDivision.divideSignedFast(num, baseDomain.magic);
                numMod = baseDomain.modulus(num);
                ++numZeros;
            }
            if (numMod != 0L) {
                numerator = ring.multiply(numerator, ring == baseDomain ? numMod : ring.modulus(num));
            }
            long den = i;
            long denMod = baseDomain.modulus(i);
            while (den > 1L && denMod == 0L) {
                den = FastDivision.divideSignedFast(den, baseDomain.magic);
                denMod = baseDomain.modulus(den);
                ++denZeros;
            }
            if (denMod == 0L) continue;
            denominator = ring.multiply(denominator, ring == baseDomain ? denMod : ring.modulus(den));
        }
        if (numZeros > denZeros) {
            numerator = ring.multiply(numerator, ring.powMod(baseDomain.modulus, numZeros - denZeros));
        } else if (denZeros < numZeros) {
            denominator = ring.multiply(denominator, ring.powMod(baseDomain.modulus, denZeros - numZeros));
        }
        if (numerator == 0L) {
            return numerator;
        }
        return ring.divide(numerator, denominator);
    }

    @Override
    public MultivariatePolynomialZp64 seriesCoefficient(int variable, int order) {
        if (order == 0) {
            return this.clone();
        }
        if (this.isConstant()) {
            return this.createZero();
        }
        MonomialSet<MonomialZp64> newTerms = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (MonomialZp64 term : this) {
            int exponent = term.exponents[variable];
            if (exponent < order) continue;
            int[] newExponents = (int[])term.exponents.clone();
            int n = variable;
            newExponents[n] = newExponents[n] - order;
            long newCoefficient = this.ring.multiply(term.coefficient, MultivariatePolynomialZp64.seriesCoefficientFactor(exponent, order, this.ring));
            this.add(newTerms, new MonomialZp64(newExponents, term.totalDegree - order, newCoefficient));
        }
        return new MultivariatePolynomialZp64(this.nVariables, this.ring, this.ordering, newTerms);
    }

    public <T> MultivariatePolynomial<T> mapTerms(Ring<T> newRing, Function<MonomialZp64, Monomial<T>> mapper) {
        return (MultivariatePolynomial)this.terms.values().stream().map(mapper).collect(new AMultivariatePolynomial.PolynomialCollector(() -> MultivariatePolynomial.zero(this.nVariables, newRing, this.ordering)));
    }

    public MultivariatePolynomialZp64 mapTerms(IntegersZp64 newRing, Function<MonomialZp64, MonomialZp64> mapper) {
        return (MultivariatePolynomialZp64)this.terms.values().stream().map(mapper).collect(new AMultivariatePolynomial.PolynomialCollector(() -> MultivariatePolynomialZp64.zero(this.nVariables, newRing, this.ordering)));
    }

    public <T> MultivariatePolynomial<T> mapCoefficients(Ring<T> newRing, LongFunction<T> mapper) {
        return this.mapTerms(newRing, (MonomialZp64 t) -> new Monomial(t.exponents, t.totalDegree, mapper.apply(t.coefficient)));
    }

    @Override
    public <E> MultivariatePolynomial<E> mapCoefficientsAsPolys(Ring<E> ring, Function<MultivariatePolynomialZp64, E> mapper) {
        return this.mapCoefficients(ring, cf -> mapper.apply(this.createConstant(cf)));
    }

    @Override
    public int compareTo(MultivariatePolynomialZp64 oth) {
        int c = Integer.compare(this.size(), oth.size());
        if (c != 0) {
            return c;
        }
        Iterator thisIt = this.iterator();
        Iterator othIt = oth.iterator();
        while (thisIt.hasNext() && othIt.hasNext()) {
            MonomialZp64 b;
            MonomialZp64 a = (MonomialZp64)thisIt.next();
            c = this.ordering.compare(a, b = (MonomialZp64)othIt.next());
            if (c != 0) {
                return c;
            }
            c = Long.compare(a.coefficient, b.coefficient);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public MultivariatePolynomialZp64 clone() {
        return new MultivariatePolynomialZp64(this.nVariables, this.ring, this.ordering, (MonomialSet<MonomialZp64>)this.terms.clone());
    }

    @Override
    @Deprecated
    public MultivariatePolynomialZp64 parsePoly(String string) {
        MultivariatePolynomialZp64 r = MultivariatePolynomialZp64.parse(string, this.ring, this.ordering);
        if (r.nVariables != this.nVariables) {
            return MultivariatePolynomialZp64.parse(string, this.ring, this.ordering, IStringifier.defaultVars(this.nVariables));
        }
        return r;
    }

    @Override
    public String toString(IStringifier<MultivariatePolynomialZp64> stringifier) {
        if (this.isConstant()) {
            return Long.toString(this.cc());
        }
        String[] varStrings = new String[this.nVariables];
        for (int i = 0; i < this.nVariables; ++i) {
            varStrings[i] = stringifier.getBindings().getOrDefault(this.createMonomial(i, 1), IStringifier.defaultVar(i, this.nVariables));
        }
        StringBuilder sb = new StringBuilder();
        for (MonomialZp64 term : this.terms) {
            long cf = term.coefficient;
            String cfString = cf != 1L || term.totalDegree == 0 ? Long.toString(cf) : "";
            if (sb.length() != 0 && !cfString.startsWith("-")) {
                sb.append("+");
            }
            StringBuilder cfBuilder = new StringBuilder();
            cfBuilder.append(cfString);
            for (int i = 0; i < this.nVariables; ++i) {
                if (term.exponents[i] == 0) continue;
                if (cfBuilder.length() != 0) {
                    cfBuilder.append("*");
                }
                cfBuilder.append(varStrings[i]);
                if (term.exponents[i] <= 1) continue;
                cfBuilder.append("^").append(term.exponents[i]);
            }
            sb.append((CharSequence)cfBuilder);
        }
        return sb.toString();
    }

    @Override
    public String coefficientRingToString(IStringifier<MultivariatePolynomialZp64> stringifier) {
        return this.ring.toString();
    }

    public static final class lPrecomputedPowers {
        public final long value;
        public final IntegersZp64 ring;
        private final long[] precomputedPowers;

        public lPrecomputedPowers(long value, IntegersZp64 ring) {
            this(64, value, ring);
        }

        public lPrecomputedPowers(int cacheSize, long value, IntegersZp64 ring) {
            this.value = ring.modulus(value);
            this.ring = ring;
            this.precomputedPowers = new long[cacheSize + 1];
            Arrays.fill(this.precomputedPowers, -1L);
        }

        public long pow(int exponent) {
            if (exponent >= this.precomputedPowers.length) {
                return this.ring.powMod(this.value, exponent);
            }
            if (this.precomputedPowers[exponent] != -1L) {
                return this.precomputedPowers[exponent];
            }
            long result = 1L;
            long k2p = this.value;
            int rExp = 0;
            int kExp = 1;
            while (true) {
                if ((exponent & 1) != 0) {
                    this.precomputedPowers[rExp += kExp] = result = this.ring.multiply(result, k2p);
                }
                if ((exponent >>= 1) == 0) {
                    this.precomputedPowers[rExp] = result;
                    return this.precomputedPowers[rExp];
                }
                this.precomputedPowers[kExp *= 2] = k2p = this.ring.multiply(k2p, k2p);
            }
        }
    }

    public static final class lPrecomputedPowersHolder {
        final IntegersZp64 ring;
        final lPrecomputedPowers[] powers;

        public lPrecomputedPowersHolder(IntegersZp64 ring, lPrecomputedPowers[] powers) {
            this.ring = ring;
            this.powers = powers;
        }

        public void set(int i, long point) {
            if (this.powers[i] == null || this.powers[i].value != point) {
                this.powers[i] = new lPrecomputedPowers(this.powers[i] == null ? 64 : this.powers[i].precomputedPowers.length, point, this.ring);
            }
        }

        public long pow(int variable, int exponent) {
            return this.powers[variable].pow(exponent);
        }

        public lPrecomputedPowersHolder clone() {
            return new lPrecomputedPowersHolder(this.ring, (lPrecomputedPowers[])this.powers.clone());
        }
    }

    public static final class HornerFormZp64 {
        private final IntegersZp64 ring;
        private final int nEvalVariables;
        private final int[] evalDegrees;
        private final MultivariatePolynomial<AMultivariatePolynomial> recForm;

        private HornerFormZp64(IntegersZp64 ring, int[] evalDegrees, int nEvalVariables, MultivariatePolynomial<AMultivariatePolynomial> recForm) {
            this.ring = ring;
            this.evalDegrees = evalDegrees;
            this.nEvalVariables = nEvalVariables;
            this.recForm = recForm;
        }

        public MultivariatePolynomialZp64 evaluate(long[] values) {
            if (values.length != this.nEvalVariables) {
                throw new IllegalArgumentException();
            }
            lPrecomputedPowers[] pp = new lPrecomputedPowers[this.nEvalVariables];
            for (int i = 0; i < this.nEvalVariables; ++i) {
                pp[i] = new lPrecomputedPowers(Math.min(this.evalDegrees[i], 1014), values[i], this.ring);
            }
            return this.recForm.mapCoefficientsZp64(this.ring, p -> MultivariatePolynomialZp64.evaluateSparseRecursiveForm(p, new lPrecomputedPowersHolder(this.ring, pp), this.nEvalVariables - 1));
        }
    }

    static final class lUSubstitution
    implements lPrecomputedSubstitution {
        final int variable;
        final int nVariables;
        final Comparator<DegreeVector> ordering;
        final UnivariatePolynomialZp64 base;
        final TIntObjectHashMap<UnivariatePolynomialZp64> uCache = new TIntObjectHashMap();
        final TIntObjectHashMap<MultivariatePolynomialZp64> mCache = new TIntObjectHashMap();

        lUSubstitution(UnivariatePolynomialZp64 base, int variable, int nVariables, Comparator<DegreeVector> ordering) {
            this.nVariables = nVariables;
            this.variable = variable;
            this.ordering = ordering;
            this.base = base;
        }

        @Override
        public MultivariatePolynomialZp64 pow(int exponent) {
            MultivariatePolynomialZp64 cached = this.mCache.get(exponent);
            if (cached != null) {
                return cached.clone();
            }
            UnivariatePolynomialZp64 r = PolynomialMethods.polyPow(this.base, exponent, true, this.uCache);
            cached = MultivariatePolynomialZp64.asMultivariate(r, this.nVariables, this.variable, this.ordering);
            this.mCache.put(exponent, cached);
            return cached.clone();
        }
    }

    static final class lMSubstitution
    implements lPrecomputedSubstitution {
        final MultivariatePolynomialZp64 base;
        final TIntObjectHashMap<MultivariatePolynomialZp64> cache = new TIntObjectHashMap();

        lMSubstitution(MultivariatePolynomialZp64 base) {
            this.base = base;
        }

        @Override
        public MultivariatePolynomialZp64 pow(int exponent) {
            return PolynomialMethods.polyPow(this.base, exponent, true, this.cache);
        }
    }

    static interface lPrecomputedSubstitution {
        public MultivariatePolynomialZp64 pow(int var1);
    }

    static final class lPrecomputedSubstitutions {
        final lPrecomputedSubstitution[] subs;

        public lPrecomputedSubstitutions(lPrecomputedSubstitution[] subs) {
            this.subs = subs;
        }

        MultivariatePolynomialZp64 getSubstitutionPower(int var, int exponent) {
            if (this.subs[var] == null) {
                throw new IllegalArgumentException();
            }
            return this.subs[var].pow(exponent);
        }
    }

    static final class CfHolder {
        long coefficient = 0L;

        CfHolder(long coefficient) {
            this.coefficient = coefficient;
        }
    }
}

