/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.util.RandomUtil;
import java.util.Comparator;
import java.util.function.Function;
import org.apache.commons.math3.random.RandomGenerator;

public final class RandomMultivariatePolynomials {
    private RandomMultivariatePolynomials() {
    }

    public static MultivariatePolynomial<BigInteger> randomPolynomial(int nVars, int degree, int size, BigInteger bound, Comparator<DegreeVector> ordering, RandomGenerator rnd) {
        int nd = 3 * degree / 2;
        Monomial[] terms = new Monomial[size];
        for (int i = 0; i < size; ++i) {
            BigInteger cfx = RandomUtil.randomInt(bound, rnd);
            if (rnd.nextBoolean() && rnd.nextBoolean()) {
                cfx = cfx.negate();
            }
            int[] exponents = RandomUtil.randomIntArray(nVars, 0, nd, rnd);
            terms[i] = new Monomial<BigInteger>(exponents, cfx);
        }
        return MultivariatePolynomial.create(nVars, Rings.Z, ordering, terms);
    }

    public static MultivariatePolynomial<BigInteger> randomPolynomial(int nVars, int degree, int size, RandomGenerator rnd) {
        return RandomMultivariatePolynomials.randomPolynomial(nVars, degree, size, BigInteger.TEN, MonomialOrder.DEFAULT, rnd);
    }

    public static <E> MultivariatePolynomial<E> randomPolynomial(int nVars, int degree, int size, Ring<E> ring, Comparator<DegreeVector> ordering, Function<RandomGenerator, E> method, RandomGenerator rnd) {
        int nd = 3 * degree / 2;
        Monomial[] terms = new Monomial[size];
        for (int i = 0; i < size; ++i) {
            E cfx = method.apply(rnd);
            int[] exponents = RandomUtil.randomIntArray(nVars, 0, nd, rnd);
            terms[i] = new Monomial<E>(exponents, cfx);
        }
        return MultivariatePolynomial.create(nVars, ring, ordering, terms);
    }

    public static <E> MultivariatePolynomial<E> randomPolynomial(int nVars, int minDegree, int maxDegree, int size, Ring<E> ring, Comparator<DegreeVector> ordering, Function<RandomGenerator, E> method, RandomGenerator rnd) {
        Monomial[] terms = new Monomial[size];
        for (int i = 0; i < size; ++i) {
            E cfx = method.apply(rnd);
            int[] exponents = RandomUtil.randomIntArray(nVars, minDegree, maxDegree, rnd);
            terms[i] = new Monomial<E>(exponents, cfx);
        }
        return MultivariatePolynomial.create(nVars, ring, ordering, terms);
    }

    public static <E> MultivariatePolynomial<E> randomPolynomial(int nVars, int degree, int size, Ring<E> ring, Comparator<DegreeVector> ordering, RandomGenerator rnd) {
        return RandomMultivariatePolynomials.randomPolynomial(nVars, degree, size, ring, ordering, ring::randomElement, rnd);
    }

    public static MultivariatePolynomialZp64 randomPolynomial(int nVars, int degree, int size, IntegersZp64 ring, RandomGenerator rnd) {
        return RandomMultivariatePolynomials.randomPolynomial(nVars, degree, size, ring, MonomialOrder.DEFAULT, rnd);
    }

    public static MultivariatePolynomialZp64 randomPolynomial(int nVars, int degree, int size, IntegersZp64 ring, Comparator<DegreeVector> ordering, RandomGenerator rnd) {
        int nd = 3 * degree / 2;
        MonomialZp64[] terms = new MonomialZp64[size];
        for (int i = 0; i < size; ++i) {
            long cfx = ring.randomElement(rnd);
            int[] exponents = RandomUtil.randomIntArray(nVars, 0, nd, rnd);
            terms[i] = new MonomialZp64(exponents, cfx);
        }
        return MultivariatePolynomialZp64.create(nVars, ring, ordering, terms);
    }

    public static MultivariatePolynomialZp64 randomSharpPolynomial(int nVars, int degree, int size, IntegersZp64 ring, Comparator<DegreeVector> ordering, RandomGenerator rnd) {
        MonomialZp64[] terms = new MonomialZp64[size];
        for (int i = 0; i < size; ++i) {
            long cfx = ring.randomElement(rnd);
            int[] exponents = RandomUtil.randomSharpIntArray(nVars, degree, rnd);
            terms[i] = new MonomialZp64(exponents, cfx);
        }
        return MultivariatePolynomialZp64.create(nVars, ring, ordering, terms);
    }

    public static <E> MultivariatePolynomial<E> randomSharpPolynomial(int nVars, int degree, int size, Ring<E> ring, Comparator<DegreeVector> ordering, Function<RandomGenerator, E> rndCoefficients, RandomGenerator rnd) {
        Monomial[] terms = new Monomial[size];
        for (int i = 0; i < size; ++i) {
            E cfx = rndCoefficients.apply(rnd);
            int[] exponents = RandomUtil.randomSharpIntArray(nVars, degree, rnd);
            terms[i] = new Monomial<E>(exponents, cfx);
        }
        return MultivariatePolynomial.create(nVars, ring, ordering, terms);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly randomPolynomial(Poly factory, int degree, int size, RandomGenerator rnd) {
        if (factory instanceof MultivariatePolynomialZp64) {
            return (Poly)RandomMultivariatePolynomials.randomPolynomial(((MultivariatePolynomialZp64)factory).nVariables, degree, size, ((MultivariatePolynomialZp64)factory).ring, (Comparator<DegreeVector>)((MultivariatePolynomialZp64)factory).ordering, rnd);
        }
        return (Poly)RandomMultivariatePolynomials.randomPolynomial(((MultivariatePolynomial)factory).nVariables, degree, size, ((MultivariatePolynomial)factory).ring, (Comparator<DegreeVector>)((MultivariatePolynomial)factory).ordering, rnd);
    }
}

