/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.Ring;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Stream;

public interface IUnivariatePolynomial<Poly extends IUnivariatePolynomial<Poly>>
extends IPolynomial<Poly> {
    @Override
    default public int size() {
        return this.degree() + 1;
    }

    default public int nNonZeroTerms() {
        int c = 0;
        for (int i = this.degree(); i >= 0; --i) {
            if (this.isZeroAt(i)) continue;
            ++c;
        }
        return c;
    }

    public boolean isZeroAt(int var1);

    @Override
    default public boolean isZeroCC() {
        return this.isZeroAt(0);
    }

    public Poly setZero(int var1);

    public Poly setFrom(int var1, Poly var2, int var3);

    public Poly getAsPoly(int var1);

    default public TIntHashSet exponents() {
        TIntHashSet degrees = new TIntHashSet();
        for (int i = this.degree(); i >= 0; --i) {
            if (this.isZeroAt(i)) continue;
            degrees.add(i);
        }
        return degrees;
    }

    public int firstNonZeroCoefficientPosition();

    public Poly shiftLeft(int var1);

    public Poly shiftRight(int var1);

    public Poly truncate(int var1);

    public Poly getRange(int var1, int var2);

    public Poly reverse();

    public Poly createMonomial(int var1);

    public Poly derivative();

    @Override
    public Poly clone();

    public Poly setAndDestroy(Poly var1);

    public Poly composition(Poly var1);

    default public Poly composition(Ring<Poly> ring, Poly value) {
        if (value.isOne()) {
            return (Poly)((IUnivariatePolynomial)ring.valueOf(this.clone()));
        }
        if (value.isZero()) {
            return (Poly)((IUnivariatePolynomial)this.ccAsPoly());
        }
        IUnivariatePolynomial result = (IUnivariatePolynomial)ring.getZero();
        for (int i = this.degree(); i >= 0; --i) {
            result = ring.add((Poly)ring.multiply((Poly)result, value), this.getAsPoly(i));
        }
        return (Poly)result;
    }

    public Stream<Poly> streamAsPolys();

    default public <E> UnivariatePolynomial<E> mapCoefficientsAsPolys(Ring<E> ring, Function<Poly, E> mapper) {
        return (UnivariatePolynomial)this.streamAsPolys().map(mapper).collect(new UnivariatePolynomial.PolynomialCollector<E>(ring));
    }

    public AMultivariatePolynomial composition(AMultivariatePolynomial var1);

    public AMultivariatePolynomial asMultivariate(Comparator<DegreeVector> var1);

    default public AMultivariatePolynomial asMultivariate() {
        return this.asMultivariate(MonomialOrder.DEFAULT);
    }

    public void ensureInternalCapacity(int var1);

    @Override
    default public boolean isLinearOrConstant() {
        return this.degree() <= 1;
    }

    @Override
    default public boolean isLinearExactly() {
        return this.degree() == 1;
    }
}

