/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZ64;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.util.RandomUtil;
import java.util.function.Function;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;

public final class RandomUnivariatePolynomials {
    private static final int DEFAULT_BOUND = 100;

    private RandomUnivariatePolynomials() {
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly randomPoly(Poly factory, int degree, RandomGenerator rnd) {
        if (factory instanceof UnivariatePolynomialZ64) {
            return (Poly)RandomUnivariatePolynomials.randomPoly(degree, rnd);
        }
        if (factory instanceof UnivariatePolynomialZp64) {
            return (Poly)RandomUnivariatePolynomials.randomMonicPoly(degree, ((UnivariatePolynomialZp64)factory).modulus(), rnd);
        }
        if (factory instanceof UnivariatePolynomial) {
            IPolynomial p = RandomUnivariatePolynomials.randomPoly(degree, ((UnivariatePolynomial)factory).ring, rnd);
            if (factory.isOverField()) {
                p = p.monic();
            }
            return (Poly)p;
        }
        throw new RuntimeException(factory.getClass().toString());
    }

    public static UnivariatePolynomialZ64 randomPoly(int degree, RandomGenerator rnd) {
        return RandomUnivariatePolynomials.randomPoly(degree, 100L, rnd);
    }

    public static UnivariatePolynomialZp64 randomMonicPoly(int degree, long modulus, RandomGenerator rnd) {
        UnivariatePolynomialZ64 r = RandomUnivariatePolynomials.randomPoly(degree, modulus, rnd);
        while (r.data[degree] % modulus == 0L) {
            r.data[r.degree] = rnd.nextLong();
        }
        return r.modulus(modulus, false).monic();
    }

    public static UnivariatePolynomial<BigInteger> randomMonicPoly(int degree, BigInteger modulus, RandomGenerator rnd) {
        UnivariatePolynomial<BigInteger> r = RandomUnivariatePolynomials.randomPoly(degree, modulus, rnd);
        while (((BigInteger[])r.data)[degree].mod(modulus).isZero()) {
            ((BigInteger[])r.data)[r.degree] = RandomUtil.randomInt(modulus, rnd);
        }
        return r.setRing(new IntegersZp(modulus)).monic();
    }

    public static <E> UnivariatePolynomial<E> randomMonicPoly(int degree, Ring<E> ring, RandomGenerator rnd) {
        return RandomUnivariatePolynomials.randomPoly(degree, ring, rnd).monic();
    }

    public static UnivariatePolynomialZ64 randomPoly(int degree, long bound, RandomGenerator rnd) {
        return UnivariatePolynomialZ64.create(RandomUnivariatePolynomials.randomLongArray(degree, bound, rnd));
    }

    public static UnivariatePolynomial<BigInteger> randomPoly(int degree, BigInteger bound, RandomGenerator rnd) {
        return UnivariatePolynomial.createUnsafe(Rings.Z, RandomUnivariatePolynomials.randomBigArray(degree, bound, rnd));
    }

    public static <E> UnivariatePolynomial<E> randomPoly(int degree, Ring<E> ring, RandomGenerator rnd) {
        return UnivariatePolynomial.createUnsafe(ring, RandomUnivariatePolynomials.randomArray(degree, ring, rnd));
    }

    public static <E> UnivariatePolynomial<E> randomPoly(int degree, Ring<E> ring, Function<RandomGenerator, E> method, RandomGenerator rnd) {
        return UnivariatePolynomial.createUnsafe(ring, RandomUnivariatePolynomials.randomArray(degree, ring, method, rnd));
    }

    public static long[] randomLongArray(int degree, long bound, RandomGenerator rnd) {
        long[] data = new long[degree + 1];
        RandomDataGenerator rndd = new RandomDataGenerator(rnd);
        for (int i = 0; i <= degree; ++i) {
            data[i] = rndd.nextLong(0L, bound - 1L);
            if (!rnd.nextBoolean() || !rnd.nextBoolean()) continue;
            data[i] = -data[i];
        }
        while (data[degree] == 0L) {
            data[degree] = rndd.nextLong(0L, bound - 1L);
        }
        return data;
    }

    public static BigInteger[] randomBigArray(int degree, BigInteger bound, RandomGenerator rnd) {
        long lBound = bound.isLong() ? bound.longValue() : Long.MAX_VALUE;
        RandomDataGenerator rndd = new RandomDataGenerator(rnd);
        BigInteger[] data = new BigInteger[degree + 1];
        for (int i = 0; i <= degree; ++i) {
            data[i] = RandomUtil.randomInt(bound, rnd);
            if (!rnd.nextBoolean() || !rnd.nextBoolean()) continue;
            data[i] = data[i].negate();
        }
        while (data[degree].equals(BigInteger.ZERO)) {
            data[degree] = BigInteger.valueOf(rndd.nextLong(0L, lBound));
        }
        return data;
    }

    public static <E> E[] randomArray(int degree, Ring<E> ring, RandomGenerator rnd) {
        return RandomUnivariatePolynomials.randomArray(degree, ring, ring::randomElement, rnd);
    }

    public static <E> E[] randomArray(int degree, Ring<E> ring, Function<RandomGenerator, E> method, RandomGenerator rnd) {
        int[] data = ring.createArray(degree + 1);
        for (int i = 0; i <= degree; ++i) {
            data[i] = (int)method.apply(rnd);
        }
        while (ring.isZero(data[degree])) {
            data[degree] = (int)method.apply(rnd);
        }
        return data;
    }
}

