/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.libdivide4j.FastDivision;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.univar.AUnivariatePolynomial64;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import java.util.Arrays;
import java.util.Comparator;

public final class UnivariatePolynomialZ64
extends AUnivariatePolynomial64<UnivariatePolynomialZ64> {
    private static final long serialVersionUID = 1L;

    private UnivariatePolynomialZ64(long[] data) {
        this.data = data;
        this.degree = data.length - 1;
        this.fixDegree();
        assert (data.length > 0);
    }

    private UnivariatePolynomialZ64(long[] data, int degree) {
        this.data = data;
        this.degree = degree;
        assert (data.length > 0);
    }

    public static UnivariatePolynomialZ64 parse(String string) {
        return UnivariatePolynomial.asOverZ64(UnivariatePolynomial.parse(string, Rings.Z));
    }

    public static UnivariatePolynomialZ64 create(long ... data) {
        return new UnivariatePolynomialZ64(data);
    }

    public static UnivariatePolynomialZ64 monomial(long coefficient, int exponent) {
        long[] data = new long[exponent + 1];
        data[exponent] = coefficient;
        return new UnivariatePolynomialZ64(data);
    }

    public static UnivariatePolynomialZ64 zero() {
        return new UnivariatePolynomialZ64(new long[]{0L}, 0);
    }

    public static UnivariatePolynomialZ64 one() {
        return new UnivariatePolynomialZ64(new long[]{1L}, 0);
    }

    public static UnivariatePolynomialZ64 constant(long value) {
        return new UnivariatePolynomialZ64(new long[]{value}, 0);
    }

    @Override
    public UnivariatePolynomialZ64 setCoefficientRingFrom(UnivariatePolynomialZ64 univariatePolynomialZ64) {
        return univariatePolynomialZ64.clone();
    }

    public UnivariatePolynomialZp64 modulus(long modulus, boolean copy) {
        return UnivariatePolynomialZp64.create(modulus, copy ? (long[])this.data.clone() : this.data);
    }

    public UnivariatePolynomialZp64 modulus(long modulus) {
        return this.modulus(modulus, true);
    }

    public UnivariatePolynomialZp64 modulus(IntegersZp64 ring, boolean copy) {
        long[] data = copy ? (long[])this.data.clone() : this.data;
        for (int i = this.degree; i >= 0; --i) {
            data[i] = ring.modulus(data[i]);
        }
        return UnivariatePolynomialZp64.createUnsafe(ring, data);
    }

    public UnivariatePolynomialZp64 modulus(IntegersZp64 ring) {
        return this.modulus(ring, true);
    }

    UnivariatePolynomialZp64 modulusUnsafe(long modulus) {
        return UnivariatePolynomialZp64.createUnsafe(modulus, this.data);
    }

    @Override
    public UnivariatePolynomial<BigInteger> toBigPoly() {
        return UnivariatePolynomial.createUnsafe(Rings.Z, this.dataToBigIntegers());
    }

    public double mignotteBound() {
        return Math.pow(2.0, this.degree) * this.norm2();
    }

    public long evaluateAtRational(long num, long den) {
        if (num == 0L) {
            return this.cc();
        }
        long res = 0L;
        FastDivision.Magic magic = FastDivision.magicSigned(den);
        for (int i = this.degree; i >= 0; --i) {
            long x = this.multiply(res, num);
            long q = FastDivision.divideSignedFast(x, magic);
            if (q * den != x) {
                throw new IllegalArgumentException("The answer is not integer");
            }
            res = this.add(q, this.data[i]);
        }
        return res;
    }

    @Override
    public UnivariatePolynomialZ64 getRange(int from, int to) {
        return new UnivariatePolynomialZ64(Arrays.copyOfRange(this.data, from, to));
    }

    public UnivariatePolynomialZ64[] createArray(int length) {
        return new UnivariatePolynomialZ64[length];
    }

    public UnivariatePolynomialZ64[][] createArray2d(int length) {
        return new UnivariatePolynomialZ64[length][];
    }

    public UnivariatePolynomialZ64[][] createArray2d(int length1, int length2) {
        return new UnivariatePolynomialZ64[length1][length2];
    }

    @Override
    public boolean sameCoefficientRingWith(UnivariatePolynomialZ64 oth) {
        return true;
    }

    @Override
    public UnivariatePolynomialZ64 createFromArray(long[] data) {
        return new UnivariatePolynomialZ64(data);
    }

    @Override
    public UnivariatePolynomialZ64 createMonomial(long coefficient, int degree) {
        return UnivariatePolynomialZ64.monomial(coefficient, degree);
    }

    @Override
    public boolean isOverField() {
        return false;
    }

    @Override
    public boolean isOverFiniteField() {
        return false;
    }

    @Override
    public boolean isOverZ() {
        return true;
    }

    @Override
    public BigInteger coefficientRingCardinality() {
        return null;
    }

    @Override
    public BigInteger coefficientRingCharacteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public boolean isOverPerfectPower() {
        return false;
    }

    @Override
    public BigInteger coefficientRingPerfectPowerBase() {
        return null;
    }

    @Override
    public BigInteger coefficientRingPerfectPowerExponent() {
        return null;
    }

    @Override
    public long content() {
        if (this.degree == 0) {
            return this.data[0];
        }
        return MachineArithmetic.gcd(this.data, 0, this.degree + 1);
    }

    @Override
    long add(long a, long b) {
        return MachineArithmetic.safeAdd(a, b);
    }

    @Override
    long subtract(long a, long b) {
        return MachineArithmetic.safeSubtract(a, b);
    }

    @Override
    long multiply(long a, long b) {
        return MachineArithmetic.safeMultiply(a, b);
    }

    @Override
    long negate(long a) {
        return MachineArithmetic.safeNegate(a);
    }

    @Override
    long valueOf(long a) {
        return a;
    }

    @Override
    public UnivariatePolynomialZ64 monic() {
        if (this.isZero()) {
            return this;
        }
        return this.divideOrNull(this.lc());
    }

    @Override
    public UnivariatePolynomialZ64 monic(long factor) {
        long lc = this.lc();
        long gcd = MachineArithmetic.gcd(lc, factor);
        factor /= gcd;
        UnivariatePolynomialZ64 r = this.divideOrNull(lc /= gcd);
        if (r == null) {
            return null;
        }
        return (UnivariatePolynomialZ64)r.multiply(factor);
    }

    public UnivariatePolynomialZ64 divideOrNull(long factor) {
        if (factor == 0L) {
            throw new ArithmeticException("Divide by zero");
        }
        if (factor == 1L) {
            return this;
        }
        FastDivision.Magic magic = FastDivision.magicSigned(factor);
        for (int i = this.degree; i >= 0; --i) {
            long l = FastDivision.divideSignedFast(this.data[i], magic);
            if (l * factor != this.data[i]) {
                return null;
            }
            this.data[i] = l;
        }
        return this;
    }

    @Override
    public UnivariatePolynomialZ64 divideByLC(UnivariatePolynomialZ64 other) {
        return this.divideOrNull(other.lc());
    }

    @Override
    public UnivariatePolynomialZ64 multiplyByBigInteger(BigInteger factor) {
        return (UnivariatePolynomialZ64)this.multiply(factor.longValueExact());
    }

    UnivariatePolynomialZ64 multiplyUnsafe(long factor) {
        int i = this.degree;
        while (i >= 0) {
            int n = i--;
            this.data[n] = this.data[n] * factor;
        }
        return this;
    }

    @Override
    public UnivariatePolynomialZ64 multiply(UnivariatePolynomialZ64 oth) {
        if (this.isZero()) {
            return this;
        }
        if (oth.isZero()) {
            return (UnivariatePolynomialZ64)this.toZero();
        }
        if (this == oth) {
            return this.square();
        }
        if (oth.degree == 0) {
            return (UnivariatePolynomialZ64)this.multiply(oth.data[0]);
        }
        if (this.degree == 0) {
            long factor = this.data[0];
            this.data = (long[])oth.data.clone();
            this.degree = oth.degree;
            return (UnivariatePolynomialZ64)this.multiply(factor);
        }
        double rBound = this.normMax() * oth.normMax() * (double)Math.max(this.degree + 1, oth.degree + 1);
        this.data = rBound < 9.223372036854776E18 ? this.multiplyUnsafe0(oth) : this.multiplySafe0(oth);
        this.degree += oth.degree;
        this.fixDegree();
        return this;
    }

    UnivariatePolynomialZ64 multiplyUnsafe(UnivariatePolynomialZ64 oth) {
        if (this.isZero()) {
            return this;
        }
        if (oth.isZero()) {
            return (UnivariatePolynomialZ64)this.toZero();
        }
        if (this == oth) {
            return this.square();
        }
        if (oth.degree == 0) {
            return (UnivariatePolynomialZ64)this.multiply(oth.data[0]);
        }
        if (this.degree == 0) {
            long factor = this.data[0];
            this.data = (long[])oth.data.clone();
            this.degree = oth.degree;
            return this.multiplyUnsafe(factor);
        }
        this.data = this.multiplyUnsafe0(oth);
        this.degree += oth.degree;
        this.fixDegree();
        return this;
    }

    @Override
    public UnivariatePolynomialZ64 square() {
        if (this.isZero()) {
            return this;
        }
        if (this.degree == 0) {
            return (UnivariatePolynomialZ64)this.multiply(this.data[0]);
        }
        double norm1 = this.normMax();
        double rBound = norm1 * norm1 * (double)(this.degree + 1);
        this.data = rBound < 9.223372036854776E18 ? this.squareUnsafe0() : this.squareSafe0();
        this.degree += this.degree;
        this.fixDegree();
        return this;
    }

    @Override
    public UnivariatePolynomialZ64 derivative() {
        if (this.isConstant()) {
            return (UnivariatePolynomialZ64)this.createZero();
        }
        long[] newData = new long[this.degree];
        for (int i = this.degree; i > 0; --i) {
            newData[i - 1] = this.multiply(this.data[i], i);
        }
        return this.createFromArray(newData);
    }

    @Override
    public UnivariatePolynomialZ64 clone() {
        return new UnivariatePolynomialZ64((long[])this.data.clone(), this.degree);
    }

    @Override
    public UnivariatePolynomialZ64 parsePoly(String string) {
        return UnivariatePolynomialZ64.parse(string);
    }

    @Override
    public String coefficientRingToString(IStringifier<UnivariatePolynomialZ64> stringifier) {
        return "Z";
    }

    @Override
    public AMultivariatePolynomial composition(AMultivariatePolynomial value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AMultivariatePolynomial asMultivariate(Comparator<DegreeVector> ordering) {
        throw new UnsupportedOperationException();
    }
}

