/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.primes;

import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.primes.BigPrimes;
import cc.redberry.rings.primes.SieveOfAtkin;
import cc.redberry.rings.primes.SmallPrimes;
import java.util.Arrays;

public final class PrimesIterator {
    private final int[] smallPrimes = SmallPrimes.SmallPrimes12;
    private long pointer;
    private int smallPrimesPointer = Integer.MAX_VALUE;
    private static final int largeSieveLimit = 0x1000000;
    private final SieveOfAtkin smallSieve = SieveOfAtkin.SmallPrimesSieve;
    private SieveOfAtkin largeSieve = null;

    public PrimesIterator() {
        this.pointer = 0L;
    }

    public PrimesIterator(long from) {
        if (from < (long)this.smallPrimes[this.smallPrimes.length - 1]) {
            this.smallPrimesPointer = Arrays.binarySearch(this.smallPrimes, (int)from);
            if (this.smallPrimesPointer < 0) {
                this.smallPrimesPointer ^= 0xFFFFFFFF;
            }
            this.pointer = this.smallPrimes[this.smallPrimesPointer];
        } else {
            this.pointer = from;
        }
    }

    public long take() {
        if (this.smallPrimesPointer < this.smallPrimes.length) {
            this.pointer = this.smallPrimes[this.smallPrimesPointer++] + 1;
            return this.pointer - 1L;
        }
        while (this.pointer < (long)this.smallSieve.getLimit()) {
            if (!this.smallSieve.isPrime((int)this.pointer++)) continue;
            return this.pointer - 1L;
        }
        if (this.pointer < 0x1000000L) {
            if (this.largeSieve == null) {
                this.largeSieve = SieveOfAtkin.createSieve(0x1000000);
            }
            while (this.pointer < (long)this.largeSieve.getLimit()) {
                if (!this.largeSieve.isPrime((int)this.pointer++)) continue;
                return this.pointer - 1L;
            }
        }
        if (this.pointer < 0x7FFFFFFEL) {
            this.pointer = SmallPrimes.nextPrime((int)(this.pointer + 1L));
            return this.pointer;
        }
        if (this.pointer < 0x7FFFFFFFFFFFFFFEL) {
            try {
                this.pointer = BigPrimes.nextPrime(BigInteger.valueOf(this.pointer + 1L)).longValueExact();
                return this.pointer;
            }
            catch (ArithmeticException e) {
                return -1L;
            }
        }
        return -1L;
    }
}

