/*
 * Decompiled with CFR 0.152.
 */
package com.github.tueda.donuts;

import com.github.tueda.donuts.Multivariate;
import com.github.tueda.donuts.VariableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;

public final class Variable
implements Comparable<Variable>,
Serializable,
Multivariate {
    private static final long serialVersionUID = 1L;
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9]*");
    static final Comparator<String> NAME_COMPARATOR = new NameComparator();
    private final String name;

    public Variable(String name) {
        this(name, true);
    }

    private Variable(String name, boolean check) {
        if (check && !Variable.isVariableName(name)) {
            throw new IllegalArgumentException(String.format("illegal variable name: \"%s\"", name));
        }
        this.name = name;
    }

    static Variable createWithoutCheck(String name) {
        return new Variable(name, false);
    }

    public static Variable of(String name) {
        return new Variable(name);
    }

    public static Variable[] of(String ... names) {
        return (Variable[])Stream.of(names).map(Variable::new).toArray(Variable[]::new);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Variable)) {
            return false;
        }
        Variable aVariable = (Variable)other;
        return this.name.equals(aVariable.name);
    }

    @Override
    public int compareTo(Variable other) {
        if (this == other) {
            return 0;
        }
        return NAME_COMPARATOR.compare(this.name, other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public VariableSet getVariables() {
        return new VariableSet(this);
    }

    public String getName() {
        return this.name;
    }

    public static boolean isVariableName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String[] guessVariableNames(String string) {
        Matcher matcher = IDENTIFIER_PATTERN.matcher(string);
        HashSet<String> seen = new HashSet<String>();
        while (matcher.find()) {
            seen.add(matcher.group());
        }
        Stream stream = StreamSupport.stream(seen.spliterator(), false);
        return (String[])stream.sorted(NAME_COMPARATOR).toArray(String[]::new);
    }

    static class NameComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        NameComparator() {
        }

        @Override
        @SuppressFBWarnings(justification="Intend to compare two references", value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
        public int compare(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            int len1 = s1.length();
            int len2 = s2.length();
            int limit = Math.min(len1, len2);
            int i = 0;
            while (i < limit) {
                char c1 = s1.charAt(i);
                char c2 = s2.charAt(i);
                if (Character.isDigit(c1) && Character.isDigit(c2)) {
                    int result = NameComparator.compareNumbers(s1, s2, i);
                    if (result != 0) {
                        return result;
                    }
                    i = NameComparator.skipDigits(s1, i);
                    continue;
                }
                if (c1 != c2) {
                    return c1 - c2;
                }
                ++i;
            }
            return len1 - len2;
        }

        private static int compareNumbers(String s1, String s2, int first) {
            int k2;
            int j1 = NameComparator.skipZeros(s1, first);
            int j2 = NameComparator.skipZeros(s2, first);
            int k1 = NameComparator.skipDigits(s1, j1);
            if (k1 - j1 != (k2 = NameComparator.skipDigits(s2, j2)) - j2) {
                return k1 - j1 - (k2 - j2);
            }
            int len = k1 - j1;
            for (int j = 0; j < len; ++j) {
                char c2;
                char c1 = s1.charAt(j1 + j);
                if (c1 == (c2 = s2.charAt(j2 + j))) continue;
                return c1 - c2;
            }
            if (k1 != k2) {
                if (j1 == k1) {
                    return k1 - k2;
                }
                return k2 - k1;
            }
            return 0;
        }

        private static int skipZeros(String s, int first) {
            int i;
            for (i = first; i < s.length() && s.charAt(i) == '0'; ++i) {
            }
            return i;
        }

        private static int skipDigits(String s, int first) {
            int i;
            for (i = first; i < s.length() && Character.isDigit(s.charAt(i)); ++i) {
            }
            return i;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameComparator)) {
                return false;
            }
            NameComparator other = (NameComparator)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NameComparator;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }
}

