/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.rings.FactorDecomposition;
import cc.redberry.rings.Rational;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.IStringifier;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.math3.random.RandomGenerator;

public final class Rationals<E>
implements Ring<Rational<E>> {
    private static final long serialVersionUID = 1L;
    public final Ring<E> ring;

    public Rationals(Ring<E> ring) {
        this.ring = ring;
    }

    public Rational<E> mkNumerator(E num) {
        return new Rational<E>(this.ring, num);
    }

    public Rational<E> mkNumerator(long num) {
        return this.mkNumerator((E)this.ring.valueOf(num));
    }

    public Rational<E> mkDenominator(E den) {
        return new Rational<E>(this.ring, this.ring.getOne(), den);
    }

    public Rational<E> mkDenominator(long den) {
        return this.mkDenominator((E)this.ring.valueOf(den));
    }

    public Rational<E> mk(E num, E den) {
        return new Rational<E>(this.ring, num, den);
    }

    public Rational<E> mk(long num, long den) {
        return new Rational<long>(this.ring, this.ring.valueOf(num), this.ring.valueOf(den));
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public boolean isEuclideanRing() {
        return true;
    }

    @Override
    public BigInteger cardinality() {
        return null;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public boolean isPerfectPower() {
        return false;
    }

    @Override
    public BigInteger perfectPowerBase() {
        return null;
    }

    @Override
    public BigInteger perfectPowerExponent() {
        return null;
    }

    @Override
    public Rational<E> add(Rational<E> a, Rational<E> b) {
        return a.add(b);
    }

    @Override
    public Rational<E> subtract(Rational<E> a, Rational<E> b) {
        return a.subtract(b);
    }

    @Override
    public Rational<E> multiply(Rational<E> a, Rational<E> b) {
        return a.multiply(b);
    }

    @Override
    public Rational<E> negate(Rational<E> element) {
        return element.negate();
    }

    @Override
    public int signum(Rational<E> element) {
        return element.signum();
    }

    public Rational<E>[] divideAndRemainder(Rational<E> dividend, Rational<E> divider) {
        return new Rational[]{dividend.divide(divider), Rational.zero(this.ring)};
    }

    @Override
    public Rational<E> reciprocal(Rational<E> element) {
        return element.reciprocal();
    }

    @Override
    public Rational<E> gcd(Rational<E> a, Rational<E> b) {
        return Rational.one(this.ring);
    }

    private FactorDecomposition<Rational<E>> factor(Rational<E> element, Function<E, FactorDecomposition<E>> factor) {
        if (element.isZero()) {
            return FactorDecomposition.of(this, element);
        }
        FactorDecomposition<E> numFactors = element.numerator.stream().map(factor).reduce(FactorDecomposition.empty(this.ring), FactorDecomposition::addAll);
        FactorDecomposition<Rational<Rational<E>>> factors = FactorDecomposition.empty(this);
        for (int i = 0; i < numFactors.size(); ++i) {
            factors.addNonUnitFactor(new Rational<E>(this.ring, numFactors.get(i)), numFactors.getExponent(i));
        }
        factors.addFactor(new Rational<E>(this.ring, numFactors.unit), 1);
        FactorDecomposition<E> denFactors = element.denominator.stream().map(factor).reduce(FactorDecomposition.empty(this.ring), FactorDecomposition::addAll);
        for (int i = 0; i < denFactors.size(); ++i) {
            factors.addNonUnitFactor(new Rational<E>(this.ring, this.ring.getOne(), denFactors.get(i)), denFactors.getExponent(i));
        }
        factors.addFactor(new Rational<E>(this.ring, this.ring.getOne(), denFactors.unit), 1);
        return factors;
    }

    @Override
    public FactorDecomposition<Rational<E>> factorSquareFree(Rational<E> element) {
        return this.factor(element, this.ring::factorSquareFree);
    }

    @Override
    public FactorDecomposition<Rational<E>> factor(Rational<E> element) {
        return this.factor(element, this.ring::factor);
    }

    @Override
    public Rational<E> getZero() {
        return Rational.zero(this.ring);
    }

    @Override
    public Rational<E> getOne() {
        return Rational.one(this.ring);
    }

    @Override
    public boolean isZero(Rational<E> element) {
        return element.isZero();
    }

    @Override
    public boolean isOne(Rational<E> element) {
        return element.isOne();
    }

    @Override
    public boolean isUnit(Rational<E> element) {
        return !this.isZero(element);
    }

    @Override
    public Rational<E> valueOf(long val) {
        return new Rational<long>(this.ring, this.ring.valueOf(val));
    }

    @Override
    public Rational<E> valueOfBigInteger(BigInteger val) {
        return new Rational<E>(this.ring, this.ring.valueOfBigInteger(val));
    }

    @Override
    public Rational<E> copy(Rational<E> element) {
        return new Rational<E>(true, this.ring, element.numerator.deepCopy(), element.denominator.deepCopy());
    }

    @Override
    public Rational<E> valueOf(Rational<E> val) {
        if (val.ring.equals(this.ring)) {
            return val;
        }
        return new Rational<E>(this.ring, val.numerator.map(this.ring::valueOf), val.denominator.map(this.ring::valueOf));
    }

    public Rational<E>[][] createArray2d(int length) {
        return new Rational[length][];
    }

    public Rational<E>[][] createArray2d(int m, int n) {
        return new Rational[m][n];
    }

    @Override
    public int compare(Rational<E> o1, Rational<E> o2) {
        return o1.compareTo(o2);
    }

    @Override
    public Rational<E> getNegativeOne() {
        return Rational.one(this.ring).negate();
    }

    public Rational<E>[] createArray(int length) {
        return new Rational[length];
    }

    @Override
    public Rational<E> randomElement(RandomGenerator rnd) {
        long den;
        long eden;
        while (this.ring.isZero(eden = this.ring.valueOf(den = (long)rnd.nextInt()))) {
        }
        return new Rational<long>(this.ring, this.ring.valueOf((long)rnd.nextInt()), eden);
    }

    @Override
    public Rational<E> randomElementTree(RandomGenerator rnd) {
        E den;
        while (this.ring.isZero(den = this.ring.randomElementTree(rnd))) {
        }
        return new Rational<E>(this.ring, this.ring.randomElementTree(rnd), den);
    }

    @Override
    public Iterator<Rational<E>> iterator() {
        throw new UnsupportedOperationException("Ring of infinite cardinality.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rationals rationals = (Rationals)o;
        return this.ring.equals(rationals.ring);
    }

    public int hashCode() {
        return this.ring.hashCode();
    }

    @Override
    public String toString(IStringifier<Rational<E>> stringifier) {
        return this.ring.equals(Rings.Z) ? "Q" : "Frac(" + this.ring.toString(stringifier.substringifier(this.ring)) + ")";
    }

    public String toString() {
        return this.toString(IStringifier.dummy());
    }
}

