/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.bigint;

import cc.redberry.rings.bigint.RoundingMode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class MathContext
implements Serializable {
    private static final int DEFAULT_DIGITS = 9;
    private static final RoundingMode DEFAULT_ROUNDINGMODE = RoundingMode.HALF_UP;
    private static final int MIN_DIGITS = 0;
    private static final long serialVersionUID = 5579720004786848255L;
    public static final MathContext UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
    public static final MathContext DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
    public static final MathContext DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);
    final int precision;
    final RoundingMode roundingMode;

    public MathContext(int setPrecision) {
        this(setPrecision, DEFAULT_ROUNDINGMODE);
    }

    public MathContext(int setPrecision, RoundingMode setRoundingMode) {
        if (setPrecision < 0) {
            throw new IllegalArgumentException("Digits < 0");
        }
        if (setRoundingMode == null) {
            throw new NullPointerException("null RoundingMode");
        }
        this.precision = setPrecision;
        this.roundingMode = setRoundingMode;
    }

    public MathContext(String val) {
        int setPrecision;
        boolean bad = false;
        if (val == null) {
            throw new NullPointerException("null String");
        }
        try {
            if (!val.startsWith("precision=")) {
                throw new RuntimeException();
            }
            int fence = val.indexOf(32);
            int off = 10;
            setPrecision = Integer.parseInt(val.substring(10, fence));
            if (!val.startsWith("roundingMode=", fence + 1)) {
                throw new RuntimeException();
            }
            off = fence + 1 + 13;
            String str = val.substring(off, val.length());
            this.roundingMode = RoundingMode.valueOf(str);
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("bad string format");
        }
        if (setPrecision < 0) {
            throw new IllegalArgumentException("Digits < 0");
        }
        this.precision = setPrecision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public boolean equals(Object x) {
        if (!(x instanceof MathContext)) {
            return false;
        }
        MathContext mc = (MathContext)x;
        return mc.precision == this.precision && mc.roundingMode == this.roundingMode;
    }

    public int hashCode() {
        return this.precision + this.roundingMode.hashCode() * 59;
    }

    public String toString() {
        return "precision=" + this.precision + " roundingMode=" + this.roundingMode.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.precision < 0) {
            String message = "MathContext: invalid digits in stream";
            throw new StreamCorruptedException(message);
        }
        if (this.roundingMode == null) {
            String message = "MathContext: null roundingMode in stream";
            throw new StreamCorruptedException(message);
        }
    }
}

