/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import java.util.Iterator;

public class AlgebraicNumberField<E extends IUnivariatePolynomial<E>>
extends SimpleFieldExtension<E> {
    public AlgebraicNumberField(E minimalPoly) {
        super(minimalPoly);
        if (minimalPoly.isOverFiniteField()) {
            throw new IllegalArgumentException("Use FiniteField for constructing extensions of finite fields.");
        }
    }

    @Override
    public boolean isField() {
        return this.minimalPoly.isOverField();
    }

    @Override
    public boolean isUnit(E element) {
        return this.isField() && !this.isZero(element) || this.isOne(element) || this.isMinusOne(element);
    }

    @Override
    public E gcd(E a, E b) {
        return this.isField() ? a : UnivariateGCD.PolynomialGCD(a, b);
    }

    @Override
    public E[] divideAndRemainder(E a, E b) {
        if (this.isField()) {
            return (IUnivariatePolynomial[])this.createArray(this.multiply(a, this.reciprocal(b)), this.getZero());
        }
        IUnivariatePolynomial[] cancel = this.normalizer2((IUnivariatePolynomial)b);
        IUnivariatePolynomial cb = cancel[0];
        IUnivariatePolynomial bcb = cancel[1];
        IUnivariatePolynomial pseudoQuot = this.multiply(a, cb);
        IUnivariatePolynomial quot = pseudoQuot.clone().divideByLC(bcb);
        if (quot != null) {
            return (IUnivariatePolynomial[])this.createArray(quot, this.getZero());
        }
        return UnivariateDivision.divideAndRemainder(a, b, (boolean)true);
    }

    @Override
    public E remainder(E dividend, E divider) {
        return (E)this.divideAndRemainder((IUnivariatePolynomial)dividend, (IUnivariatePolynomial)divider)[1];
    }

    public E normalizer(E element) {
        return (E)this.normalizer2((IUnivariatePolynomial)element)[0];
    }

    E[] normalizer2(E element) {
        if (this.isField()) {
            return (IUnivariatePolynomial[])this.createArray(this.reciprocal(element), this.getOne());
        }
        if (element.isZero()) {
            throw new ArithmeticException("divide by zero");
        }
        if (this.isOne(element)) {
            return (IUnivariatePolynomial[])this.createArray(element, this.getOne());
        }
        if (this.isMinusOne(element)) {
            return (IUnivariatePolynomial[])this.createArray(element, this.getOne());
        }
        IUnivariatePolynomial[] xgcd = UnivariateGCD.PolynomialExtendedGCD(element, (IUnivariatePolynomial)this.minimalPoly);
        IUnivariatePolynomial conjugate = xgcd[1];
        IUnivariatePolynomial content = (IUnivariatePolynomial)conjugate.contentAsPoly();
        return this.createArray(conjugate, xgcd[0].divideByLC(content));
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("this field has infinite cardinality");
    }
}

