/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.Monomial;

public final class MonomialZp64
extends AMonomial<MonomialZp64> {
    public final long coefficient;

    public MonomialZp64(DegreeVector degreeVector, long coefficient) {
        super(degreeVector);
        this.coefficient = coefficient;
    }

    public MonomialZp64(int[] exponents, int totalDegree, long coefficient) {
        super(exponents, totalDegree);
        this.coefficient = coefficient;
    }

    public MonomialZp64(int[] exponents, long coefficient) {
        super(exponents);
        this.coefficient = coefficient;
    }

    public MonomialZp64(int nVariables, long coefficient) {
        this(new int[nVariables], 0, coefficient);
    }

    @Override
    public MonomialZp64 setCoefficientFrom(MonomialZp64 oth) {
        if (this.coefficient == oth.coefficient) {
            return this;
        }
        return new MonomialZp64(this, oth.coefficient);
    }

    @Override
    public MonomialZp64 setDegreeVector(DegreeVector oth) {
        if (this == oth) {
            return this;
        }
        if (oth == null) {
            return null;
        }
        if (oth.exponents == this.exponents) {
            return this;
        }
        return new MonomialZp64(oth, this.coefficient);
    }

    @Override
    public MonomialZp64 setDegreeVector(int[] exponents, int totalDegree) {
        if (this.exponents == exponents) {
            return this;
        }
        return new MonomialZp64(exponents, totalDegree, this.coefficient);
    }

    @Override
    public MonomialZp64 forceSetDegreeVector(int[] exponents, int totalDegree) {
        return new MonomialZp64(exponents, totalDegree, this.coefficient);
    }

    public MonomialZp64 setCoefficient(long c) {
        if (this.coefficient == c) {
            return this;
        }
        return new MonomialZp64(this.exponents, this.totalDegree, c);
    }

    public Monomial<BigInteger> toBigMonomial() {
        return new Monomial<BigInteger>(this, BigInteger.valueOf(this.coefficient));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MonomialZp64 that = (MonomialZp64)o;
        return this.coefficient == that.coefficient;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.coefficient ^ this.coefficient >>> 32);
        return result;
    }

    @Override
    public String toString() {
        String dvString = super.toString();
        String cfString = Long.toString(this.coefficient);
        if (dvString.isEmpty()) {
            return cfString;
        }
        if (this.coefficient == 1L) {
            return dvString;
        }
        return this.coefficient + "*" + dvString;
    }
}

