/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.PolynomialFactorDecomposition;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.PrivateRandom;
import cc.redberry.rings.poly.univar.RandomUnivariatePolynomials;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialArithmetic;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import org.apache.commons.math3.random.RandomGenerator;

public final class EqualDegreeFactorization {
    private EqualDegreeFactorization() {
    }

    static <T extends IUnivariatePolynomial<T>> T randomMonicPoly(T factory) {
        RandomGenerator rnd = PrivateRandom.getRandom();
        int degree = Math.max(1, rnd.nextInt(2 * factory.degree() + 1));
        if (factory instanceof UnivariatePolynomialZp64) {
            UnivariatePolynomialZp64 fm = (UnivariatePolynomialZp64)factory;
            return (T)RandomUnivariatePolynomials.randomMonicPoly(degree, fm.ring.modulus, rnd);
        }
        UnivariatePolynomial fm = (UnivariatePolynomial)factory;
        return (T)RandomUnivariatePolynomials.randomMonicPoly(degree, fm.ring, rnd);
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> CantorZassenhaus(Poly input, int d) {
        Util.ensureOverFiniteField(input);
        PolynomialFactorDecomposition<IUnivariatePolynomial> result = PolynomialFactorDecomposition.unit((IUnivariatePolynomial)input.lcAsPoly());
        if (!input.coefficientRingCardinality().testBit(0)) {
            EqualDegreeFactorization.CantorZassenhaus(input, d, result, input.coefficientRingPerfectPowerExponent().intValueExact());
        } else {
            EqualDegreeFactorization.CantorZassenhaus(input, d, result, -1);
        }
        return result;
    }

    private static <T extends IUnivariatePolynomial<T>> void CantorZassenhaus(T input, int d, PolynomialFactorDecomposition<T> result, int pPower) {
        assert (input.degree() % d == 0);
        int nFactors = input.degree() / d;
        if (input.degree() == 1 || nFactors == 1) {
            result.addFactor(input, 1);
            return;
        }
        assert (input.degree() != d);
        IPolynomial poly = input.clone();
        while (true) {
            IPolynomial factor;
            if ((poly = (IUnivariatePolynomial)poly.monic()).degree() == d) break;
            while ((factor = pPower == -1 ? EqualDegreeFactorization.CantorZassenhaus0(poly, d) : EqualDegreeFactorization.CantorZassenhausGF2p(poly, d, pPower)) == null) {
            }
            if (factor.degree() != d) {
                EqualDegreeFactorization.CantorZassenhaus(factor, d, result, pPower);
            } else {
                result.addFactor((T)((IUnivariatePolynomial)factor.monic()), 1);
            }
            poly = UnivariateDivision.quotient(poly, factor, false);
        }
        result.addFactor((T)poly, 1);
    }

    private static <Poly extends IUnivariatePolynomial<Poly>> Poly CantorZassenhaus0(Poly poly, int d) {
        assert (poly.isMonic());
        Poly a = EqualDegreeFactorization.randomMonicPoly(poly);
        if (a.isConstant() || a.equals(poly)) {
            return null;
        }
        Poly gcd1 = UnivariateGCD.PolynomialGCD(a, poly);
        if (!gcd1.isConstant() && !gcd1.equals(poly)) {
            return gcd1;
        }
        BigInteger exponent = poly.coefficientRingCardinality().pow(d).decrement().shiftRight(1);
        Poly b = UnivariatePolynomialArithmetic.polyPowMod(a, exponent, poly, UnivariateDivision.fastDivisionPreConditioning(poly), true);
        IUnivariatePolynomial gcd2 = UnivariateGCD.PolynomialGCD((IUnivariatePolynomial)b.decrement(), poly);
        if (!gcd2.isConstant() && !gcd2.equals(poly)) {
            return (Poly)gcd2;
        }
        return null;
    }

    private static <Poly extends IUnivariatePolynomial<Poly>> Poly CantorZassenhausGF2p(Poly poly, int d, int pPower) {
        assert (poly.isMonic());
        Poly a = EqualDegreeFactorization.randomMonicPoly(poly);
        if (a.isConstant() || a.equals(poly)) {
            return null;
        }
        Poly gcd1 = UnivariateGCD.PolynomialGCD(a, poly);
        if (!gcd1.isConstant() && !gcd1.equals(poly)) {
            return gcd1;
        }
        UnivariateDivision.InverseModMonomial<Poly> invMod = UnivariateDivision.fastDivisionPreConditioning(poly);
        Poly b = EqualDegreeFactorization.tracePolyGF2(a, MachineArithmetic.safeToInt(1L * (long)pPower * (long)d), poly, invMod);
        Poly gcd2 = UnivariateGCD.PolynomialGCD(b, poly);
        if (!gcd2.isConstant() && !gcd2.equals(poly)) {
            return gcd2;
        }
        return null;
    }

    static <Poly extends IUnivariatePolynomial<Poly>> Poly tracePolyGF2(Poly a, int m, Poly modulus, UnivariateDivision.InverseModMonomial<Poly> invMod) {
        IPolynomial tmp = a.clone();
        IPolynomial result = a.clone();
        for (int i = 0; i < m - 1; ++i) {
            tmp = UnivariatePolynomialArithmetic.polyMultiplyMod(tmp, tmp, modulus, invMod, false);
            result.add(tmp);
        }
        return (Poly)result;
    }
}

