/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.combinatorics.Combinatorics;
import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.Rational;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.AlgebraicNumberField;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.MultipleFieldExtension;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.PolynomialFactorDecomposition;
import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MultivariateFactorization;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.univar.AUnivariatePolynomial64;
import cc.redberry.rings.poly.univar.Conversions64bit;
import cc.redberry.rings.poly.univar.DistinctDegreeFactorization;
import cc.redberry.rings.poly.univar.EqualDegreeFactorization;
import cc.redberry.rings.poly.univar.HenselLifting;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.PrivateRandom;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZ64;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.UnivariateSquareFreeFactorization;
import cc.redberry.rings.primes.BigPrimes;
import cc.redberry.rings.primes.SmallPrimes;
import cc.redberry.rings.util.ArraysUtil;
import java.util.List;
import java.util.function.Function;

public final class UnivariateFactorization {
    private static int[][] naturalSequenceRefCache = new int[32][];
    private static final double MAX_PRIME_GAP = 382.0;
    private static final double MIGNOTTE_MAX_DOUBLE_32 = 4.294963474E9;
    private static final double MIGNOTTE_MAX_DOUBLE_64 = 1.844671124299415E19;
    private static final int LOWER_RND_MODULUS_BOUND = 0x1000000;
    private static final int UPPER_RND_MODULUS_BOUND = 0x40000000;
    static final int N_MIN_MODULAR_FACTORIZATION_TRIALS = 2;
    static final int N_SIMPLE_MOD_PATTERN_FACTORS = 12;
    static final int N_MODULAR_FACTORIZATION_TRIALS = 4;

    private UnivariateFactorization() {
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> Factor(Poly poly) {
        if (poly.isOverFiniteField()) {
            return UnivariateFactorization.FactorInGF(poly);
        }
        if (poly.isOverZ()) {
            return UnivariateFactorization.FactorInZ(poly);
        }
        if (Util.isOverRationals(poly)) {
            return UnivariateFactorization.FactorInQ((UnivariatePolynomial)poly);
        }
        if (Util.isOverSimpleNumberField(poly)) {
            return UnivariateFactorization.FactorInNumberField((UnivariatePolynomial)poly);
        }
        if (Util.isOverMultipleFieldExtension(poly)) {
            return UnivariateFactorization.FactorInMultipleFieldExtension((UnivariatePolynomial)poly);
        }
        if (UnivariateFactorization.isOverMultivariate(poly)) {
            return UnivariateFactorization.FactorOverMultivariate((UnivariatePolynomial)poly, MultivariateFactorization::Factor);
        }
        if (UnivariateFactorization.isOverUnivariate(poly)) {
            return UnivariateFactorization.FactorOverUnivariate((UnivariatePolynomial)poly, MultivariateFactorization::Factor);
        }
        throw new RuntimeException("ring is not supported: " + poly.coefficientRingToString());
    }

    static <T extends IUnivariatePolynomial<T>> boolean isOverMultivariate(T poly) {
        return poly instanceof UnivariatePolynomial && ((UnivariatePolynomial)poly).ring instanceof MultivariateRing;
    }

    static <T extends IUnivariatePolynomial<T>> boolean isOverUnivariate(T poly) {
        return poly instanceof UnivariatePolynomial && ((UnivariatePolynomial)poly).ring instanceof UnivariateRing;
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<UnivariatePolynomial<Poly>> FactorOverMultivariate(UnivariatePolynomial<Poly> poly, Function<Poly, PolynomialFactorDecomposition<Poly>> factorFunction) {
        return factorFunction.apply(AMultivariatePolynomial.asMultivariate(poly, 0, true)).mapTo(p -> p.asUnivariateEliminate(0));
    }

    static <uPoly extends IUnivariatePolynomial<uPoly>> PolynomialFactorDecomposition<UnivariatePolynomial<uPoly>> FactorOverUnivariate(UnivariatePolynomial<uPoly> poly, Function<MultivariatePolynomial<uPoly>, PolynomialFactorDecomposition<MultivariatePolynomial<uPoly>>> factorFunction) {
        return factorFunction.apply((MultivariatePolynomial)AMultivariatePolynomial.asMultivariate(poly, 1, 0, MonomialOrder.DEFAULT)).mapTo(MultivariatePolynomial::asUnivariate);
    }

    public static <E> PolynomialFactorDecomposition<UnivariatePolynomial<Rational<E>>> FactorInQ(UnivariatePolynomial<Rational<E>> poly) {
        Util.Tuple2<UnivariatePolynomial<E>, E> cmd = Util.toCommonDenominator(poly);
        UnivariatePolynomial integral = (UnivariatePolynomial)cmd._1;
        Object denominator = cmd._2;
        return UnivariateFactorization.Factor(integral).mapTo(p -> Util.asOverRationals(poly.ring, p)).addUnit(poly.createConstant(new Rational(integral.ring, integral.ring.getOne(), denominator)));
    }

    private static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> PolynomialFactorDecomposition<UnivariatePolynomial<mPoly>> FactorInMultipleFieldExtension(UnivariatePolynomial<mPoly> poly) {
        MultipleFieldExtension ring = (MultipleFieldExtension)poly.ring;
        SimpleFieldExtension simpleExtension = ring.getSimpleExtension();
        return UnivariateFactorization.Factor(poly.mapCoefficients(simpleExtension, ring::inverse)).mapTo(p -> p.mapCoefficients(ring, ring::image));
    }

    private static <Poly extends IUnivariatePolynomial<Poly>> FactorMonomial<Poly> factorOutMonomial(Poly poly) {
        int i = poly.firstNonZeroCoefficientPosition();
        if (i == 0) {
            return new FactorMonomial<IUnivariatePolynomial>(poly, (IUnivariatePolynomial)poly.createOne());
        }
        return new FactorMonomial(poly.clone().shiftLeft(i), poly.createMonomial(i));
    }

    private static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> earlyFactorizationChecks(Poly poly) {
        if (poly.degree() <= 1 || poly.isMonomial()) {
            return PolynomialFactorDecomposition.of((IUnivariatePolynomial)poly.lcAsPoly(), poly.isMonic() ? poly : (IUnivariatePolynomial)poly.clone().monic());
        }
        return null;
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> FactorInGF(Poly poly) {
        Util.ensureOverFiniteField(poly);
        if (Conversions64bit.canConvertToZp64(poly)) {
            return UnivariateFactorization.FactorInGF(Conversions64bit.asOverZp64(poly)).mapTo(Conversions64bit::convert);
        }
        PolynomialFactorDecomposition<IUnivariatePolynomial> result = UnivariateFactorization.earlyFactorizationChecks(poly);
        if (result != null) {
            return result;
        }
        result = PolynomialFactorDecomposition.empty(poly);
        UnivariateFactorization.FactorInGF(poly, result);
        return result.setUnit((IUnivariatePolynomial)poly.lcAsPoly());
    }

    public static <T extends IUnivariatePolynomial<T>> PolynomialFactorDecomposition<T> FactorSquareFreeInGF(T poly) {
        Util.ensureOverFiniteField(poly);
        if (Conversions64bit.canConvertToZp64(poly)) {
            return UnivariateFactorization.FactorInGF(Conversions64bit.asOverZp64(poly)).mapTo(Conversions64bit::convert);
        }
        PolynomialFactorDecomposition<T> result = PolynomialFactorDecomposition.empty(poly);
        UnivariateFactorization.FactorSquareFreeInGF(poly, 1, result);
        return result;
    }

    private static <T extends IUnivariatePolynomial<T>> void FactorSquareFreeInGF(T poly, int exponent, PolynomialFactorDecomposition<T> result) {
        PolynomialFactorDecomposition<T> ddf = DistinctDegreeFactorization.DistinctDegreeFactorization(poly);
        for (int j = 0; j < ddf.size(); ++j) {
            IUnivariatePolynomial ddfFactor = (IUnivariatePolynomial)ddf.get(j);
            int ddfExponent = ddf.getExponent(j);
            PolynomialFactorDecomposition<IUnivariatePolynomial> edf = EqualDegreeFactorization.CantorZassenhaus(ddfFactor, ddfExponent);
            for (IUnivariatePolynomial irreducibleFactor : edf.factors) {
                result.addFactor((T)((IUnivariatePolynomial)irreducibleFactor.monic()), exponent);
            }
        }
    }

    private static <T extends IUnivariatePolynomial<T>> void FactorInGF(T poly, PolynomialFactorDecomposition<T> result) {
        FactorMonomial<T> base = UnivariateFactorization.factorOutMonomial(poly);
        if (!base.monomial.isConstant()) {
            result.addFactor(poly.createMonomial(1), base.monomial.degree());
        }
        PolynomialFactorDecomposition sqf = UnivariateSquareFreeFactorization.SquareFreeFactorization(base.theRest);
        for (int i = 0; i < sqf.size(); ++i) {
            IUnivariatePolynomial sqfFactor = (IUnivariatePolynomial)sqf.get(i);
            int sqfExponent = sqf.getExponent(i);
            UnivariateFactorization.FactorSquareFreeInGF(sqfFactor, sqfExponent, result);
        }
    }

    private static <T extends IUnivariatePolynomial<T>> void assertDistinctDegreeFactorization(T poly, PolynomialFactorDecomposition<T> factorization) {
        for (int i = 0; i < factorization.factors.size(); ++i) {
            assert (0 == ((IUnivariatePolynomial)factorization.factors.get(i)).degree() % factorization.exponents.get(i)) : "Factor's degree is not divisible by d.d.f. exponent";
        }
        assert (poly.equals(factorization.multiplyIgnoreExponents()));
    }

    static <T extends IUnivariatePolynomial<T>> void assertHenselLift(HenselLifting.QuadraticLiftAbstract<T> lift) {
        assert (lift.polyMod().equals(lift.aFactor.clone().multiply(lift.bFactor))) : lift.toString();
        assert (lift.aCoFactor == null && lift.bCoFactor == null || ((IUnivariatePolynomial)lift.aFactor.clone().multiply(lift.aCoFactor)).add((IUnivariatePolynomial)lift.bFactor.clone().multiply(lift.bCoFactor)).isOne()) : lift.toString();
    }

    private static int[] createSeq(int n) {
        int[] r = new int[n];
        for (int i = 0; i < n; ++i) {
            r[i] = i;
        }
        return r;
    }

    private static int[] naturalSequenceRef(int n) {
        if (n >= naturalSequenceRefCache.length) {
            return UnivariateFactorization.createSeq(n);
        }
        if (naturalSequenceRefCache[n] != null) {
            return naturalSequenceRefCache[n];
        }
        UnivariateFactorization.naturalSequenceRefCache[n] = UnivariateFactorization.createSeq(n);
        return UnivariateFactorization.naturalSequenceRefCache[n];
    }

    private static int[] select(int[] data, int[] positions) {
        int[] r = new int[positions.length];
        int i = 0;
        for (int p : positions) {
            r[i++] = data[p];
        }
        return r;
    }

    static PolynomialFactorDecomposition<UnivariatePolynomialZ64> reconstructFactorsZ(UnivariatePolynomialZ64 poly, PolynomialFactorDecomposition<UnivariatePolynomialZp64> modularFactors) {
        if (modularFactors.isTrivial()) {
            return PolynomialFactorDecomposition.of(poly);
        }
        UnivariatePolynomialZp64 factory = (UnivariatePolynomialZp64)modularFactors.get(0);
        int[] modIndexes = UnivariateFactorization.naturalSequenceRef(modularFactors.size());
        PolynomialFactorDecomposition<UnivariatePolynomialZ64> trueFactors = PolynomialFactorDecomposition.empty(poly);
        UnivariatePolynomialZ64 fRest = poly;
        int s = 1;
        block0: while (2 * s <= modIndexes.length) {
            for (int[] combination : Combinatorics.combinations(modIndexes.length, s)) {
                int[] restIndexes;
                int[] indexes = UnivariateFactorization.select(modIndexes, combination);
                UnivariatePolynomialZp64 mFactor = (UnivariatePolynomialZp64)factory.createConstant(fRest.lc());
                for (int i : indexes) {
                    mFactor = mFactor.multiply((UnivariatePolynomialZp64)modularFactors.get(i));
                }
                UnivariatePolynomialZ64 factor = (UnivariatePolynomialZ64)mFactor.asPolyZSymmetric().primitivePart();
                if (fRest.lc() % factor.lc() != 0L || fRest.cc() % factor.cc() != 0L) continue;
                UnivariatePolynomialZp64 mRest = (UnivariatePolynomialZp64)factory.createConstant(fRest.lc() / factor.lc());
                for (int i : restIndexes = ArraysUtil.intSetDifference(modIndexes, indexes)) {
                    mRest = mRest.multiply((UnivariatePolynomialZp64)modularFactors.get(i));
                }
                UnivariatePolynomialZ64 rest = (UnivariatePolynomialZ64)mRest.asPolyZSymmetric().primitivePart();
                if (MachineArithmetic.safeMultiply(factor.lc(), rest.lc()) != fRest.lc() || MachineArithmetic.safeMultiply(factor.cc(), rest.cc()) != fRest.cc() || !rest.clone().multiplyUnsafe(factor).equals(fRest)) continue;
                modIndexes = restIndexes;
                trueFactors.addFactor(factor, 1);
                fRest = (UnivariatePolynomialZ64)rest.primitivePart();
                continue block0;
            }
            ++s;
        }
        if (!fRest.isConstant()) {
            trueFactors.addFactor(fRest, 1);
        }
        return trueFactors;
    }

    static PolynomialFactorDecomposition<UnivariatePolynomial<BigInteger>> reconstructFactorsZ(UnivariatePolynomial<BigInteger> poly, PolynomialFactorDecomposition<UnivariatePolynomial<BigInteger>> modularFactors) {
        if (modularFactors.isTrivial()) {
            return PolynomialFactorDecomposition.of(poly);
        }
        UnivariatePolynomial factory = (UnivariatePolynomial)modularFactors.get(0);
        int[] modIndexes = UnivariateFactorization.naturalSequenceRef(modularFactors.size());
        PolynomialFactorDecomposition<UnivariatePolynomial<BigInteger>> trueFactors = PolynomialFactorDecomposition.empty(poly);
        IPolynomial fRest = poly;
        int s = 1;
        block0: while (2 * s <= modIndexes.length) {
            for (int[] combination : Combinatorics.combinations(modIndexes.length, s)) {
                int[] restIndexes;
                int[] indexes = UnivariateFactorization.select(modIndexes, combination);
                UnivariatePolynomial<BigInteger> mFactor = factory.createConstant(fRest.lc());
                for (int i : indexes) {
                    mFactor = mFactor.multiply((UnivariatePolynomial)modularFactors.get(i));
                }
                IPolynomial factor = UnivariatePolynomial.asPolyZSymmetric(mFactor).primitivePart();
                if (!fRest.lc().remainder((BigInteger)((UnivariatePolynomial)factor).lc()).isZero() || !fRest.cc().remainder((BigInteger)((UnivariatePolynomial)factor).cc()).isZero()) continue;
                UnivariatePolynomial<BigInteger> mRest = factory.createConstant(fRest.lc().divide((BigInteger)((UnivariatePolynomial)factor).lc()));
                for (int i : restIndexes = ArraysUtil.intSetDifference(modIndexes, indexes)) {
                    mRest = mRest.multiply((UnivariatePolynomial)modularFactors.get(i));
                }
                IPolynomial rest = UnivariatePolynomial.asPolyZSymmetric(mRest).primitivePart();
                if (!((BigInteger)((UnivariatePolynomial)factor).lc()).multiply((BigInteger)((UnivariatePolynomial)rest).lc()).equals(fRest.lc()) || !((BigInteger)((UnivariatePolynomial)factor).cc()).multiply((BigInteger)((UnivariatePolynomial)rest).cc()).equals(fRest.cc()) || !((UnivariatePolynomial)((UnivariatePolynomial)rest).clone()).multiply(factor).equals(fRest)) continue;
                modIndexes = restIndexes;
                trueFactors.addFactor((UnivariatePolynomial<BigInteger>)factor, 1);
                fRest = ((UnivariatePolynomial)rest).primitivePart();
                continue block0;
            }
            ++s;
        }
        if (!fRest.isConstant()) {
            trueFactors.addFactor((UnivariatePolynomial<BigInteger>)fRest, 1);
        }
        return trueFactors;
    }

    private static int randomModulusInf() {
        return 0x1000000 + PrivateRandom.getRandom().nextInt(0x3F000000);
    }

    private static int next32BitPrime(int val) {
        if (val < 0) {
            long l = BigPrimes.nextPrime(Integer.toUnsignedLong(val));
            assert (MachineArithmetic.fits32bitWord(l));
            return (int)l;
        }
        return SmallPrimes.nextPrime(val);
    }

    static PolynomialFactorDecomposition<UnivariatePolynomial<BigInteger>> FactorSquareFreeInZ0(UnivariatePolynomial<BigInteger> poly) {
        PolynomialFactorDecomposition<UnivariatePolynomialZ64> tryLong;
        assert (poly.content().isOne());
        assert (poly.lc().signum() > 0);
        BigInteger bound2 = BigInteger.TWO.multiply(UnivariatePolynomial.mignotteBound(poly)).multiply(poly.lc().abs());
        if (bound2.compareTo(MachineArithmetic.b_MAX_SUPPORTED_MODULUS) < 0 && (tryLong = UnivariateFactorization.FactorSquareFreeInZ0(UnivariatePolynomial.asOverZ64(poly))) != null) {
            return UnivariateFactorization.convertFactorizationToBigIntegers(tryLong);
        }
        long modulus = -1L;
        PolynomialFactorDecomposition<UnivariatePolynomialZp64> lModularFactors = null;
        for (int attempt = 0; attempt < 4 && (attempt < 2 || lModularFactors.size() > 12); ++attempt) {
            long tmpModulus;
            UnivariatePolynomialZp64 moduloImage;
            while ((moduloImage = UnivariatePolynomial.asOverZp64(poly.setRing(new IntegersZp(tmpModulus = (long)SmallPrimes.nextPrime(UnivariateFactorization.randomModulusInf()))))).cc() == 0L || moduloImage.degree() != poly.degree() || !UnivariateSquareFreeFactorization.isSquareFree(moduloImage)) {
            }
            PolynomialFactorDecomposition<UnivariatePolynomialZp64> tmpFactors = UnivariateFactorization.FactorInGF(moduloImage.monic());
            if (tmpFactors.size() == 1) {
                return PolynomialFactorDecomposition.of(poly);
            }
            if (lModularFactors == null || lModularFactors.size() > tmpFactors.size()) {
                lModularFactors = tmpFactors;
                modulus = tmpModulus;
            }
            if (lModularFactors.size() <= 3) break;
        }
        List<UnivariatePolynomial<BigInteger>> modularFactors = HenselLifting.liftFactorization(BigInteger.valueOf(modulus), bound2, poly, lModularFactors.factors);
        assert (modularFactors.get((int)0).ring.cardinality().compareTo(bound2) >= 0);
        return UnivariateFactorization.reconstructFactorsZ(poly, PolynomialFactorDecomposition.of(modularFactors));
    }

    static <T extends AUnivariatePolynomial64<T>> PolynomialFactorDecomposition<UnivariatePolynomial<BigInteger>> convertFactorizationToBigIntegers(PolynomialFactorDecomposition<T> decomposition) {
        return decomposition.mapTo(AUnivariatePolynomial64::toBigPoly);
    }

    private static int chooseModulusLowerBound(double bound2) {
        long infinum;
        if (bound2 < 4.294963474E9) {
            infinum = (long)bound2;
        } else if (bound2 < 1.844671124299415E19) {
            infinum = (long)Math.sqrt(bound2);
        } else {
            throw new IllegalArgumentException();
        }
        assert ((double)infinum < 4.294963474E9);
        return (int)infinum;
    }

    static PolynomialFactorDecomposition<UnivariatePolynomialZ64> FactorSquareFreeInZ0(UnivariatePolynomialZ64 poly) {
        long modulus;
        UnivariatePolynomialZp64 moduloImage;
        assert (poly.content() == 1L);
        assert (poly.lc() > 0L);
        long lc = poly.lc();
        double bound2 = 2.0 * poly.mignotteBound() * (double)Math.abs(lc);
        int trial32Modulus = UnivariateFactorization.chooseModulusLowerBound(bound2) - 1;
        while (!UnivariateSquareFreeFactorization.isSquareFree(moduloImage = poly.modulus(modulus = Integer.toUnsignedLong(trial32Modulus = UnivariateFactorization.next32BitPrime(trial32Modulus + 1)), true))) {
        }
        int henselIterations = 0;
        long liftedModulus = modulus;
        while ((double)liftedModulus < bound2) {
            if (MachineArithmetic.isOverflowMultiply(liftedModulus, liftedModulus)) {
                return null;
            }
            liftedModulus = MachineArithmetic.safeMultiply(liftedModulus, liftedModulus);
            ++henselIterations;
        }
        PolynomialFactorDecomposition<UnivariatePolynomialZp64> modularFactors = UnivariateFactorization.FactorInGF(moduloImage.monic());
        if (henselIterations > 0) {
            modularFactors = PolynomialFactorDecomposition.of(HenselLifting.liftFactorization(modulus, liftedModulus, henselIterations, poly, modularFactors.factors, true)).addUnit(((UnivariatePolynomialZp64)modularFactors.unit).setModulus(liftedModulus));
        }
        return UnivariateFactorization.reconstructFactorsZ(poly, modularFactors);
    }

    public static <PolyZ extends IUnivariatePolynomial<PolyZ>> PolynomialFactorDecomposition<PolyZ> FactorSquareFreeInZ(PolyZ poly) {
        UnivariateFactorization.ensureIntegersDomain(poly);
        if (poly.degree() <= 1 || poly.isMonomial()) {
            if (poly.isMonic()) {
                return PolynomialFactorDecomposition.of(poly);
            }
            IUnivariatePolynomial c = (IUnivariatePolynomial)poly.contentAsPoly();
            return PolynomialFactorDecomposition.of(c, poly.clone().divideByLC(c));
        }
        IUnivariatePolynomial content = (IUnivariatePolynomial)poly.contentAsPoly();
        if (poly.signumOfLC() < 0) {
            content = (IUnivariatePolynomial)content.negate();
        }
        return UnivariateFactorization.FactorSquareFreeInZ0(poly.clone().divideByLC(content)).setUnit(content);
    }

    private static <PolyZ extends IUnivariatePolynomial<PolyZ>> PolynomialFactorDecomposition<PolyZ> FactorSquareFreeInZ0(PolyZ poly) {
        if (poly instanceof UnivariatePolynomialZ64) {
            return UnivariateFactorization.FactorSquareFreeInZ0((UnivariatePolynomialZ64)poly);
        }
        return UnivariateFactorization.FactorSquareFreeInZ0((UnivariatePolynomial)poly);
    }

    private static void ensureIntegersDomain(IUnivariatePolynomial poly) {
        if (poly instanceof UnivariatePolynomialZ64 || poly instanceof UnivariatePolynomial && ((UnivariatePolynomial)poly).ring.equals(Rings.Z)) {
            return;
        }
        throw new IllegalArgumentException("Not an integers ring for factorization in Z[x]");
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> FactorInZ(Poly poly) {
        UnivariateFactorization.ensureIntegersDomain(poly);
        if (poly.degree() <= 1 || poly.isMonomial()) {
            if (poly.isMonic()) {
                return PolynomialFactorDecomposition.of(poly);
            }
            IUnivariatePolynomial c = (IUnivariatePolynomial)poly.contentAsPoly();
            return PolynomialFactorDecomposition.of(c, poly.clone().divideByLC(c));
        }
        PolynomialFactorDecomposition<IUnivariatePolynomial> result = PolynomialFactorDecomposition.empty(poly);
        IUnivariatePolynomial content = (IUnivariatePolynomial)poly.contentAsPoly();
        if (poly.signumOfLC() < 0) {
            content = (IUnivariatePolynomial)content.negate();
        }
        UnivariateFactorization.FactorInZ(poly.clone().divideByLC(content), result);
        return result.setUnit(content);
    }

    private static <T extends IUnivariatePolynomial<T>> void FactorInZ(T poly, PolynomialFactorDecomposition<T> result) {
        UnivariateFactorization.FactorGeneric(poly, result, UnivariateFactorization::FactorSquareFreeInZ0);
    }

    private static <T extends IUnivariatePolynomial<T>> void FactorGeneric(T poly, PolynomialFactorDecomposition<T> result, Function<T, PolynomialFactorDecomposition<T>> factorSquareFree) {
        FactorMonomial<T> base = UnivariateFactorization.factorOutMonomial(poly);
        if (!base.monomial.isConstant()) {
            result.addFactor(poly.createMonomial(1), base.monomial.degree());
        }
        PolynomialFactorDecomposition sqf = UnivariateSquareFreeFactorization.SquareFreeFactorization(base.theRest);
        for (int i = 0; i < sqf.size(); ++i) {
            IUnivariatePolynomial sqfFactor = (IUnivariatePolynomial)sqf.get(i);
            int sqfExponent = sqf.getExponent(i);
            PolynomialFactorDecomposition<T> cz = factorSquareFree.apply(sqfFactor);
            for (IUnivariatePolynomial irreducibleFactor : cz.factors) {
                result.addFactor((T)irreducibleFactor, sqfExponent);
            }
        }
    }

    public static PolynomialFactorDecomposition<UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>> FactorInNumberField(UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> poly) {
        if (poly.degree() <= 1 || poly.isMonomial()) {
            return PolynomialFactorDecomposition.of(poly);
        }
        PolynomialFactorDecomposition<UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>> result = PolynomialFactorDecomposition.empty(poly);
        UnivariateFactorization.FactorInNumberField(poly, result);
        if (result.isTrivial()) {
            return PolynomialFactorDecomposition.of(poly);
        }
        AlgebraicNumberField numberField = (AlgebraicNumberField)poly.ring;
        UnivariatePolynomial unit = (UnivariatePolynomial)((UnivariatePolynomial)result.unit).lc();
        for (int i = 0; i < result.size(); ++i) {
            unit = numberField.multiply(unit, numberField.pow((UnivariatePolynomial)((UnivariatePolynomial)result.get(i)).lc(), result.getExponent(i)));
        }
        unit = numberField.divideExact(poly.lc(), unit);
        result.addUnit(UnivariatePolynomial.constant(numberField, unit));
        return result;
    }

    private static void FactorInNumberField(UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> poly, PolynomialFactorDecomposition<UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>> result) {
        UnivariateFactorization.FactorGeneric(poly, result, UnivariateFactorization::FactorSquareFreeInNumberField);
    }

    public static PolynomialFactorDecomposition<UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>> FactorSquareFreeInNumberField(UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> poly) {
        AlgebraicNumberField numberField = (AlgebraicNumberField)poly.ring;
        int s = 0;
        while (true) {
            UnivariatePolynomial<IPolynomial<UnivariatePolynomial<BigInteger>>> sPoly;
            UnivariatePolynomial<IPolynomial> backSubstitution;
            if (s == 0) {
                backSubstitution = null;
                sPoly = poly;
            } else {
                sPoly = poly.composition(((UnivariatePolynomial)poly.createMonomial(1)).subtract(((UnivariatePolynomial)numberField.generator()).multiply(s)));
                backSubstitution = ((UnivariatePolynomial)poly.createMonomial(1)).add(((UnivariatePolynomial)numberField.generator()).multiply(s));
            }
            UnivariatePolynomial<Rational<BigInteger>> sPolyNorm = numberField.normOfPolynomial(sPoly);
            if (UnivariateSquareFreeFactorization.isSquareFree(sPolyNorm)) {
                PolynomialFactorDecomposition<UnivariatePolynomial<Rational<BigInteger>>> normFactors = UnivariateFactorization.Factor(sPolyNorm);
                if (normFactors.isTrivial()) {
                    return PolynomialFactorDecomposition.of(poly);
                }
                PolynomialFactorDecomposition<UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>> result = PolynomialFactorDecomposition.empty(poly);
                for (int i = 0; i < normFactors.size(); ++i) {
                    assert (normFactors.getExponent(i) == 1);
                    UnivariatePolynomial<IPolynomial<UnivariatePolynomial<BigInteger>>> factor = UnivariateGCD.PolynomialGCD(sPoly, UnivariateFactorization.toNumberField(numberField, (UnivariatePolynomial)normFactors.get(i)));
                    if (backSubstitution != null) {
                        factor = factor.composition(backSubstitution);
                    }
                    result.addFactor(factor, 1);
                }
                return result;
            }
            ++s;
        }
    }

    private static UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> toNumberField(AlgebraicNumberField<UnivariatePolynomial<Rational<BigInteger>>> numberField, UnivariatePolynomial<Rational<BigInteger>> poly) {
        return poly.mapCoefficients(numberField, cf -> UnivariatePolynomial.constant(Rings.Q, cf));
    }

    private static final class FactorMonomial<T extends IUnivariatePolynomial<T>> {
        final T theRest;
        final T monomial;

        FactorMonomial(T theRest, T monomial) {
            this.theRest = theRest;
            this.monomial = monomial;
        }
    }
}

