# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

import httpx
import pydantic
import typing_extensions

from ...core.api_error import ApiError
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_headers import remove_none_from_headers
from ...environment import DoptApiEnvironment
from ...errors.bad_request_error import BadRequestError
from ...errors.internal_server_error import InternalServerError
from ...errors.not_found_error import NotFoundError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.get_flow_response import GetFlowResponse
from ...types.intent_request_intent import IntentRequestIntent


class FlowsClient:
    def __init__(self, *, environment: DoptApiEnvironment = DoptApiEnvironment.DEFAULT, api_key: str):
        self._environment = environment
        self.api_key = api_key

    def get_flow(
        self,
        sid: str,
        *,
        version: float,
        include: typing.Optional[typing_extensions.Literal["block"]] = None,
        user_identifier: str,
        group_identifier: typing.Optional[str] = None,
    ) -> GetFlowResponse:
        _response = httpx.request(
            "GET",
            urllib.parse.urljoin(f"{self._environment.value}/", f"v2/flow/{sid}"),
            params={
                "version": version,
                "include": include,
                "userIdentifier": user_identifier,
                "groupIdentifier": group_identifier,
            },
            headers=remove_none_from_headers({"X-Api-Key": self.api_key}),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetFlowResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def intent(
        self,
        uid: str,
        intent: IntentRequestIntent,
        *,
        version: float,
        user_identifier: str,
        group_identifier: typing.Optional[str] = None,
    ) -> None:
        _response = httpx.request(
            "POST",
            urllib.parse.urljoin(f"{self._environment.value}/", f"v2/flow/{uid}/{intent}"),
            params={"version": version, "userIdentifier": user_identifier, "groupIdentifier": group_identifier},
            json=jsonable_encoder({}),
            headers=remove_none_from_headers({"X-Api-Key": self.api_key}),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncFlowsClient:
    def __init__(self, *, environment: DoptApiEnvironment = DoptApiEnvironment.DEFAULT, api_key: str):
        self._environment = environment
        self.api_key = api_key

    async def get_flow(
        self,
        sid: str,
        *,
        version: float,
        include: typing.Optional[typing_extensions.Literal["block"]] = None,
        user_identifier: str,
        group_identifier: typing.Optional[str] = None,
    ) -> GetFlowResponse:
        async with httpx.AsyncClient() as _client:
            _response = await _client.request(
                "GET",
                urllib.parse.urljoin(f"{self._environment.value}/", f"v2/flow/{sid}"),
                params={
                    "version": version,
                    "include": include,
                    "userIdentifier": user_identifier,
                    "groupIdentifier": group_identifier,
                },
                headers=remove_none_from_headers({"X-Api-Key": self.api_key}),
                timeout=60,
            )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetFlowResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def intent(
        self,
        uid: str,
        intent: IntentRequestIntent,
        *,
        version: float,
        user_identifier: str,
        group_identifier: typing.Optional[str] = None,
    ) -> None:
        async with httpx.AsyncClient() as _client:
            _response = await _client.request(
                "POST",
                urllib.parse.urljoin(f"{self._environment.value}/", f"v2/flow/{uid}/{intent}"),
                params={"version": version, "userIdentifier": user_identifier, "groupIdentifier": group_identifier},
                json=jsonable_encoder({}),
                headers=remove_none_from_headers({"X-Api-Key": self.api_key}),
                timeout=60,
            )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
