# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

import pydantic
import typing_extensions

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...errors.bad_request_error import BadRequestError
from ...errors.internal_server_error import InternalServerError
from ...errors.not_found_error import NotFoundError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.get_flow_request_tag import GetFlowRequestTag
from ...types.get_flow_response import GetFlowResponse
from ...types.intent_request_intent import IntentRequestIntent
from ...types.intent_request_tag import IntentRequestTag

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FlowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_flow(
        self,
        sid: str,
        *,
        user_identifier: str,
        group_identifier: typing.Optional[str] = None,
        version: typing.Optional[float] = None,
        tag: typing.Optional[GetFlowRequestTag] = None,
        include: typing.Optional[typing_extensions.Literal["block"]] = None,
    ) -> GetFlowResponse:
        """
        Parameters:
            - sid: str.

            - user_identifier: str.

            - group_identifier: typing.Optional[str].

            - version: typing.Optional[float].

            - tag: typing.Optional[GetFlowRequestTag].

            - include: typing.Optional[typing_extensions.Literal["block"]].
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v2/flow/{sid}"),
            params=remove_none_from_dict(
                {
                    "userIdentifier": user_identifier,
                    "groupIdentifier": group_identifier,
                    "version": version,
                    "tag": tag,
                    "include": include,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetFlowResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def intent(
        self,
        uid: str,
        intent: IntentRequestIntent,
        *,
        user_identifier: str,
        group_identifier: typing.Optional[str] = None,
        version: typing.Optional[float] = None,
        tag: typing.Optional[IntentRequestTag] = None,
        force: typing.Optional[bool] = None,
    ) -> None:
        """
        Parameters:
            - uid: str.

            - intent: IntentRequestIntent.

            - user_identifier: str.

            - group_identifier: typing.Optional[str].

            - version: typing.Optional[float].

            - tag: typing.Optional[IntentRequestTag].

            - force: typing.Optional[bool].
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v2/flow/{uid}/{intent}"),
            params=remove_none_from_dict(
                {
                    "userIdentifier": user_identifier,
                    "groupIdentifier": group_identifier,
                    "version": version,
                    "tag": tag,
                    "force": force,
                }
            ),
            json=jsonable_encoder({}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncFlowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_flow(
        self,
        sid: str,
        *,
        user_identifier: str,
        group_identifier: typing.Optional[str] = None,
        version: typing.Optional[float] = None,
        tag: typing.Optional[GetFlowRequestTag] = None,
        include: typing.Optional[typing_extensions.Literal["block"]] = None,
    ) -> GetFlowResponse:
        """
        Parameters:
            - sid: str.

            - user_identifier: str.

            - group_identifier: typing.Optional[str].

            - version: typing.Optional[float].

            - tag: typing.Optional[GetFlowRequestTag].

            - include: typing.Optional[typing_extensions.Literal["block"]].
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v2/flow/{sid}"),
            params=remove_none_from_dict(
                {
                    "userIdentifier": user_identifier,
                    "groupIdentifier": group_identifier,
                    "version": version,
                    "tag": tag,
                    "include": include,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetFlowResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def intent(
        self,
        uid: str,
        intent: IntentRequestIntent,
        *,
        user_identifier: str,
        group_identifier: typing.Optional[str] = None,
        version: typing.Optional[float] = None,
        tag: typing.Optional[IntentRequestTag] = None,
        force: typing.Optional[bool] = None,
    ) -> None:
        """
        Parameters:
            - uid: str.

            - intent: IntentRequestIntent.

            - user_identifier: str.

            - group_identifier: typing.Optional[str].

            - version: typing.Optional[float].

            - tag: typing.Optional[IntentRequestTag].

            - force: typing.Optional[bool].
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v2/flow/{uid}/{intent}"),
            params=remove_none_from_dict(
                {
                    "userIdentifier": user_identifier,
                    "groupIdentifier": group_identifier,
                    "version": version,
                    "tag": tag,
                    "force": force,
                }
            ),
            json=jsonable_encoder({}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 500:
            raise InternalServerError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
