# This file was auto-generated by Fern from our API Definition.

import typing

import httpx

from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import DoptApiEnvironment
from .resources.groups.client import AsyncGroupsClient, GroupsClient
from .resources.users.client import AsyncUsersClient, UsersClient


class DoptApi:
    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: DoptApiEnvironment = DoptApiEnvironment.DEFAULT,
        api_key: str,
        timeout: typing.Optional[float] = 60
    ):
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx.Client(timeout=timeout),
        )
        self.users = UsersClient(client_wrapper=self._client_wrapper)
        self.groups = GroupsClient(client_wrapper=self._client_wrapper)


class AsyncDoptApi:
    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: DoptApiEnvironment = DoptApiEnvironment.DEFAULT,
        api_key: str,
        timeout: typing.Optional[float] = 60
    ):
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx.AsyncClient(timeout=timeout),
        )
        self.users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        self.groups = AsyncGroupsClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: DoptApiEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
