import math
import random
from tqdm import tqdm
import numpy as np

class MLP:
    def __init__(self, input_node_num, hidden_node_num):
        self.input_node_num = input_node_num
        self.hidden_node_num = hidden_node_num

        hidden_weight = []
        for i in range(hidden_node_num):
            weight_list = []
            for j in range(input_node_num + 1):
                weight_list.append(random.random())
            hidden_weight.append(weight_list)
        self.hidden_weight = hidden_weight

        output_weight = []
        for i in range(hidden_node_num + 1):
            output_weight.append(random.random())
        self.output_weight = output_weight

        self.loss_values = []
        self.accuracy_list = []

    def relu(self, x):
        if x >= 0:
            return x
        else:
            return 0

    def relu_derivative(self, x):
        if x >= 0:
            return 1
        else:
            return 0

    def sigmoid(self, x):
        return 1 / (1 + math.e ** (-x))

    def train(self, x_train, y_train, lr = 0.01, epochs = 100, batch_size = 1, verbose_frequence = 1):
        if len(x_train) % batch_size != 0:
            raise ValueError(f"batch_size需为训练集样本数量的约数")
        for _ in tqdm(range(epochs)):

            indices = list(range(len(x_train)))
            random.shuffle(indices)

            # 使用打乱的索引重新排序两个列表
            x_random_train = [x_train[index] for index in indices]
            y_random_train = [y_train[index] for index in indices]

            x_batch_list = []
            y_batch_list = []
            for i in range(len(x_random_train) // batch_size):
                x_batch_list.append(x_random_train[batch_size * i:batch_size * (i + 1)])
                y_batch_list.append(y_random_train[batch_size * i:batch_size * (i + 1)])

            epoch_loss = 0
            cnt = 0

            for batch in range(len(x_random_train) // batch_size):

                hidden_gradient = []
                output_gradient = []

                for i in range(len(x_batch_list[batch])):

                    x_sample = [x_batch_list[batch][i][index] for index in range(len(x_batch_list[batch][i]))]
                    x_sample.append(1)
                    hidden_layer_output = [0 for num in range(self.hidden_node_num)]
                    for j in range(self.hidden_node_num):
                        for k in range(self.input_node_num + 1):
                            hidden_layer_output[j] += self.hidden_weight[j][k] * x_sample[k]

                    hidden_layer_relu_output = [0 for num in range(self.hidden_node_num)]
                    for j in range(self.hidden_node_num):
                        hidden_layer_relu_output[j] = self.relu(hidden_layer_output[j])

                    hidden_layer_relu_output.append(1)

                    output_layer_output = 0
                    for j in range(self.hidden_node_num + 1):
                        output_layer_output += self.output_weight[j] * hidden_layer_relu_output[j]

                    predict = self.sigmoid(output_layer_output)

                    pred_result = 1 if predict >= 0.5 else 0

                    if pred_result == y_batch_list[batch][i]:
                        cnt += 1

                    # 交叉熵损失
                    epsilon = 1e-10
                    cross_entropy_loss = - (y_batch_list[batch][i] * np.log(predict + epsilon) + (
                                1 - y_batch_list[batch][i]) * np.log(1 - predict + epsilon))

                    epoch_loss += cross_entropy_loss  # 累加损失

                    sample_gradient = []
                    for j in range(self.hidden_node_num):
                        gradient = []
                        for k in range(self.input_node_num + 1):
                            gradient.append((predict - y_batch_list[batch][i]) * self.output_weight[j] * self.relu_derivative(
                                hidden_layer_output[j]) * x_sample[k])
                        sample_gradient.append(gradient)
                    hidden_gradient.append(sample_gradient)
                    sample_gradient = []
                    for j in range(self.hidden_node_num + 1):
                        sample_gradient.append((predict - y_batch_list[batch][i]) * hidden_layer_relu_output[j])
                    output_gradient.append(sample_gradient)

                hidden_gradient_sum = [[0 for num in range(self.input_node_num + 1)] for _ in range(self.hidden_node_num)]
                for item in range(batch_size):
                    for j in range(self.hidden_node_num):
                        for k in range(self.input_node_num + 1):
                            hidden_gradient_sum[j][k] += hidden_gradient[item][j][k]

                output_gradient_sum = [0 for num in range(self.hidden_node_num + 1)]
                for item in range(batch_size):
                    for j in range(self.hidden_node_num + 1):
                        output_gradient_sum[j] += output_gradient[item][j]

                for j in range(self.hidden_node_num):
                    for k in range(self.input_node_num + 1):
                        self.hidden_weight[j][k] -= lr * hidden_gradient_sum[j][k] / len(x_batch_list)

                for j in range(self.hidden_node_num + 1):
                    self.output_weight[j] -= lr * output_gradient_sum[j] / len(x_batch_list)
            if (_ + 1) % verbose_frequence == 0:
                print(f"第{_ + 1}代损失：{epoch_loss / len(x_train)}，准确率：{cnt / len(x_train) * 100}%")
            self.loss_values.append(epoch_loss / len(x_train))
            self.accuracy_list.append(cnt / len(x_train))

        return self.loss_values, self.accuracy_list

    def predict(self, x):
        x_sample = [x[index] for index in range(len(x))]
        x_sample.append(1)
        hidden_layer_output = [0 for num in range(self.hidden_node_num)]
        for j in range(self.hidden_node_num):
            for k in range(self.input_node_num + 1):
                hidden_layer_output[j] += self.hidden_weight[j][k] * x_sample[k]

        hidden_layer_relu_output = [0 for num in range(self.hidden_node_num)]
        for j in range(self.hidden_node_num):
            hidden_layer_relu_output[j] = self.relu(hidden_layer_output[j])

        hidden_layer_relu_output.append(1)

        output_layer_output = 0
        for j in range(self.hidden_node_num + 1):
            output_layer_output += self.output_weight[j] * hidden_layer_relu_output[j]

        predict = self.sigmoid(output_layer_output)

        pred_result = 1 if predict >= 0.5 else 0


        return pred_result


