from enum import Enum


class ComplianceTestResponsePublicDtoAutopilotTaskType(str, Enum):
    AGENT_ANTI_VIRUS_APPLICATION = "AGENT_ANTI_VIRUS_APPLICATION"
    AGENT_AUTO_UPDATES_ENABLED = "AGENT_AUTO_UPDATES_ENABLED"
    AGENT_PASSWORD_MANAGER = "AGENT_PASSWORD_MANAGER"
    AUTO_SCALE_SERVER_INSTANCES = "AUTO_SCALE_SERVER_INSTANCES"
    CAPACITY_AND_USAGE_MONITORING = "CAPACITY_AND_USAGE_MONITORING"
    COMPANY_BOD_UNIQUE = "COMPANY_BOD_UNIQUE"
    COMPANY_INFRASTRUCTURE_MFA_ENABLED = "COMPANY_INFRASTRUCTURE_MFA_ENABLED"
    COMPANY_INFRASTRUCTURE_SSL_ENABLED = "COMPANY_INFRASTRUCTURE_SSL_ENABLED"
    COMPANY_POLICIES_APPROVED = "COMPANY_POLICIES_APPROVED"
    COMPANY_POLICIES_CREATED = "COMPANY_POLICIES_CREATED"
    COMPANY_PRIORITIZE_SECURITY_ISSUES = "COMPANY_PRIORITIZE_SECURITY_ISSUES"
    COMPANY_SECURITY_COMMITTEE = "COMPANY_SECURITY_COMMITTEE"
    COMPANY_WEBSITE_SSL_CERT_NOT_EXPIRED = "COMPANY_WEBSITE_SSL_CERT_NOT_EXPIRED"
    COMPANY_WEBSITE_SSL_CERT_STRONG_CIPHERS = "COMPANY_WEBSITE_SSL_CERT_STRONG_CIPHERS"
    COMPANY_WEBSITE_SSL_ENFORCED = "COMPANY_WEBSITE_SSL_ENFORCED"
    COMPANY_WEBSITE_SSL_HAS_KNOWN_ISSUES = "COMPANY_WEBSITE_SSL_HAS_KNOWN_ISSUES"
    CONTRACTORS_ACCEPTABLE_USE_POLICY = "CONTRACTORS_ACCEPTABLE_USE_POLICY"
    CONTRACTORS_BACKGROUND_CHECK_COMPLIANCE = "CONTRACTORS_BACKGROUND_CHECK_COMPLIANCE"
    CONTRACTORS_CODE_OF_CONDUCT_POLICY = "CONTRACTORS_CODE_OF_CONDUCT_POLICY"
    CONTRACTORS_DATA_PROTECTION_POLICY = "CONTRACTORS_DATA_PROTECTION_POLICY"
    CONTRACTORS_POLICIES_APPROVED = "CONTRACTORS_POLICIES_APPROVED"
    CUSTOM_TEST = "CUSTOM_TEST"
    DRAFT_TEST = "DRAFT_TEST"
    EMPLOYEES_ACCEPTABLE_USE_POLICY = "EMPLOYEES_ACCEPTABLE_USE_POLICY"
    EMPLOYEES_BACKGROUND_CHECK_COMPLIANCE = "EMPLOYEES_BACKGROUND_CHECK_COMPLIANCE"
    EMPLOYEES_CODE_OF_CONDUCT_POLICY = "EMPLOYEES_CODE_OF_CONDUCT_POLICY"
    EMPLOYEES_DATA_PROTECTION_POLICY = "EMPLOYEES_DATA_PROTECTION_POLICY"
    EMPLOYEES_HARD_DRIVE_ENCRYPTED_COMPLIANCE = "EMPLOYEES_HARD_DRIVE_ENCRYPTED_COMPLIANCE"
    EMPLOYEES_LOCK_SCREEN_COMPLIANCE = "EMPLOYEES_LOCK_SCREEN_COMPLIANCE"
    EMPLOYEES_POLICIES_APPROVED = "EMPLOYEES_POLICIES_APPROVED"
    EMPLOYEES_SECURITY_COMPLIANCE = "EMPLOYEES_SECURITY_COMPLIANCE"
    ENCRYPTION_IN_TRANSIT = "ENCRYPTION_IN_TRANSIT"
    EXCESSIVE_PRIVILEGES_ASSIGNED = "EXCESSIVE_PRIVILEGES_ASSIGNED"
    EXTERNAL_EXPOSURE_OF_CLOUD_RESOURCES = "EXTERNAL_EXPOSURE_OF_CLOUD_RESOURCES"
    FORMER_PERSONNEL_OFFBOARDED = "FORMER_PERSONNEL_OFFBOARDED"
    IDENTITY_PROVIDER_MFA_ENABLED = "IDENTITY_PROVIDER_MFA_ENABLED"
    IDENTITY_PROVIDER_UNKNOWN_EMAIL = "IDENTITY_PROVIDER_UNKNOWN_EMAIL"
    INFRASTRUCTURE_ACLS_PUBLIC_REMOTE_ADMIN_ACCESS_RESTRICTED = (
        "INFRASTRUCTURE_ACLS_PUBLIC_REMOTE_ADMIN_ACCESS_RESTRICTED"
    )
    INFRASTRUCTURE_APPLICATION_LOAD_BALANCER_REDIRECTS_HTTP_TO_HTTPS = (
        "INFRASTRUCTURE_APPLICATION_LOAD_BALANCER_REDIRECTS_HTTP_TO_HTTPS"
    )
    INFRASTRUCTURE_APPLICATION_LOAD_BALANCER_SERVER_ERRORS_MONITORED = (
        "INFRASTRUCTURE_APPLICATION_LOAD_BALANCER_SERVER_ERRORS_MONITORED"
    )
    INFRASTRUCTURE_APPLICATION_LOAD_BALANCER_TARGET_RESPONSE_TIME_MONITORED = (
        "INFRASTRUCTURE_APPLICATION_LOAD_BALANCER_TARGET_RESPONSE_TIME_MONITORED"
    )
    INFRASTRUCTURE_APPLICATION_LOAD_BALANCER_UNHEALTHY_HOSTS_MONITORED = (
        "INFRASTRUCTURE_APPLICATION_LOAD_BALANCER_UNHEALTHY_HOSTS_MONITORED"
    )
    INFRASTRUCTURE_AUDIT_LOGS_ENABLED_FOR_EKS_CLUSTER = "INFRASTRUCTURE_AUDIT_LOGS_ENABLED_FOR_EKS_CLUSTER"
    INFRASTRUCTURE_AUTHORIZATION_DETAILS = "INFRASTRUCTURE_AUTHORIZATION_DETAILS"
    INFRASTRUCTURE_AUTOMATED_BACKUPS = "INFRASTRUCTURE_AUTOMATED_BACKUPS"
    INFRASTRUCTURE_AUTOMATIC_REPAIRS = "INFRASTRUCTURE_AUTOMATIC_REPAIRS"
    INFRASTRUCTURE_AUTOMATIC_SOFTWARE_UPDATES = "INFRASTRUCTURE_AUTOMATIC_SOFTWARE_UPDATES"
    INFRASTRUCTURE_AUTO_SCALING = "INFRASTRUCTURE_AUTO_SCALING"
    INFRASTRUCTURE_BACKUP_RETENTION = "INFRASTRUCTURE_BACKUP_RETENTION"
    INFRASTRUCTURE_BROAD_NETWORK_ACCESS_PATTERNS = "INFRASTRUCTURE_BROAD_NETWORK_ACCESS_PATTERNS"
    INFRASTRUCTURE_BROAD_POLICY_ACCESS_PATTERNS = "INFRASTRUCTURE_BROAD_POLICY_ACCESS_PATTERNS"
    INFRASTRUCTURE_BUCKET_ACCESS_LOGGING = "INFRASTRUCTURE_BUCKET_ACCESS_LOGGING"
    INFRASTRUCTURE_CLASSIC_LOAD_BALANCER_LATENCY_MONITORED = "INFRASTRUCTURE_CLASSIC_LOAD_BALANCER_LATENCY_MONITORED"
    INFRASTRUCTURE_CLASSIC_LOAD_BALANCER_SERVER_ERRORS_MONITORED = (
        "INFRASTRUCTURE_CLASSIC_LOAD_BALANCER_SERVER_ERRORS_MONITORED"
    )
    INFRASTRUCTURE_CLASSIC_LOAD_BALANCER_UNHEALTHY_HOSTS_MONITORED = (
        "INFRASTRUCTURE_CLASSIC_LOAD_BALANCER_UNHEALTHY_HOSTS_MONITORED"
    )
    INFRASTRUCTURE_CLOUDTRAIL_LOG_FILE_INTEGRITY = "INFRASTRUCTURE_CLOUDTRAIL_LOG_FILE_INTEGRITY"
    INFRASTRUCTURE_CLOUD_DATA_FREE_STORAGE = "INFRASTRUCTURE_CLOUD_DATA_FREE_STORAGE"
    INFRASTRUCTURE_CLOUD_DATA_MONITOR_CPU_LOAD = "INFRASTRUCTURE_CLOUD_DATA_MONITOR_CPU_LOAD"
    INFRASTRUCTURE_CLOUD_TRAIL_LOGS_ENCRYPTED = "INFRASTRUCTURE_CLOUD_TRAIL_LOGS_ENCRYPTED"
    INFRASTRUCTURE_CMK_ROTATION = "INFRASTRUCTURE_CMK_ROTATION"
    INFRASTRUCTURE_CONNECTION_DRAINING = "INFRASTRUCTURE_CONNECTION_DRAINING"
    INFRASTRUCTURE_CREDENTIAL_REPORT = "INFRASTRUCTURE_CREDENTIAL_REPORT"
    INFRASTRUCTURE_DAILY_BACKUP_JOB_STATUS_MONITORED = "INFRASTRUCTURE_DAILY_BACKUP_JOB_STATUS_MONITORED"
    INFRASTRUCTURE_DATABASE_WRITES_IO_MONITORED = "INFRASTRUCTURE_DATABASE_WRITES_IO_MONITORED"
    INFRASTRUCTURE_DATA_BACKUPS = "INFRASTRUCTURE_DATA_BACKUPS"
    INFRASTRUCTURE_DATA_ENCRYPTED = "INFRASTRUCTURE_DATA_ENCRYPTED"
    INFRASTRUCTURE_DATA_MONITOR_CPU = "INFRASTRUCTURE_DATA_MONITOR_CPU"
    INFRASTRUCTURE_DATA_MONITOR_FREE_STORAGE = "INFRASTRUCTURE_DATA_MONITOR_FREE_STORAGE"
    INFRASTRUCTURE_DATA_MONITOR_READ_IO = "INFRASTRUCTURE_DATA_MONITOR_READ_IO"
    INFRASTRUCTURE_DATA_MONITOR_WRITE_IO = "INFRASTRUCTURE_DATA_MONITOR_WRITE_IO"
    INFRASTRUCTURE_DATA_MULTI_AZ = "INFRASTRUCTURE_DATA_MULTI_AZ"
    INFRASTRUCTURE_DATA_RETENTION = "INFRASTRUCTURE_DATA_RETENTION"
    INFRASTRUCTURE_DELETION_PROTECTION = "INFRASTRUCTURE_DELETION_PROTECTION"
    INFRASTRUCTURE_DENY_BY_DEFAULT = "INFRASTRUCTURE_DENY_BY_DEFAULT"
    INFRASTRUCTURE_DISABLE_DEFAULT_ACCOUNTS = "INFRASTRUCTURE_DISABLE_DEFAULT_ACCOUNTS"
    INFRASTRUCTURE_DISALLOWS_TRAFFIC = "INFRASTRUCTURE_DISALLOWS_TRAFFIC"
    INFRASTRUCTURE_DYNAMODB_POINT_IN_TIME_ENABLED = "INFRASTRUCTURE_DYNAMODB_POINT_IN_TIME_ENABLED"
    INFRASTRUCTURE_EBS_VOLUME_ENCRYPTION = "INFRASTRUCTURE_EBS_VOLUME_ENCRYPTION"
    INFRASTRUCTURE_EC2_INSTANCES_IMDSV1_DISABLED = "INFRASTRUCTURE_EC2_INSTANCES_IMDSV1_DISABLED"
    INFRASTRUCTURE_EFS_ENCRYPTED_AT_REST = "INFRASTRUCTURE_EFS_ENCRYPTED_AT_REST"
    INFRASTRUCTURE_ENCRYPTION_IN_TRANSIT = "INFRASTRUCTURE_ENCRYPTION_IN_TRANSIT"
    INFRASTRUCTURE_FAILED_BACKUPS_ADDRESSED_IN_TIMELY_MANNER = (
        "INFRASTRUCTURE_FAILED_BACKUPS_ADDRESSED_IN_TIMELY_MANNER"
    )
    INFRASTRUCTURE_FAILED_BACKUP_ALERTS = "INFRASTRUCTURE_FAILED_BACKUP_ALERTS"
    INFRASTRUCTURE_HARDWARE_MFA_FOR_ROOT_ACCOUNT = "INFRASTRUCTURE_HARDWARE_MFA_FOR_ROOT_ACCOUNT"
    INFRASTRUCTURE_HAS_BALANCERS = "INFRASTRUCTURE_HAS_BALANCERS"
    INFRASTRUCTURE_HAS_WAF = "INFRASTRUCTURE_HAS_WAF"
    INFRASTRUCTURE_HIGH_AVAILABILITY = "INFRASTRUCTURE_HIGH_AVAILABILITY"
    INFRASTRUCTURE_IAM_ACCESS_KEY_ROTATION = "INFRASTRUCTURE_IAM_ACCESS_KEY_ROTATION"
    INFRASTRUCTURE_IAM_GROUP_BASED_ACCESS_CONTROL = "INFRASTRUCTURE_IAM_GROUP_BASED_ACCESS_CONTROL"
    INFRASTRUCTURE_IAM_PASSWORD_MINIMUM_LENGTH = "INFRASTRUCTURE_IAM_PASSWORD_MINIMUM_LENGTH"
    INFRASTRUCTURE_IAM_PASSWORD_REUSE = "INFRASTRUCTURE_IAM_PASSWORD_REUSE"
    INFRASTRUCTURE_IAM_PRINCIPLE_OF_LEAST_PRIVILEGE = "INFRASTRUCTURE_IAM_PRINCIPLE_OF_LEAST_PRIVILEGE"
    INFRASTRUCTURE_IAM_UNUSED_CREDENTIALS = "INFRASTRUCTURE_IAM_UNUSED_CREDENTIALS"
    INFRASTRUCTURE_INSTANCE_MONITOR_CPU = "INFRASTRUCTURE_INSTANCE_MONITOR_CPU"
    INFRASTRUCTURE_KEY_ROTATION = "INFRASTRUCTURE_KEY_ROTATION"
    INFRASTRUCTURE_LAMBDA_ERROR_RATE_MONITORED = "INFRASTRUCTURE_LAMBDA_ERROR_RATE_MONITORED"
    INFRASTRUCTURE_LOGGING_ENABLED = "INFRASTRUCTURE_LOGGING_ENABLED"
    INFRASTRUCTURE_LOG_ALERT_FOR_CREATE_POLICY_ASSIGNMENT = "INFRASTRUCTURE_LOG_ALERT_FOR_CREATE_POLICY_ASSIGNMENT"
    INFRASTRUCTURE_LOG_ALERT_FOR_DELETE_NETWORK_SECURITY_GROUP = (
        "INFRASTRUCTURE_LOG_ALERT_FOR_DELETE_NETWORK_SECURITY_GROUP"
    )
    INFRASTRUCTURE_LOG_ALERT_FOR_DELETE_POLICY_ASSIGNMENT = "INFRASTRUCTURE_LOG_ALERT_FOR_DELETE_POLICY_ASSIGNMENT"
    INFRASTRUCTURE_LOG_ALERT_FOR_DELETE_PUBLIC_IP_ADDRESS = "INFRASTRUCTURE_LOG_ALERT_FOR_DELETE_PUBLIC_IP_ADDRESS"
    INFRASTRUCTURE_LOG_ALERT_FOR_DELETE_SECURITY_SOLUTION = "INFRASTRUCTURE_LOG_ALERT_FOR_DELETE_SECURITY_SOLUTION"
    INFRASTRUCTURE_LOG_ALERT_FOR_MANAGE_NETWORK_SECURITY_GROUP = (
        "INFRASTRUCTURE_LOG_ALERT_FOR_MANAGE_NETWORK_SECURITY_GROUP"
    )
    INFRASTRUCTURE_LOG_ALERT_FOR_MANAGE_PUBLIC_IP_ADDRESS_RULE = (
        "INFRASTRUCTURE_LOG_ALERT_FOR_MANAGE_PUBLIC_IP_ADDRESS_RULE"
    )
    INFRASTRUCTURE_LOG_ALERT_FOR_MANAGE_SECURITY_SOLUTION = "INFRASTRUCTURE_LOG_ALERT_FOR_MANAGE_SECURITY_SOLUTION"
    INFRASTRUCTURE_LOG_INTEGRITY = "INFRASTRUCTURE_LOG_INTEGRITY"
    INFRASTRUCTURE_LOG_RETENTION = "INFRASTRUCTURE_LOG_RETENTION"
    INFRASTRUCTURE_MFA_FOR_ROOT_ACCOUNT = "INFRASTRUCTURE_MFA_FOR_ROOT_ACCOUNT"
    INFRASTRUCTURE_NSG_SSH_PUBLIC_ACCESS_RESTRICTED = "INFRASTRUCTURE_NSG_SSH_PUBLIC_ACCESS_RESTRICTED"
    INFRASTRUCTURE_POLICY_BASED_ACCESS_CONTROL = "INFRASTRUCTURE_POLICY_BASED_ACCESS_CONTROL"
    INFRASTRUCTURE_POSTGRESQL_DATABASE_SERVER_LOG_CHECKPOINTS = (
        "INFRASTRUCTURE_POSTGRESQL_DATABASE_SERVER_LOG_CHECKPOINTS"
    )
    INFRASTRUCTURE_PRIVATE_ACCESS_TO_CLUSTERS_CONTROL_PLANE_IS_RESTRICTED = (
        "INFRASTRUCTURE_PRIVATE_ACCESS_TO_CLUSTERS_CONTROL_PLANE_IS_RESTRICTED"
    )
    INFRASTRUCTURE_PUBLIC_ACCESS_RESTRICTED = "INFRASTRUCTURE_PUBLIC_ACCESS_RESTRICTED"
    INFRASTRUCTURE_PUBLIC_ACCESS_TO_CLUSTERS_CONTROL_PLANE_IS_RESTRICTED = (
        "INFRASTRUCTURE_PUBLIC_ACCESS_TO_CLUSTERS_CONTROL_PLANE_IS_RESTRICTED"
    )
    INFRASTRUCTURE_PUBLIC_SSH_DENIED = "INFRASTRUCTURE_PUBLIC_SSH_DENIED"
    INFRASTRUCTURE_QUEUE_MONITOR_MESSAGE_AGE = "INFRASTRUCTURE_QUEUE_MONITOR_MESSAGE_AGE"
    INFRASTRUCTURE_RBAC = "INFRASTRUCTURE_RBAC"
    INFRASTRUCTURE_RDS_MINIMUM_VERSION_UPGRADE = "INFRASTRUCTURE_RDS_MINIMUM_VERSION_UPGRADE"
    INFRASTRUCTURE_RDS_PUBLIC_ACCESS_RESTRICTED = "INFRASTRUCTURE_RDS_PUBLIC_ACCESS_RESTRICTED"
    INFRASTRUCTURE_ROOT_ACCOUNT_UNUSED = "INFRASTRUCTURE_ROOT_ACCOUNT_UNUSED"
    INFRASTRUCTURE_RUNTIME_CONFIGURATION = "INFRASTRUCTURE_RUNTIME_CONFIGURATION"
    INFRASTRUCTURE_S3_HTTP_REQUEST_DENIED = "INFRASTRUCTURE_S3_HTTP_REQUEST_DENIED"
    INFRASTRUCTURE_S3_OBJECT_LEVEL_LOGGING_FOR_RW_EVENTS = "INFRASTRUCTURE_S3_OBJECT_LEVEL_LOGGING_FOR_RW_EVENTS"
    INFRASTRUCTURE_SECRET_ROTATION = "INFRASTRUCTURE_SECRET_ROTATION"
    INFRASTRUCTURE_SECURE_API_VERSION = "INFRASTRUCTURE_SECURE_API_VERSION"
    INFRASTRUCTURE_SECURITY_GROUPS = "INFRASTRUCTURE_SECURITY_GROUPS"
    INFRASTRUCTURE_SECURITY_GROUPS_HTTP_ACCESS_RESTRICTED = "INFRASTRUCTURE_SECURITY_GROUPS_HTTP_ACCESS_RESTRICTED"
    INFRASTRUCTURE_SECURITY_GROUPS_RESTRICT_PUBLIC_RDP_ACCESS = (
        "INFRASTRUCTURE_SECURITY_GROUPS_RESTRICT_PUBLIC_RDP_ACCESS"
    )
    INFRASTRUCTURE_SQL_FREEABLE_MEMORY_MONITORED = "INFRASTRUCTURE_SQL_FREEABLE_MEMORY_MONITORED"
    INFRASTRUCTURE_SQL_SERVERS_AUDITING = "INFRASTRUCTURE_SQL_SERVERS_AUDITING"
    INFRASTRUCTURE_STORAGE_ACCOUNTS_ACCESSED_VIA_PRIVATE_ENDPOINTS = (
        "INFRASTRUCTURE_STORAGE_ACCOUNTS_ACCESSED_VIA_PRIVATE_ENDPOINTS"
    )
    INFRASTRUCTURE_STORAGE_ACCOUNTS_SECURE_TLS_CONFIGURATION = (
        "INFRASTRUCTURE_STORAGE_ACCOUNTS_SECURE_TLS_CONFIGURATION"
    )
    INFRASTRUCTURE_STORAGE_ENCRYPTED = "INFRASTRUCTURE_STORAGE_ENCRYPTED"
    INFRASTRUCTURE_STORAGE_RESTRICTED = "INFRASTRUCTURE_STORAGE_RESTRICTED"
    INFRASTRUCTURE_STORAGE_VERSIONING = "INFRASTRUCTURE_STORAGE_VERSIONING"
    INFRASTRUCTURE_STORAGE_WAF = "INFRASTRUCTURE_STORAGE_WAF"
    INFRASTRUCTURE_TAGGING = "INFRASTRUCTURE_TAGGING"
    INFRASTRUCTURE_TDE_ENABLED = "INFRASTRUCTURE_TDE_ENABLED"
    INFRASTRUCTURE_TLS_CIPHERS = "INFRASTRUCTURE_TLS_CIPHERS"
    INFRASTRUCTURE_TLS_VERSION = "INFRASTRUCTURE_TLS_VERSION"
    INFRASTRUCTURE_VERSIONING_ENABLED = "INFRASTRUCTURE_VERSIONING_ENABLED"
    INFRASTRUCTURE_VPC_CONFIGURATION = "INFRASTRUCTURE_VPC_CONFIGURATION"
    INFRASTRUCTURE_VPC_DEFAULT_SECURITY_GROUPS_RESTRICT_ALL_TRAFFIC = (
        "INFRASTRUCTURE_VPC_DEFAULT_SECURITY_GROUPS_RESTRICT_ALL_TRAFFIC"
    )
    INFRASTRUCTURE_VPC_FLOW_LOGGING = "INFRASTRUCTURE_VPC_FLOW_LOGGING"
    INFRASTRUCTURE_WAF_ENABLED = "INFRASTRUCTURE_WAF_ENABLED"
    INFRASTRUCTURE_WEB_APP_REDIRECTS_HTTP_TRAFFIC_TO_HTTPS = "INFRASTRUCTURE_WEB_APP_REDIRECTS_HTTP_TRAFFIC_TO_HTTPS"
    INFRASTRUCTURE_ZONE_REDUNDANCY = "INFRASTRUCTURE_ZONE_REDUNDANCY"
    INTERNAL_DOCUMENT_EMPLOYEE_AGREEMENT = "INTERNAL_DOCUMENT_EMPLOYEE_AGREEMENT"
    INTERNAL_DOCUMENT_ENGINEERING_JOB_DESCRIPTION = "INTERNAL_DOCUMENT_ENGINEERING_JOB_DESCRIPTION"
    INTERNAL_DOCUMENT_MSA = "INTERNAL_DOCUMENT_MSA"
    INTERNAL_DOCUMENT_ORGANIZATIONAL_CHART = "INTERNAL_DOCUMENT_ORGANIZATIONAL_CHART"
    INTERNAL_DOCUMENT_PERFORMANCE_EVALUATION = "INTERNAL_DOCUMENT_PERFORMANCE_EVALUATION"
    INTERNAL_INFRASTRUCTURE_IDENTITIES_REMOVED = "INTERNAL_INFRASTRUCTURE_IDENTITIES_REMOVED"
    INTERNAL_INFRASTRUCTURE_IDENTITIES_UNIQUE = "INTERNAL_INFRASTRUCTURE_IDENTITIES_UNIQUE"
    INTERNAL_INFRASTRUCTURE_LINKED = "INTERNAL_INFRASTRUCTURE_LINKED"
    INTERNAL_POLICY_ACCEPTABLE_USE = "INTERNAL_POLICY_ACCEPTABLE_USE"
    INTERNAL_POLICY_ACCESS_CONTROL = "INTERNAL_POLICY_ACCESS_CONTROL"
    INTERNAL_POLICY_BACKUPS = "INTERNAL_POLICY_BACKUPS"
    INTERNAL_POLICY_CLEAN_DESK = "INTERNAL_POLICY_CLEAN_DESK"
    INTERNAL_POLICY_CODE_OF_CONDUCT = "INTERNAL_POLICY_CODE_OF_CONDUCT"
    INTERNAL_POLICY_CUSTOMER_DATA_RETENTION = "INTERNAL_POLICY_CUSTOMER_DATA_RETENTION"
    INTERNAL_POLICY_DATA_CLASSIFICATION = "INTERNAL_POLICY_DATA_CLASSIFICATION"
    INTERNAL_POLICY_DATA_PROTECTION = "INTERNAL_POLICY_DATA_PROTECTION"
    INTERNAL_POLICY_DATA_RETENTION = "INTERNAL_POLICY_DATA_RETENTION"
    INTERNAL_POLICY_DISASTER_RECOVERY = "INTERNAL_POLICY_DISASTER_RECOVERY"
    INTERNAL_POLICY_EMPLOYEE_ACCESS_TO_CUSTOMER_DATA = "INTERNAL_POLICY_EMPLOYEE_ACCESS_TO_CUSTOMER_DATA"
    INTERNAL_POLICY_EMPLOYEE_CONFIDENTIALITY = "INTERNAL_POLICY_EMPLOYEE_CONFIDENTIALITY"
    INTERNAL_POLICY_ENCRYPTION = "INTERNAL_POLICY_ENCRYPTION"
    INTERNAL_POLICY_INCIDENT_RESPONSE = "INTERNAL_POLICY_INCIDENT_RESPONSE"
    INTERNAL_POLICY_INCIDENT_RESPONSE_FOLLOW_UPS = "INTERNAL_POLICY_INCIDENT_RESPONSE_FOLLOW_UPS"
    INTERNAL_POLICY_INCIDENT_RESPONSE_LESSONS_LEARNED = "INTERNAL_POLICY_INCIDENT_RESPONSE_LESSONS_LEARNED"
    INTERNAL_POLICY_INCIDENT_RESPONSE_TEAM = "INTERNAL_POLICY_INCIDENT_RESPONSE_TEAM"
    INTERNAL_POLICY_INFORMATION_SECURITY = "INTERNAL_POLICY_INFORMATION_SECURITY"
    INTERNAL_POLICY_PASSWORD = "INTERNAL_POLICY_PASSWORD"
    INTERNAL_POLICY_PASSWORD_MANAGER_REQUIRED = "INTERNAL_POLICY_PASSWORD_MANAGER_REQUIRED"
    INTERNAL_POLICY_PHYSICAL_SECURITY = "INTERNAL_POLICY_PHYSICAL_SECURITY"
    INTERNAL_POLICY_RESPONSIBLE_DISCLOSURE = "INTERNAL_POLICY_RESPONSIBLE_DISCLOSURE"
    INTERNAL_POLICY_RISK_ASSESSMENT = "INTERNAL_POLICY_RISK_ASSESSMENT"
    INTERNAL_POLICY_RISK_REMEDIATION = "INTERNAL_POLICY_RISK_REMEDIATION"
    INTERNAL_POLICY_SDLC = "INTERNAL_POLICY_SDLC"
    INTERNAL_POLICY_SECURITY_AWARENESS = "INTERNAL_POLICY_SECURITY_AWARENESS"
    INTERNAL_POLICY_SECURITY_ENCRYPTION = "INTERNAL_POLICY_SECURITY_ENCRYPTION"
    INTERNAL_POLICY_SENSITIVE_DATA_DISPOSAL = "INTERNAL_POLICY_SENSITIVE_DATA_DISPOSAL"
    INTERNAL_POLICY_SYSTEM_ACCESS_CONTROL = "INTERNAL_POLICY_SYSTEM_ACCESS_CONTROL"
    INTERNAL_POLICY_VULNERABILITY_MANAGEMENT = "INTERNAL_POLICY_VULNERABILITY_MANAGEMENT"
    INTERNAL_REPORT_ARCHITECTURAL_DIAGRAM = "INTERNAL_REPORT_ARCHITECTURAL_DIAGRAM"
    INTERNAL_REPORT_BACKUP_AND_COMPLETENESS = "INTERNAL_REPORT_BACKUP_AND_COMPLETENESS"
    INTERNAL_REPORT_DISASTER_RECOVERY = "INTERNAL_REPORT_DISASTER_RECOVERY"
    INTERNAL_REPORT_NETWORK_DIAGRAM = "INTERNAL_REPORT_NETWORK_DIAGRAM"
    INTERNAL_REPORT_PENETRATION = "INTERNAL_REPORT_PENETRATION"
    INTERNAL_REPORT_RISK_ASSESSMENT = "INTERNAL_REPORT_RISK_ASSESSMENT"
    INTERNAL_REPORT_RISK_REMEDIATION = "INTERNAL_REPORT_RISK_REMEDIATION"
    INTERNAL_REPORT_VULNERABILITY = "INTERNAL_REPORT_VULNERABILITY"
    INTERNAL_URL_EXTERNAL_JOBS = "INTERNAL_URL_EXTERNAL_JOBS"
    INTERNAL_URL_PRIVACY_POLICY = "INTERNAL_URL_PRIVACY_POLICY"
    INTERNAL_URL_SUPPORT = "INTERNAL_URL_SUPPORT"
    INTERNAL_URL_TERMS_OF_SERVICE = "INTERNAL_URL_TERMS_OF_SERVICE"
    INTERNAL_VERSION_CONTROL_IDENTITIES_ONLY_AUTHORIZED_ACCESS = (
        "INTERNAL_VERSION_CONTROL_IDENTITIES_ONLY_AUTHORIZED_ACCESS"
    )
    INTERNAL_VERSION_CONTROL_IDENTITIES_REMOVED = "INTERNAL_VERSION_CONTROL_IDENTITIES_REMOVED"
    INTERNAL_VERSION_CONTROL_IDENTITIES_UNIQUE = "INTERNAL_VERSION_CONTROL_IDENTITIES_UNIQUE"
    LOGS_ARE_CENTRALLY_STORED = "LOGS_ARE_CENTRALLY_STORED"
    LOGS_ARE_RETAINED_FOR_365_DAYS = "LOGS_ARE_RETAINED_FOR_365_DAYS"
    LOGS_MONITORED_FOR_SUSPICIOUS_ACTIVITY = "LOGS_MONITORED_FOR_SUSPICIOUS_ACTIVITY"
    ONLY_AUTHORIZED_USERS_CAN_ACCESS_LOG_SINKS = "ONLY_AUTHORIZED_USERS_CAN_ACCESS_LOG_SINKS"
    VERSION_CONTROL_CODE_REVIEW_PROCESS = "VERSION_CONTROL_CODE_REVIEW_PROCESS"
    VERSION_CONTROL_ENABLED = "VERSION_CONTROL_ENABLED"
    VERSION_CONTROL_MFA_ENABLED = "VERSION_CONTROL_MFA_ENABLED"
    VERSION_CONTROL_WRITE_ACCESS_TO_PRODUCTION_CODE = "VERSION_CONTROL_WRITE_ACCESS_TO_PRODUCTION_CODE"
    VERSION_CONTROL_WRITE_ACCESS_TO_REPOSITORY = "VERSION_CONTROL_WRITE_ACCESS_TO_REPOSITORY"
    VULNERABILITY_CRITICAL_ADDRESSED = "VULNERABILITY_CRITICAL_ADDRESSED"
    VULNERABILITY_CRITICAL_ADDRESSED_AIKIDO = "VULNERABILITY_CRITICAL_ADDRESSED_AIKIDO"
    VULNERABILITY_CRITICAL_ADDRESSED_ARNICA = "VULNERABILITY_CRITICAL_ADDRESSED_ARNICA"
    VULNERABILITY_CRITICAL_ADDRESSED_CROWDSTRIKE_FALCON_EXPOSURE_MANAGEMENT = (
        "VULNERABILITY_CRITICAL_ADDRESSED_CROWDSTRIKE_FALCON_EXPOSURE_MANAGEMENT"
    )
    VULNERABILITY_CRITICAL_ADDRESSED_MS_DEFENDER_VMS = "VULNERABILITY_CRITICAL_ADDRESSED_MS_DEFENDER_VMS"
    VULNERABILITY_CRITICAL_ADDRESSED_QUALYS = "VULNERABILITY_CRITICAL_ADDRESSED_QUALYS"
    VULNERABILITY_CRITICAL_ADDRESSED_RAPID7_VMS = "VULNERABILITY_CRITICAL_ADDRESSED_RAPID7_VMS"
    VULNERABILITY_CRITICAL_ADDRESSED_SEMGREP = "VULNERABILITY_CRITICAL_ADDRESSED_SEMGREP"
    VULNERABILITY_CRITICAL_ADDRESSED_SENTINELONE_SINGULARITY_VULNERABILITY_MANAGEMENT = (
        "VULNERABILITY_CRITICAL_ADDRESSED_SENTINELONE_SINGULARITY_VULNERABILITY_MANAGEMENT"
    )
    VULNERABILITY_CRITICAL_ADDRESSED_SNYK = "VULNERABILITY_CRITICAL_ADDRESSED_SNYK"
    VULNERABILITY_CRITICAL_ADDRESSED_TENABLE_VULNERABILITY_MANAGEMENT = (
        "VULNERABILITY_CRITICAL_ADDRESSED_TENABLE_VULNERABILITY_MANAGEMENT"
    )
    VULNERABILITY_CRITICAL_ADDRESSED_WIZ_CODE = "VULNERABILITY_CRITICAL_ADDRESSED_WIZ_CODE"
    VULNERABILITY_CRITICAL_ADDRESSED_WIZ_VMS = "VULNERABILITY_CRITICAL_ADDRESSED_WIZ_VMS"
    VULNERABILITY_HIGH_ADDRESSED = "VULNERABILITY_HIGH_ADDRESSED"
    VULNERABILITY_HIGH_ADDRESSED_AIKIDO = "VULNERABILITY_HIGH_ADDRESSED_AIKIDO"
    VULNERABILITY_HIGH_ADDRESSED_ARNICA = "VULNERABILITY_HIGH_ADDRESSED_ARNICA"
    VULNERABILITY_HIGH_ADDRESSED_CROWDSTRIKE_FALCON_EXPOSURE_MANAGEMENT = (
        "VULNERABILITY_HIGH_ADDRESSED_CROWDSTRIKE_FALCON_EXPOSURE_MANAGEMENT"
    )
    VULNERABILITY_HIGH_ADDRESSED_MS_DEFENDER_VMS = "VULNERABILITY_HIGH_ADDRESSED_MS_DEFENDER_VMS"
    VULNERABILITY_HIGH_ADDRESSED_QUALYS = "VULNERABILITY_HIGH_ADDRESSED_QUALYS"
    VULNERABILITY_HIGH_ADDRESSED_RAPID7_VMS = "VULNERABILITY_HIGH_ADDRESSED_RAPID7_VMS"
    VULNERABILITY_HIGH_ADDRESSED_SEMGREP = "VULNERABILITY_HIGH_ADDRESSED_SEMGREP"
    VULNERABILITY_HIGH_ADDRESSED_SENTINELONE_SINGULARITY_VULNERABILITY_MANAGEMENT = (
        "VULNERABILITY_HIGH_ADDRESSED_SENTINELONE_SINGULARITY_VULNERABILITY_MANAGEMENT"
    )
    VULNERABILITY_HIGH_ADDRESSED_SNYK = "VULNERABILITY_HIGH_ADDRESSED_SNYK"
    VULNERABILITY_HIGH_ADDRESSED_TENABLE_VULNERABILITY_MANAGEMENT = (
        "VULNERABILITY_HIGH_ADDRESSED_TENABLE_VULNERABILITY_MANAGEMENT"
    )
    VULNERABILITY_HIGH_ADDRESSED_WIZ_CODE = "VULNERABILITY_HIGH_ADDRESSED_WIZ_CODE"
    VULNERABILITY_HIGH_ADDRESSED_WIZ_VMS = "VULNERABILITY_HIGH_ADDRESSED_WIZ_VMS"

    def __str__(self) -> str:
        return str(self.value)
