from collections.abc import Mapping
from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="EditControlRequestPublicDto")


@_attrs_define
class EditControlRequestPublicDto:
    """
    Attributes:
        name (str): The name of the control Example: Good Control Name.
        description (str): The description of the control Example: A very good description.
        question (Union[Unset, str]): The question of the control Example: A very good question.
        code (Union[Unset, str]): The control code Example: DRA-69.
        activity (Union[Unset, str]): The activity of the control Example: A very good activity.
    """

    name: str
    description: str
    question: Union[Unset, str] = UNSET
    code: Union[Unset, str] = UNSET
    activity: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        name = self.name

        description = self.description

        question = self.question

        code = self.code

        activity = self.activity

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
                "description": description,
            }
        )
        if question is not UNSET:
            field_dict["question"] = question
        if code is not UNSET:
            field_dict["code"] = code
        if activity is not UNSET:
            field_dict["activity"] = activity

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        name = d.pop("name")

        description = d.pop("description")

        question = d.pop("question", UNSET)

        code = d.pop("code", UNSET)

        activity = d.pop("activity", UNSET)

        edit_control_request_public_dto = cls(
            name=name,
            description=description,
            question=question,
            code=code,
            activity=activity,
        )

        edit_control_request_public_dto.additional_properties = d
        return edit_control_request_public_dto

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
