/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterFilter;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;

public class QueryIterFilterExpr
extends QueryIterFilter {
    Expr expr;

    public QueryIterFilterExpr(QueryIterator input, Expr expr, ExecutionContext context) {
        super(input, context);
        this.expr = expr;
    }

    public boolean accept(Binding binding) {
        boolean passFilter = false;
        try {
            Binding b = binding;
            return this.expr.isSatisfied(b, super.getExecContext());
        }
        catch (ExprException ex) {
            return false;
        }
        catch (Exception ex) {
            ALog.warn(this, "General exception in " + this.expr, (Throwable)ex);
            return false;
        }
    }

    protected void details(IndentedWriter out, SerializationContext cxt) {
        out.print(Utils.className(this));
        out.print(" ");
        ExprUtils.fmtSPARQL(out, this.expr, cxt.getPrefixMapping());
    }
}

