/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingKey;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import java.util.HashMap;
import java.util.Map;

public abstract class AggregatorBase
implements Aggregator {
    private Map buckets = new HashMap();

    public final void accumulate(BindingKey key, Binding binding) {
        Accumulator acc = (Accumulator)this.buckets.get(key);
        if (acc == null) {
            acc = this.createAccumulator();
            this.buckets.put(key, acc);
        }
        acc.accumulate(binding);
    }

    protected abstract Accumulator createAccumulator();

    public Node getValue(BindingKey key) {
        Accumulator acc = (Accumulator)this.buckets.get(key);
        if (acc == null) {
            throw new ARQInternalErrorException("Null for accumulator");
        }
        return acc.getValue().asNode();
    }

    public String key() {
        return this.toPrefixString();
    }
}

