/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.serializer.FmtExpr;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public class FmtExprPrefix
implements FmtExpr {
    static final boolean ONELINE = true;
    IndentedWriter out;
    SerializationContext context;
    FmtExprPrefixVisitor visitor;

    public FmtExprPrefix(IndentedWriter writer, PrefixMapping pmap) {
        this.visitor = new FmtExprPrefixVisitor(writer, pmap);
    }

    public FmtExprPrefix(IndentedWriter writer, SerializationContext cxt) {
        this.visitor = new FmtExprPrefixVisitor(writer, cxt);
    }

    public void format(Expr expr) {
        expr.visit(this.visitor);
    }

    public static void format(IndentedWriter out, PrefixMapping pmap, Expr expr) {
        FmtExprPrefix fmt = new FmtExprPrefix(out, new SerializationContext(pmap));
        fmt.format(expr);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Expr expr) {
        FmtExprPrefix fmt = new FmtExprPrefix(out, cxt);
        fmt.format(expr);
    }

    class FmtExprPrefixVisitor
    implements ExprVisitor {
        public FmtExprPrefixVisitor(IndentedWriter writer, PrefixMapping pm) {
            this(writer, new SerializationContext(pm, null));
        }

        public FmtExprPrefixVisitor(IndentedWriter writer, SerializationContext qCxt) {
            FmtExprPrefix.this.out = writer;
            FmtExprPrefix.this.context = qCxt;
            if (FmtExprPrefix.this.context == null) {
                FmtExprPrefix.this.context = new SerializationContext();
            }
        }

        public void startVisit() {
        }

        public void visit(ExprFunction func) {
            Expr expr;
            FmtExprPrefix.this.out.print("(");
            String n = null;
            if (func.getOpName() != null) {
                n = func.getOpName();
            }
            if (n == null) {
                n = func.getFunctionPrintName(FmtExprPrefix.this.context);
            }
            FmtExprPrefix.this.out.print(n);
            FmtExprPrefix.this.out.incIndent(2);
            int i = 1;
            while ((expr = func.getArg(i)) != null) {
                FmtExprPrefix.this.out.print(' ');
                expr.visit(this);
                ++i;
            }
            FmtExprPrefix.this.out.print(")");
            FmtExprPrefix.this.out.decIndent(2);
        }

        public void visit(NodeValue nv) {
            FmtExprPrefix.this.out.print(nv.asQuotedString(FmtExprPrefix.this.context));
        }

        public void visit(ExprVar nv) {
            FmtExprPrefix.this.out.print(nv.toPrefixString());
        }

        public void finishVisit() {
            FmtExprPrefix.this.out.flush();
        }

        private void endLine() {
            FmtExprPrefix.this.out.print(' ');
        }
    }
}

